/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.AbstractDiffExtensionFactory;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UMLAbstractDiffExtensionFactory
extends AbstractDiffExtensionFactory {
    private final Predicate<Diff> REFINING_PREDICATE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return UMLAbstractDiffExtensionFactory.this.isPartOfRefiningDifference(diff);
        }
    };
    private final Predicate<Diff> REQUIRES_ADD_DISCRIMINANT_PREDICATE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return UMLAbstractDiffExtensionFactory.this.getExtensionKind().isInstance(diff) && ((UMLDiff)diff).getKind().equals((Object)DifferenceKind.ADD);
        }
    };
    private final Predicate<Diff> REQUIRES_CHANGE_DISCRIMINANT_PREDICATE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return UMLAbstractDiffExtensionFactory.this.getExtensionKind().isInstance(diff) && ((UMLDiff)diff).getKind().equals((Object)DifferenceKind.CHANGE);
        }
    };
    private CompareSwitch<DifferenceKind> differenceKindCompareSwitch = new CompareSwitch<DifferenceKind>(){

        public DifferenceKind caseAttributeChange(AttributeChange object) {
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseAttributeChange(object);
        }

        public DifferenceKind caseReferenceChange(ReferenceChange object) {
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseReferenceChange(object);
        }

        public DifferenceKind caseResourceAttachmentChange(ResourceAttachmentChange object) {
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (UMLAbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseResourceAttachmentChange(object);
        }
    };

    @Override
    public boolean handles(Diff input) {
        return this.getRelatedExtensionKind(input) != null && !this.isExtensionAlreadyExist(input) && !this.isChangeOnAddOrDelete(input);
    }

    @Override
    public Diff create(Diff input) {
        UMLDiff ret = this.createExtension();
        EObject discriminant = this.getDiscriminantFromDiff(input);
        DifferenceKind extensionKind = this.getRelatedExtensionKind(input);
        if (discriminant != null) {
            if (extensionKind == DifferenceKind.DELETE) {
                ret.getRefinedBy().add((Object)input);
            } else {
                this.fillRefiningDifferences(input.getMatch().getComparison(), ret, discriminant);
            }
        }
        ret.setDiscriminant(discriminant);
        ret.setKind(extensionKind);
        if ((extensionKind == DifferenceKind.ADD || extensionKind == DifferenceKind.DELETE) && input instanceof ReferenceChange) {
            ret.setEReference(((ReferenceChange)input).getReference());
        }
        return ret;
    }

    protected void fillRefiningDifferences(Comparison comparison, UMLDiff diffExtension, EObject discriminant) {
        for (EObject elt : this.getPotentialChangedValuesFromDiscriminant(discriminant)) {
            this.beRefinedByCrossReferences(comparison, elt, diffExtension, this.REFINING_PREDICATE);
        }
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, UMLDiff extension) {
        EObject discriminant;
        if (this.getExtensionKind().isInstance(extension) && (discriminant = extension.getDiscriminant()) != null) {
            if (extension.getKind().equals((Object)DifferenceKind.CHANGE)) {
                extension.getRequires().addAll(this.findCrossReferences(comparison, discriminant, this.REQUIRES_ADD_DISCRIMINANT_PREDICATE));
            } else if (extension.getKind().equals((Object)DifferenceKind.DELETE)) {
                extension.getRequires().addAll(this.findCrossReferences(comparison, discriminant, this.REQUIRES_CHANGE_DISCRIMINANT_PREDICATE));
            }
        }
    }

    @Override
    public Match getParentMatch(Diff input) {
        if (this.getRelatedExtensionKind(input) == DifferenceKind.CHANGE) {
            EObject discriminant = this.getDiscriminantFromDiff(input);
            if (discriminant != null) {
                Match match = input.getMatch().getComparison().getMatch(discriminant);
                if (match.eContainer() instanceof Match) {
                    return (Match)match.eContainer();
                }
                return match;
            }
            return input.getMatch();
        }
        return super.getParentMatch(input);
    }

    protected abstract UMLDiff createExtension();

    protected boolean isPartOfRefiningDifference(Diff diff) {
        return diff instanceof ReferenceChange && this.getRelatedExtensionKind(diff) == DifferenceKind.CHANGE;
    }

    private boolean isExtensionAlreadyExist(Diff input) {
        for (Diff diff : input.getRefines()) {
            if (!(diff instanceof UMLDiff) || !((UMLDiff)diff).getDiscriminant().equals(this.getDiscriminantFromDiff(input))) continue;
            return true;
        }
        return false;
    }

    private boolean isChangeOnAddOrDelete(Diff input) {
        if (this.getRelatedExtensionKind(input) == DifferenceKind.CHANGE) {
            Comparison comparison = input.getMatch().getComparison();
            EObject discriminant = this.getDiscriminantFromDiff(input);
            EList candidates = comparison.getDifferences(discriminant);
            for (Diff diff : candidates) {
                DifferenceKind relatedExtensionKind;
                if (diff == input || (relatedExtensionKind = this.getRelatedExtensionKind(diff)) != DifferenceKind.ADD && relatedExtensionKind != DifferenceKind.DELETE || this.getDiscriminantFromDiff(diff) != discriminant) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract EObject getDiscriminantFromDiff(Diff var1);

    protected abstract List<EObject> getPotentialChangedValuesFromDiscriminant(EObject var1);

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return (DifferenceKind)this.differenceKindCompareSwitch.doSwitch((EObject)input);
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ResourceAttachmentChange input) {
        return false;
    }

    protected EStructuralFeature.Setting getInverseReferences(EObject object, Predicate<EStructuralFeature.Setting> predicate) {
        Iterator crossReferences = UML2Util.getInverseReferences((EObject)object).iterator();
        try {
            return (EStructuralFeature.Setting)Iterators.find(crossReferences, predicate);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

