/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension.profile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.ProfileApplicationChange;
import org.eclipse.emf.compare.uml2.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.UMLAbstractDiffExtensionFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.impl.ProfileApplicationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLProfileApplicationChangeFactory
extends UMLAbstractDiffExtensionFactory {
    @Override
    public Class<? extends UMLDiff> getExtensionKind() {
        return ProfileApplicationChange.class;
    }

    @Override
    protected UMLDiff createExtension() {
        return UMLCompareFactory.eINSTANCE.createProfileApplicationChange();
    }

    @Override
    protected EObject getDiscriminantFromDiff(Diff input) {
        EObject result = null;
        DifferenceKind kind = this.getRelatedExtensionKind(input);
        if (kind == DifferenceKind.ADD || kind == DifferenceKind.DELETE) {
            return ((ReferenceChange)input).getValue();
        }
        if (kind == DifferenceKind.CHANGE) {
            EObject container = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
            return this.getDiscriminantForChanges(container);
        }
        return result;
    }

    private ProfileApplication getDiscriminantForChanges(EObject container) {
        if (container instanceof ProfileApplication) {
            return (ProfileApplication)container;
        }
        if (container instanceof EAnnotation && container.eContainer() instanceof ProfileApplication) {
            return (ProfileApplication)container.eContainer();
        }
        return null;
    }

    @Override
    protected List<EObject> getPotentialChangedValuesFromDiscriminant(EObject discriminant) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (discriminant instanceof ProfileApplicationImpl) {
            result.add((EObject)((ProfileApplicationImpl)discriminant).basicGetAppliedProfile());
            for (EAnnotation annotation : ReferenceUtil.getAsList((EObject)discriminant, (EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)) {
                result.addAll(ReferenceUtil.getAsList((EObject)annotation, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES));
            }
        }
        return result;
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.ADD) && input.getValue() instanceof ProfileApplication;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.DELETE) && input.getValue() instanceof ProfileApplication;
    }

    @Override
    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return input.getReference().equals(UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE) || input.getReference().equals(EcorePackage.Literals.EANNOTATION__REFERENCES) || input.getReference().equals(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, UMLDiff extension) {
        ProfileApplicationChange profileApplicationChange;
        if (extension instanceof ProfileApplicationChange && (profileApplicationChange = (ProfileApplicationChange)extension).getKind() == DifferenceKind.DELETE) {
            for (EObject eObject : this.getStereotypeApplications((ProfileApplication)profileApplicationChange.getDiscriminant())) {
                for (Diff diff : comparison.getDifferences(eObject)) {
                    if (!(diff instanceof StereotypeApplicationChange) || diff.getKind() != DifferenceKind.DELETE) continue;
                    profileApplicationChange.getRequires().add((Object)diff);
                }
            }
        }
    }

    private List<EObject> getStereotypeApplications(ProfileApplication profileApplication) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Package p = profileApplication.getApplyingPackage();
        TreeIterator it = p.eAllContents();
        while (it.hasNext()) {
            EObject elt = (EObject)it.next();
            if (!(elt instanceof Element)) continue;
            for (Stereotype stereotype : ((Element)elt).getAppliedStereotypes()) {
                if (!stereotype.getProfile().equals(profileApplication.getAppliedProfile())) continue;
                EObject stereotypeApplication = ((Element)elt).getStereotypeApplication(stereotype);
                result.add(stereotypeApplication);
            }
        }
        return result;
    }

    @Override
    public Match getParentMatch(Diff input) {
        EObject discriminant = this.getDiscriminantFromDiff(input);
        if (discriminant instanceof ProfileApplication) {
            Package p = ((ProfileApplication)discriminant).getApplyingPackage();
            Match match = input.getMatch().getComparison().getMatch((EObject)p);
            if (match != null) {
                return match;
            }
        }
        return super.getParentMatch(input);
    }
}

