/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff.internal.extension.sequence;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.IntervalConstraintChange;
import org.eclipse.emf.compare.uml2.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.UMLAbstractDiffExtensionFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLIntervalConstraintChangeFactory
extends UMLAbstractDiffExtensionFactory {
    @Override
    public Class<? extends UMLDiff> getExtensionKind() {
        return IntervalConstraintChange.class;
    }

    @Override
    protected UMLDiff createExtension() {
        return UMLCompareFactory.eINSTANCE.createIntervalConstraintChange();
    }

    @Override
    protected EObject getDiscriminantFromDiff(Diff input) {
        EObject result = null;
        DifferenceKind kind = this.getRelatedExtensionKind(input);
        if (kind == DifferenceKind.ADD || kind == DifferenceKind.DELETE) {
            result = ((ReferenceChange)input).getValue();
        } else if (kind == DifferenceKind.CHANGE) {
            EObject container = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
            result = this.getIntervalContraint(container);
        }
        return result;
    }

    private IntervalConstraint getIntervalContraint(EObject object) {
        if (object instanceof IntervalConstraint) {
            return (IntervalConstraint)object;
        }
        if (object instanceof ValueSpecification && object.eContainer() instanceof IntervalConstraint) {
            return (IntervalConstraint)object.eContainer();
        }
        if (object instanceof ValueSpecification && object.eContainer() instanceof ValueSpecification) {
            return this.getIntervalContraint(object.eContainer());
        }
        if (object instanceof ValueSpecification) {
            EStructuralFeature.Setting setting = this.getInverseReferences(object, new Predicate<EStructuralFeature.Setting>(){

                public boolean apply(EStructuralFeature.Setting input) {
                    return (input.getEStructuralFeature() == UMLPackage.Literals.INTERVAL__MIN || input.getEStructuralFeature() == UMLPackage.Literals.INTERVAL__MAX) && input.getEObject().eContainer() instanceof IntervalConstraint;
                }
            });
            return (IntervalConstraint)((Interval)setting.getEObject()).eContainer();
        }
        return null;
    }

    @Override
    protected List<EObject> getPotentialChangedValuesFromDiscriminant(EObject discriminant) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (discriminant instanceof IntervalConstraint) {
            result.addAll((Collection<EObject>)((IntervalConstraint)discriminant).getConstrainedElements());
            ValueSpecification valueSpecification = ((IntervalConstraint)discriminant).getSpecification();
            result.add((EObject)valueSpecification);
            if (valueSpecification instanceof Interval) {
                ValueSpecification min = ((Interval)valueSpecification).getMin();
                ValueSpecification max = ((Interval)valueSpecification).getMax();
                result.add((EObject)min);
                result.add((EObject)max);
                result.addAll((Collection<EObject>)min.eContents());
                result.addAll((Collection<EObject>)max.eContents());
            }
        }
        return result;
    }

    @Override
    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return (input.getReference().equals(UMLPackage.Literals.CONSTRAINT__CONSTRAINED_ELEMENT) || input.getReference().equals(UMLPackage.Literals.CONSTRAINT__SPECIFICATION) || input.getReference().equals(UMLPackage.Literals.INTERVAL__MIN) || input.getReference().equals(UMLPackage.Literals.INTERVAL__MAX) || input.getReference().equals(UMLPackage.Literals.TIME_EXPRESSION__EXPR)) && this.getManagedConcreteDiscriminantKind().contains(MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (ReferenceChange)input).eClass());
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.ADD) && input.getValue() instanceof IntervalConstraint && ((IntervalConstraint)input.getValue()).getConstrainedElements() != null && !((IntervalConstraint)input.getValue()).getConstrainedElements().isEmpty() && this.getManagedConcreteDiscriminantKind().contains(input.getValue().eClass());
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.DELETE) && input.getValue() instanceof IntervalConstraint && this.getManagedConcreteDiscriminantKind().contains(input.getValue().eClass());
    }

    protected List<EClass> getManagedConcreteDiscriminantKind() {
        ArrayList<EClass> result = new ArrayList<EClass>();
        result.add(UMLPackage.Literals.INTERVAL_CONSTRAINT);
        result.add(UMLPackage.Literals.TIME_CONSTRAINT);
        result.add(UMLPackage.Literals.INTERVAL);
        result.add(UMLPackage.Literals.TIME_INTERVAL);
        result.add(UMLPackage.Literals.VALUE_SPECIFICATION);
        result.add(UMLPackage.Literals.TIME_EXPRESSION);
        return result;
    }
}

