/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.ResourceTraversal;
import org.eclipse.emf.compare.ide.internal.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.internal.utils.StorageURIConverter;
import org.eclipse.emf.compare.ide.internal.utils.SyncResourceSet;
import org.eclipse.emf.compare.ide.ui.logical.RevisionedURIConverter;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class EMFSynchronizationModel {
    private ResourceTraversal leftTraversal;
    private ResourceTraversal rightTraversal;
    private ResourceTraversal originTraversal;

    private EMFSynchronizationModel(ResourceTraversal leftTraversal, ResourceTraversal rightTraversal, ResourceTraversal originTraversal) {
        this.leftTraversal = leftTraversal == null ? new ResourceTraversal((Set)Sets.newHashSet()) : leftTraversal;
        this.rightTraversal = rightTraversal == null ? new ResourceTraversal((Set)Sets.newHashSet()) : rightTraversal;
        this.originTraversal = originTraversal == null ? new ResourceTraversal((Set)Sets.newHashSet()) : originTraversal;
    }

    public static EMFSynchronizationModel createSynchronizationModel(ITypedElement left, ITypedElement right, ITypedElement origin) {
        ResourceTraversal originTraversal;
        ResourceTraversal rightTraversal;
        ResourceTraversal leftTraversal;
        IFileRevision leftRevision = EMFSynchronizationModel.findFileRevision(left);
        IFileRevision rightRevision = EMFSynchronizationModel.findFileRevision(right);
        IFileRevision originRevision = EMFSynchronizationModel.findFileRevision(origin);
        if (leftRevision == null) {
            IResource leftRes = EMFSynchronizationModel.findResource(left);
            leftTraversal = EMFSynchronizationModel.resolveTraversal(leftRes);
        } else {
            leftTraversal = EMFSynchronizationModel.resolveTraversal(leftRevision);
        }
        if (rightRevision == null) {
            IResource rightRes = EMFSynchronizationModel.findResource(right);
            rightTraversal = EMFSynchronizationModel.resolveTraversal(rightRes);
        } else {
            rightTraversal = EMFSynchronizationModel.resolveTraversal(rightRevision);
        }
        if (originRevision == null) {
            IResource originRes = EMFSynchronizationModel.findResource(origin);
            originTraversal = EMFSynchronizationModel.resolveTraversal(originRes);
        } else {
            originTraversal = EMFSynchronizationModel.resolveTraversal(originRevision);
        }
        return new EMFSynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    public static EMFSynchronizationModel createSynchronizationModel(IResource left, IResource right, IResource origin) {
        ResourceTraversal leftTraversal = EMFSynchronizationModel.resolveTraversal(left);
        ResourceTraversal rightTraversal = EMFSynchronizationModel.resolveTraversal(right);
        ResourceTraversal originTraversal = EMFSynchronizationModel.resolveTraversal(origin);
        return new EMFSynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    public void minimize() {
        boolean threeWay = !this.originTraversal.getStorages().isEmpty();
        LinkedHashSet leftCopy = Sets.newLinkedHashSet((Iterable)this.leftTraversal.getStorages());
        LinkedHashSet rightCopy = Sets.newLinkedHashSet((Iterable)this.rightTraversal.getStorages());
        LinkedHashSet originCopy = Sets.newLinkedHashSet((Iterable)this.originTraversal.getStorages());
        this.removeReadOnly(this.leftTraversal.getStorages());
        this.removeReadOnly(this.rightTraversal.getStorages());
        this.removeReadOnly(this.originTraversal.getStorages());
        for (IStorage left : leftCopy) {
            IStorage right = this.removeLikeNamedStorageFrom(left, rightCopy);
            if (right != null && threeWay) {
                IStorage origin = this.removeLikeNamedStorageFrom(left, originCopy);
                if (origin == null || !ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right, (IStorage)origin)) continue;
                this.leftTraversal.getStorages().remove(left);
                this.rightTraversal.getStorages().remove(right);
                this.originTraversal.getStorages().remove(origin);
                continue;
            }
            if (right == null || !ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right)) continue;
            this.leftTraversal.getStorages().remove(left);
            this.rightTraversal.getStorages().remove(right);
        }
    }

    private void removeReadOnly(Set<? extends IStorage> storages) {
        Iterator<? extends IStorage> storageIt = storages.iterator();
        while (storageIt.hasNext()) {
            if (!storageIt.next().isReadOnly()) continue;
            storageIt.remove();
        }
    }

    private IStorage removeLikeNamedStorageFrom(IStorage reference, Set<IStorage> candidates) {
        String referenceName = reference.getName();
        Iterator<IStorage> candidatesIterator = candidates.iterator();
        while (candidatesIterator.hasNext()) {
            IStorage candidate = candidatesIterator.next();
            String candidateName = candidate.getName();
            if (!referenceName.equals(candidateName)) continue;
            candidatesIterator.remove();
            return candidate;
        }
        return null;
    }

    public ResourceSet getLeftResourceSet() {
        return new NotLoadingResourceSet(this.leftTraversal);
    }

    public ResourceSet getRightResourceSet() {
        return new NotLoadingResourceSet(this.rightTraversal);
    }

    public ResourceSet getOriginResourceSet() {
        return new NotLoadingResourceSet(this.originTraversal);
    }

    private static ResourceTraversal resolveTraversal(IResource start) {
        if (start == null || !(start instanceof IFile)) {
            return new ResourceTraversal((Set)Sets.newLinkedHashSet());
        }
        SyncResourceSet resourceSet = new SyncResourceSet();
        StorageURIConverter converter = new StorageURIConverter(resourceSet.getURIConverter());
        resourceSet.setURIConverter((URIConverter)converter);
        resourceSet.resolveAll((IStorage)((IFile)start));
        LinkedHashSet storages = Sets.newLinkedHashSet((Iterable)Sets.union(Collections.singleton((IFile)start), (Set)converter.getLoadedRevisions()));
        return new ResourceTraversal((Set)storages);
    }

    private static ResourceTraversal resolveTraversal(IFileRevision start) {
        if (start == null) {
            return new ResourceTraversal((Set)Sets.newLinkedHashSet());
        }
        ResourceTraversal traversal = new ResourceTraversal((Set)Sets.newLinkedHashSet());
        SyncResourceSet resourceSet = new SyncResourceSet();
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), start);
        resourceSet.setURIConverter((URIConverter)converter);
        try {
            IStorage startStorage = start.getStorage((IProgressMonitor)new NullProgressMonitor());
            resourceSet.resolveAll(startStorage);
            LinkedHashSet storages = Sets.newLinkedHashSet((Iterable)Sets.union(Collections.singleton(startStorage), (Set)converter.getLoadedRevisions()));
            traversal = new ResourceTraversal((Set)storages);
        }
        catch (CoreException coreException) {}
        return traversal;
    }

    private static IFileRevision findFileRevision(ITypedElement element) {
        IEditorInput editorInput;
        ISharedDocumentAdapter documentAdapter;
        if (element == null) {
            return null;
        }
        IFileRevision revision = EMFSynchronizationModel.adaptAs(element, IFileRevision.class);
        if (revision == null && (documentAdapter = EMFSynchronizationModel.adaptAs(element, ISharedDocumentAdapter.class)) != null && (editorInput = documentAdapter.getDocumentKey((Object)element)) != null) {
            revision = EMFSynchronizationModel.adaptAs(editorInput, IFileRevision.class);
        }
        if (revision == null) {
            try {
                Method method = element.getClass().getMethod("getFileRevision", new Class[0]);
                Object value = method.invoke((Object)element, new Object[0]);
                if (value instanceof IFileRevision) {
                    revision = (IFileRevision)value;
                }
            }
            catch (Exception exception) {}
        }
        return revision;
    }

    private static IResource findResource(ITypedElement element) {
        if (element == null) {
            return null;
        }
        IResource resource = EMFSynchronizationModel.adaptAs(element, IResource.class);
        if (resource == null && element instanceof IResourceProvider) {
            resource = ((IResourceProvider)element).getResource();
        }
        return resource;
    }

    private static <T> T adaptAs(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Object result = null;
        if (clazz.isInstance(object)) {
            result = object;
        } else if (object instanceof IAdaptable) {
            result = ((IAdaptable)object).getAdapter(clazz);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(object, clazz);
        }
        return (T)result;
    }
}

