/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.NoNotificationParserPool;
import org.eclipse.emf.compare.ide.internal.utils.PriorityExecutor;
import org.eclipse.emf.compare.ide.internal.utils.ResourceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class SyncResourceSet
extends ResourceSetImpl {
    private Set<URI> demandedURIs = Sets.newLinkedHashSet();
    private Set<URI> loadedURIs = Sets.newLinkedHashSet();
    private final PriorityExecutor pool = new PriorityExecutor("ModelResolver");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource demanded = super.getResource(uri, false);
        if (!this.loadedURIs.contains(uri) && demanded == null) {
            Set<URI> set = this.demandedURIs;
            synchronized (set) {
                this.demandedURIs.add(uri);
            }
        }
        return demanded;
    }

    public synchronized Resource createResource(URI uri) {
        return super.createResource(uri);
    }

    public synchronized Resource createResource(URI uri, String contentType) {
        return super.createResource(uri, contentType);
    }

    public synchronized EList<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new SynchronizedResourcesEList();
        }
        return this.resources;
    }

    public Resource loadResource(URI uri) {
        return super.getResource(uri, true);
    }

    public synchronized Map<Object, Object> getLoadOptions() {
        if (this.loadOptions == null) {
            this.loadOptions = super.getLoadOptions();
            this.loadOptions.put("USE_PARSER_POOL", new NoNotificationParserPool());
            this.loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
            this.loadOptions.put("DISABLE_NOTIFY", Boolean.TRUE);
            HashMap parserProperties = Maps.newHashMap();
            parserProperties.put("http://apache.org/xml/properties/input-buffer-size", 16384);
            this.loadOptions.put("PARSER_PROPERTIES", parserProperties);
            this.loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
            this.loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", Maps.newHashMapWithExpectedSize((int)256));
        }
        return this.loadOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void resolveAll(IStorage start) {
        resource = ResourceUtil.loadResource(start, (ResourceSet)this, this.getLoadOptions());
        this.demandedURIs.clear();
        this.loadedURIs.add(resource.getURI());
        this.resolve(resource);
        this.unload(resource);
        var4_3 = this.demandedURIs;
        synchronized (var4_3) {
            newURIs = this.demandedURIs;
            this.demandedURIs = Sets.newLinkedHashSet();
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var4_3
            if (true) ** GOTO lbl41
        }
        do {
            this.loadedURIs.addAll(newURIs);
            resolveThreads = Sets.newLinkedHashSet();
            for (URI uri : newURIs) {
                resolveThreads.add(this.pool.submit(new ResourceLoader(uri), PriorityExecutor.Priority.LOW));
            }
            for (Future future : resolveThreads) {
                try {
                    future.get();
                }
                catch (InterruptedException v1) {
                }
                catch (ExecutionException v2) {}
            }
            var5_5 = this.demandedURIs;
            synchronized (var5_5) {
                newURIs = this.demandedURIs;
                this.demandedURIs = Sets.newLinkedHashSet();
            }
lbl41:
            // 2 sources

        } while (!newURIs.isEmpty());
    }

    public Set<URI> getLoadedURIs() {
        return this.loadedURIs;
    }

    private void resolve(Resource resource) {
        resource.eSetDeliver(false);
        List roots = ((InternalEList)resource.getContents()).basicList();
        Iterator resourceContent = roots.iterator();
        resource.getContents().clear();
        while (resourceContent.hasNext()) {
            EObject eObject = (EObject)resourceContent.next();
            this.resolveCrossReferences(eObject);
            TreeIterator<EObject> childContent = this.basicEAllContents(eObject);
            while (childContent.hasNext()) {
                EObject child = (EObject)childContent.next();
                this.resolveCrossReferences(child);
            }
        }
        resource.getContents().addAll((Collection)roots);
    }

    private TreeIterator<EObject> basicEAllContents(EObject eObject) {
        return new AbstractTreeIterator<EObject>((Object)eObject, false){
            private static final long serialVersionUID = 6874121606163401152L;

            public Iterator<EObject> getChildren(Object obj) {
                return ((InternalEList)((EObject)obj).eContents()).basicIterator();
            }
        };
    }

    private void unload(final Resource resource) {
        URI uri = resource.getURI();
        if (uri.isPlatformResource() || uri.isRelative()) {
            this.getResources().remove((Object)resource);
            Runnable unloader = new Runnable(){

                public void run() {
                    resource.unload();
                }
            };
            this.pool.submit(unloader, PriorityExecutor.Priority.NORMAL);
        }
    }

    private void resolveCrossReferences(EObject eObject) {
        Iterator objectChildren = ((InternalEList)eObject.eCrossReferences()).basicIterator();
        while (objectChildren.hasNext()) {
            EObject eObj = (EObject)objectChildren.next();
            if (!eObj.eIsProxy()) continue;
            URI proxyURI = ((InternalEObject)eObj).eProxyURI();
            this.getResource(proxyURI.trimFragment(), false);
        }
    }

    private class ResourceLoader
    implements Runnable {
        private URI uri;

        public ResourceLoader(URI uri) {
            this.uri = uri;
        }

        public void run() {
            Resource newResource = SyncResourceSet.this.loadResource(this.uri);
            SyncResourceSet.this.resolve(newResource);
            SyncResourceSet.this.unload(newResource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SynchronizedResourcesEList<E>
    extends ResourceSetImpl.ResourcesEList<E> {
        private static final long serialVersionUID = 7371376112881960414L;
        private Object lock;

        private SynchronizedResourcesEList() {
            super((ResourceSetImpl)SyncResourceSet.this);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return super.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E set(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return (E)super.set(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.add(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAll(index, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.move(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return super.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return super.toString();
            }
        }

        public Iterator<E> iterator() {
            return new SynchronizedEIterator();
        }

        public ListIterator<E> listIterator() {
            return new SynchronizedEListIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator<E> listIterator(int index) {
            Object object = this.lock;
            synchronized (object) {
                int curSize = this.size();
                if (index < 0 || index > curSize) {
                    throw new BasicEList.BasicIndexOutOfBoundsException(index, curSize);
                }
                return new SynchronizedEListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return super.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T[] toArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return super.toArray((Object[])array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setData(int size, Object[] data) {
            Object object = this.lock;
            synchronized (object) {
                super.setData(size, data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E get(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)super.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E basicGet(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)super.basicGet(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shrink() {
            Object object = this.lock;
            synchronized (object) {
                super.shrink();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void grow(int minimumCapacity) {
            Object object = this.lock;
            synchronized (object) {
                super.grow(minimumCapacity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object clone() {
            Object object = this.lock;
            synchronized (object) {
                return super.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.addUnique(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnique(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                super.addUnique(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Collection<? extends E> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(index, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(Object[] objects, int start, int end) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(objects, start, end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAllUnique(int index, Object[] objects, int start, int end) {
            Object object = this.lock;
            synchronized (object) {
                return super.addAllUnique(index, objects, start, end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicAdd(E object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicAdd(object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E remove(int index) {
            Object object = this.lock;
            synchronized (object) {
                return (E)super.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicRemove(object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                super.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E setUnique(int index, E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return (E)super.setUnique(index, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NotificationChain basicSet(int index, E object, NotificationChain notifications) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicSet(index, object, notifications);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E move(int targetIndex, int sourceIndex) {
            Object object = this.lock;
            synchronized (object) {
                return (E)super.move(targetIndex, sourceIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> basicList() {
            Object object = this.lock;
            synchronized (object) {
                return super.basicList();
            }
        }

        public Iterator<E> basicIterator() {
            return new SynchronizedNonResolvingEIterator();
        }

        public ListIterator<E> basicListIterator() {
            return new SynchronizedNonResolvingEListIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator<E> basicListIterator(int index) {
            Object object = this.lock;
            synchronized (object) {
                int curSize = this.size();
                if (index < 0 || index > curSize) {
                    throw new BasicEList.BasicIndexOutOfBoundsException(index, curSize);
                }
                return new SynchronizedNonResolvingEListIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean basicContains(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicContains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean basicContainsAll(Collection<?> collection) {
            Object object = this.lock;
            synchronized (object) {
                return super.basicContainsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int basicIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int basicLastIndexOf(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                return super.basicLastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] basicToArray() {
            Object object = this.lock;
            synchronized (object) {
                return super.basicToArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T[] basicToArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return super.basicToArray((Object[])array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] data() {
            Object object = this.lock;
            synchronized (object) {
                return super.data();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getFeature() {
            Object object = this.lock;
            synchronized (object) {
                return super.getFeature();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFeatureID() {
            Object object = this.lock;
            synchronized (object) {
                return super.getFeatureID();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNotifier() {
            Object object = this.lock;
            synchronized (object) {
                return super.getNotifier();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return super.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return super.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.lock;
            synchronized (object) {
                return super.subList(fromIndex, toIndex);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedEIterator
        extends AbstractEList.EIterator<E> {
            private SynchronizedEIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedEListIterator
        extends AbstractEList.EListIterator<E> {
            public SynchronizedEListIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            public SynchronizedEListIterator(int index) {
                super((AbstractEList)SynchronizedResourcesEList.this, index);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.add(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasPrevious() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasPrevious();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E previous() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previous();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int previousIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previousIndex();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.set(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.nextIndex();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedNonResolvingEIterator
        extends AbstractEList.NonResolvingEIterator<E> {
            private SynchronizedNonResolvingEIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SynchronizedNonResolvingEListIterator
        extends AbstractEList.NonResolvingEListIterator<E> {
            public SynchronizedNonResolvingEListIterator() {
                super((AbstractEList)SynchronizedResourcesEList.this);
            }

            public SynchronizedNonResolvingEListIterator(int index) {
                super((AbstractEList)SynchronizedResourcesEList.this, index);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.add(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasPrevious() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hasPrevious();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E next() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public E previous() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previous();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int previousIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.previousIndex();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    super.remove();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(E object) {
                Object object2 = SynchronizedResourcesEList.this.lock;
                synchronized (object2) {
                    super.set(object);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean equals(Object obj) {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.equals(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int hashCode() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.hashCode();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.toString();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextIndex() {
                Object object = SynchronizedResourcesEList.this.lock;
                synchronized (object) {
                    return super.nextIndex();
                }
            }
        }
    }
}

