/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.StorageURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class RevisionedURIConverter
extends StorageURIConverter {
    private IFileRevision baseRevision;

    public RevisionedURIConverter(URIConverter delegate, IFileRevision baseRevision) {
        super(delegate);
        this.baseRevision = baseRevision;
        try {
            this.getLoadedRevisions().add(baseRevision.getStorage((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CoreException coreException) {}
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream stream = null;
        URI normalizedUri = this.normalize(uri);
        if (normalizedUri.isPlatformPlugin() || normalizedUri.toString().matches("(\\.\\./)+?plugins/.*")) {
            stream = super.createInputStream(normalizedUri, options);
        } else {
            IFile targetFile = normalizedUri.isPlatform() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toPlatformString(true))) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(normalizedUri.trimFragment().toString()));
            if (targetFile != null) {
                stream = this.openRevisionStream((IResource)targetFile);
            }
            if (stream == null) {
                return super.createInputStream(uri, options);
            }
        }
        return stream;
    }

    private InputStream openRevisionStream(IResource targetFile) {
        IFileHistoryProvider historyProvider;
        IFileHistory history;
        IResource actualFile = targetFile;
        if (!actualFile.exists() && (actualFile = this.findFile(actualFile.getFullPath().toString())) == null) {
            actualFile = targetFile;
        }
        InputStream stream = null;
        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)actualFile.getProject());
        if (repositoryProvider != null && (history = (historyProvider = repositoryProvider.getFileHistoryProvider()).getFileHistoryFor(actualFile, 0, (IProgressMonitor)new NullProgressMonitor())) != null) {
            IFileRevision soughtRevision = null;
            IFileRevision[] iFileRevisionArray = history.getFileRevisions();
            int n = iFileRevisionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileRevision revision = iFileRevisionArray[n2];
                if (revision.getTimestamp() <= this.baseRevision.getTimestamp()) {
                    soughtRevision = revision;
                    break;
                }
                if (soughtRevision == null || soughtRevision.getTimestamp() >= revision.getTimestamp()) {
                    soughtRevision = revision;
                }
                ++n2;
            }
            if (soughtRevision != null) {
                try {
                    IStorage storage = soughtRevision.getStorage((IProgressMonitor)new NullProgressMonitor());
                    this.getLoadedRevisions().add(storage);
                    stream = storage.getContents();
                }
                catch (CoreException coreException) {}
            }
        }
        if (stream == null) {
            try {
                IFileState soughtState = null;
                IFileState[] iFileStateArray = ((IFile)actualFile).getHistory((IProgressMonitor)new NullProgressMonitor());
                int n = iFileStateArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IFileState state = iFileStateArray[n3];
                    if (state.getModificationTime() <= this.baseRevision.getTimestamp()) {
                        soughtState = state;
                        break;
                    }
                    ++n3;
                }
                if (soughtState != null) {
                    this.getLoadedRevisions().add(soughtState);
                    stream = soughtState.getContents();
                } else {
                    this.getLoadedRevisions().add((IFile)actualFile);
                    stream = ((IFile)actualFile).getContents();
                }
            }
            catch (CoreException coreException) {}
        }
        return stream;
    }

    private IFile findFile(String path) {
        java.net.URI baseURI = this.baseRevision.getURI();
        java.net.URI targetURI = this.convertToURI(path);
        java.net.URI relativizedURI = baseURI.relativize(targetURI);
        IFile file = null;
        if (!relativizedURI.equals(targetURI)) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(relativizedURI.toString()));
        } else {
            int indexOfSeparator = path.indexOf(47, 1);
            if (indexOfSeparator > 0) {
                targetURI = this.convertToURI(path.substring(indexOfSeparator));
                relativizedURI = baseURI.relativize(targetURI);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(relativizedURI.toString()));
            }
        }
        if (file != null) {
            return file;
        }
        return null;
    }

    private java.net.URI convertToURI(String path) {
        try {
            return new java.net.URI(path);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

