/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.req;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReqEngine
implements IReqEngine {
    @Override
    public void computeRequirements(Comparison comparison) {
        for (Diff difference : comparison.getDifferences()) {
            this.checkForRequiredDifferences(comparison, difference);
        }
    }

    protected void checkForRequiredDifferences(Comparison comparison, Diff difference) {
        if (difference instanceof ReferenceChange) {
            ReferenceChange sourceDifference = (ReferenceChange)difference;
            HashSet<ReferenceChange> requiredDifferences = new HashSet<ReferenceChange>();
            HashSet<ReferenceChange> requiredByDifferences = new HashSet<ReferenceChange>();
            Match match = difference.getMatch();
            EReference reference = sourceDifference.getReference();
            EObject value = sourceDifference.getValue();
            DifferenceKind kind = sourceDifference.getKind();
            if (kind == DifferenceKind.ADD && reference.isContainment()) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value.eContainer(), DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDELOriginValueOnContainmentRefSingle(comparison, sourceDifference));
            } else if ((kind == DifferenceKind.ADD || DefaultReqEngine.isChangeAdd(comparison, sourceDifference)) && !reference.isContainment()) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, DifferenceKind.ADD));
                EObject container = sourceDifference.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
                if (container != null) {
                    requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, DifferenceKind.ADD));
                }
            } else if (kind == DifferenceKind.DELETE && reference.isContainment()) {
                requiredDifferences.addAll(this.getDELOutgoingReferences(comparison, sourceDifference));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, (List<EObject>)value.eContents(), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getMOVEContainedObjects(comparison, sourceDifference));
            } else if ((kind == DifferenceKind.DELETE || DefaultReqEngine.isChangeDelete(sourceDifference)) && !reference.isContainment()) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, DifferenceKind.DELETE));
            } else if (kind == DifferenceKind.MOVE && reference.isContainment()) {
                EObject container = value.eContainer();
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, DifferenceKind.MOVE));
            } else if (kind == DifferenceKind.CHANGE && !DefaultReqEngine.isChangeAdd(comparison, sourceDifference) && !DefaultReqEngine.isChangeDelete(sourceDifference)) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(comparison, MatchUtil.getOriginValue(comparison, sourceDifference), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, DifferenceKind.ADD));
            }
            sourceDifference.getRequires().addAll(requiredDifferences);
            sourceDifference.getRequiredBy().addAll(requiredByDifferences);
        }
    }

    private Set<ReferenceChange> getDELOriginValueOnContainmentRefSingle(Comparison comparison, ReferenceChange sourceDifference) {
        Object originValue;
        EObject originContainer;
        Set<ReferenceChange> result = new HashSet<ReferenceChange>();
        EReference reference = sourceDifference.getReference();
        if (!reference.isMany() && (originContainer = MatchUtil.getOriginContainer(comparison, sourceDifference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference)) instanceof EObject) {
            result = this.getDifferenceOnGivenObject(comparison, (EObject)originValue, DifferenceKind.DELETE);
        }
        return result;
    }

    private Set<ReferenceChange> getDifferenceOnGivenObject(Comparison comparison, EObject object, DifferenceKind kind) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        for (ReferenceChange diff : Iterables.filter(comparison.getDifferences(object), ReferenceChange.class)) {
            if (diff.getKind() != kind || !diff.getReference().isContainment()) continue;
            result.add(diff);
        }
        return result;
    }

    private Set<ReferenceChange> getDifferenceOnGivenObject(Comparison comparison, List<EObject> objects, DifferenceKind kind) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        for (EObject object : objects) {
            result.addAll(this.getDifferenceOnGivenObject(comparison, object, kind));
        }
        return result;
    }

    private Set<ReferenceChange> getDELOutgoingReferences(Comparison comparison, ReferenceChange sourceDifference) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        EObject value = sourceDifference.getValue();
        Match valueMatch = comparison.getMatch(value);
        if (valueMatch != null) {
            for (ReferenceChange candidate : Iterables.filter(valueMatch.getDifferences(), ReferenceChange.class)) {
                if (candidate.getKind() != DifferenceKind.DELETE && !DefaultReqEngine.isChangeDelete(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private Set<ReferenceChange> getMOVEContainedObjects(Comparison comparison, ReferenceChange sourceDifference) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        EObject value = sourceDifference.getValue();
        EList contents = value.eContents();
        for (EObject content : contents) {
            EObject originObject = MatchUtil.getOriginObject(comparison, content);
            if (originObject == null) continue;
            for (ReferenceChange difference : Iterables.filter(comparison.getDifferences(originObject), ReferenceChange.class)) {
                if (!difference.getReference().isContainment() || difference.getKind() != DifferenceKind.MOVE) continue;
                result.add(difference);
            }
        }
        return result;
    }

    private static boolean isChangeAdd(Comparison comparison, ReferenceChange difference) {
        boolean result = false;
        EReference reference = difference.getReference();
        if (!reference.isMany() && !reference.isContainment()) {
            EObject right;
            EObject origin;
            Match match = difference.getMatch();
            result = comparison.isThreeWay() ? (origin = match.getOrigin()) == null || ReferenceUtil.safeEGet(origin, (EStructuralFeature)reference) == null : (right = match.getRight()) == null || ReferenceUtil.safeEGet(right, (EStructuralFeature)reference) == null;
        }
        return result;
    }

    private static boolean isChangeDelete(ReferenceChange difference) {
        boolean result = false;
        EReference reference = difference.getReference();
        if (!reference.isMany() && !reference.isContainment()) {
            EObject right;
            EObject left;
            Match match = difference.getMatch();
            result = difference.getSource() == DifferenceSource.LEFT ? (left = match.getLeft()) == null || ReferenceUtil.safeEGet(left, (EStructuralFeature)reference) == null : (right = match.getRight()) == null || ReferenceUtil.safeEGet(right, (EStructuralFeature)reference) == null;
        }
        return result;
    }
}

