/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffUtil {
    private DiffUtil() {
    }

    public static double diceCoefficient(String first, String second) {
        double coefficient;
        char[] str2;
        char[] str1 = first.toCharArray();
        if (Arrays.equals(str1, str2 = second.toCharArray())) {
            coefficient = 1.0;
        } else if (str1.length <= 2 || str2.length <= 2) {
            int equalChars = 0;
            int i = 0;
            while (i < Math.min(str1.length, str2.length)) {
                if (str1[i] == str2[i]) {
                    ++equalChars;
                }
                ++i;
            }
            int union = str1.length + str2.length;
            coefficient = str1.length != str2.length ? (double)equalChars / (double)union : (double)equalChars * 2.0 / (double)union;
        } else {
            char[] chars;
            HashSet s1Bigrams = Sets.newHashSet();
            HashSet s2Bigrams = Sets.newHashSet();
            int i = 0;
            while (i < str1.length - 1) {
                chars = new char[]{str1[i], str1[i + 1]};
                s1Bigrams.add(String.valueOf(chars));
                ++i;
            }
            i = 0;
            while (i < str2.length - 1) {
                chars = new char[]{str2[i], str2[i + 1]};
                s2Bigrams.add(String.valueOf(chars));
                ++i;
            }
            Sets.SetView intersection = Sets.intersection((Set)s1Bigrams, (Set)s2Bigrams);
            coefficient = 2.0 * (double)intersection.size() / (double)(s1Bigrams.size() + s2Bigrams.size());
        }
        return coefficient;
    }

    public static <E> List<E> longestCommonSubsequence(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        boolean lcsIs2;
        EqualityHelper equalityHelper = comparison.getConfiguration().getEqualityHelper();
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        int[][] matrix = new int[size1 + 1][size2 + 1];
        int i = 1;
        while (i <= size1) {
            int j = 1;
            while (j <= size2) {
                E second;
                E first = sequence1.get(i - 1);
                matrix[i][j] = equalityHelper.matchingValues(comparison, first, second = sequence2.get(j - 1)) && !DiffUtil.contains(comparison, equalityHelper, ignoredElements, second) ? 1 + matrix[i - 1][j - 1] : Math.max(matrix[i - 1][j], matrix[i][j - 1]);
                ++j;
            }
            ++i;
        }
        boolean lcsIs1 = matrix[size1][size2] == size1;
        boolean bl = lcsIs2 = matrix[size1][size2] == size2;
        if (lcsIs1 || lcsIs2) {
            ImmutableList shortcut = lcsIs1 ? ImmutableList.copyOf(sequence1) : ImmutableList.copyOf(sequence2);
            return shortcut;
        }
        int current1 = size1;
        int current2 = size2;
        ArrayList result = Lists.newArrayList();
        while (current1 > 0 && current2 > 0) {
            E second;
            E first = sequence1.get(current1 - 1);
            if (equalityHelper.matchingValues(comparison, first, second = sequence2.get(current2 - 1))) {
                result.add(first);
                --current1;
                --current2;
                continue;
            }
            if (matrix[current1][current2 - 1] >= matrix[current1 - 1][current2]) {
                --current2;
                continue;
            }
            --current1;
        }
        return Lists.reverse((List)result);
    }

    public static <E> List<E> longestCommonSubsequence(Comparison comparison, List<E> sequence1, List<E> sequence2) {
        boolean lcsIs2;
        EqualityHelper equalityHelper = comparison.getConfiguration().getEqualityHelper();
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        int[][] matrix = new int[size1 + 1][size2 + 1];
        int i = 1;
        while (i <= size1) {
            E first = sequence1.get(i - 1);
            int j = 1;
            while (j <= size2) {
                E second = sequence2.get(j - 1);
                matrix[i][j] = equalityHelper.matchingValues(comparison, first, second) ? 1 + matrix[i - 1][j - 1] : Math.max(matrix[i - 1][j], matrix[i][j - 1]);
                ++j;
            }
            ++i;
        }
        boolean lcsIs1 = matrix[size1][size2] == size1;
        boolean bl = lcsIs2 = matrix[size1][size2] == size2;
        if (lcsIs1 || lcsIs2) {
            ImmutableList shortcut = lcsIs1 ? ImmutableList.copyOf(sequence1) : ImmutableList.copyOf(sequence2);
            return shortcut;
        }
        int current1 = size1;
        int current2 = size2;
        ArrayList result = Lists.newArrayList();
        while (current1 > 0 && current2 > 0) {
            E second;
            E first = sequence1.get(current1 - 1);
            if (equalityHelper.matchingValues(comparison, first, second = sequence2.get(current2 - 1))) {
                result.add(first);
                --current1;
                --current2;
                continue;
            }
            if (matrix[current1][current2 - 1] >= matrix[current1 - 1][current2]) {
                --current2;
                continue;
            }
            --current1;
        }
        return Lists.reverse((List)result);
    }

    private static <E> int findInsertionIndex(Comparison comparison, Iterable<E> ignoredElements, List<E> source, List<E> target, E newElement) {
        EqualityHelper equalityHelper = comparison.getConfiguration().getEqualityHelper();
        List<E> lcs = ignoredElements != null ? DiffUtil.longestCommonSubsequence(comparison, ignoredElements, source, target) : DiffUtil.longestCommonSubsequence(comparison, source, target);
        Object firstLCS = null;
        Object lastLCS = null;
        if (lcs.size() > 0) {
            firstLCS = lcs.get(0);
            lastLCS = lcs.listIterator(lcs.size()).previous();
        }
        int currentIndex = -1;
        int firstLCSIndex = -1;
        int lastLCSIndex = -1;
        if (firstLCS == null) {
            firstLCSIndex = -2;
            lastLCSIndex = -2;
        }
        Iterator<E> sourceIterator = source.iterator();
        int i = 0;
        while (sourceIterator.hasNext() && (currentIndex == -1 || lastLCSIndex == -1)) {
            E sourceElement = sourceIterator.next();
            if (currentIndex == -1 && equalityHelper.matchingValues(comparison, sourceElement, newElement)) {
                currentIndex = i;
            }
            if (firstLCSIndex == -1 && equalityHelper.matchingValues(comparison, sourceElement, firstLCS)) {
                firstLCSIndex = i;
            }
            if (lastLCSIndex == -1 && equalityHelper.matchingValues(comparison, sourceElement, lastLCS)) {
                lastLCSIndex = i;
            }
            ++i;
        }
        int insertionIndex = -1;
        if (firstLCSIndex == -2) {
            insertionIndex = target.size();
        } else if (currentIndex < firstLCSIndex) {
            int i2 = 0;
            while (i2 < target.size() && insertionIndex == -1) {
                E targetElement = target.get(i2);
                if (equalityHelper.matchingValues(comparison, targetElement, firstLCS)) {
                    insertionIndex = i2;
                }
                ++i2;
            }
        } else if (currentIndex > lastLCSIndex) {
            int i3 = 0;
            while (i3 < target.size() && insertionIndex == -1) {
                E targetElement = target.get(i3);
                if (equalityHelper.matchingValues(comparison, targetElement, lastLCS)) {
                    insertionIndex = i3 + 1;
                }
                ++i3;
            }
        } else {
            Object subsequenceStart = null;
            int i4 = 0;
            while (i4 < currentIndex) {
                E sourceElement = source.get(i4);
                boolean isInLCS = false;
                int j = 0;
                while (j < lcs.size() && !isInLCS) {
                    E lcsElement = lcs.get(j);
                    if (equalityHelper.matchingValues(comparison, sourceElement, lcsElement)) {
                        isInLCS = true;
                    }
                    ++j;
                }
                if (isInLCS) {
                    subsequenceStart = sourceElement;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < target.size() && insertionIndex == -1) {
                E targetElement = target.get(i4);
                if (equalityHelper.matchingValues(comparison, targetElement, subsequenceStart)) {
                    insertionIndex = i4 + 1;
                }
                ++i4;
            }
        }
        if (insertionIndex == -1) {
            insertionIndex = target.size();
        }
        return insertionIndex;
    }

    public static <E> int findInsertionIndex(Comparison comparison, List<E> source, List<E> target, E newElement) {
        return DiffUtil.findInsertionIndex(comparison, null, source, target, newElement);
    }

    public static int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        Iterable<Object> ignoredElements;
        List temp;
        Object value;
        EAttribute feature;
        if (diff instanceof AttributeChange) {
            feature = ((AttributeChange)diff).getAttribute();
            value = ((AttributeChange)diff).getValue();
        } else if (diff instanceof ReferenceChange) {
            feature = ((ReferenceChange)diff).getReference();
            value = ((ReferenceChange)diff).getValue();
        } else {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalDiff", diff.eClass().getName()));
        }
        if (!feature.isMany()) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalFeature", feature.getName()));
        }
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        List<Object> sourceList = DiffUtil.getSourceList(diff, (EStructuralFeature)feature, rightToLeft);
        Object targetList = expectedContainer != null ? ((temp = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)feature)) instanceof InternalEList ? ((InternalEList)temp).basicList() : temp) : ImmutableList.of();
        if (diff.getKind() == DifferenceKind.MOVE) {
            boolean undoingRight;
            boolean undoingLeft = rightToLeft && diff.getSource() == DifferenceSource.LEFT;
            boolean bl = undoingRight = !rightToLeft && diff.getSource() == DifferenceSource.RIGHT;
            ignoredElements = undoingLeft || undoingRight ? Lists.newArrayList() : (!(diff instanceof AttributeChange) && comparison.isThreeWay() && match.getOrigin() != null ? Iterables.concat(DiffUtil.computeIgnoredElements(targetList, diff), Collections.singleton(value)) : Collections.singleton(value));
        } else {
            ignoredElements = comparison.isThreeWay() && diff.getKind() == DifferenceKind.DELETE ? DiffUtil.computeIgnoredElements(targetList, diff) : Lists.newArrayList();
        }
        return DiffUtil.findInsertionIndex(comparison, ignoredElements, sourceList, targetList, value);
    }

    private static List<Object> getSourceList(Diff diff, EStructuralFeature feature, boolean rightToLeft) {
        List temp;
        EObject expectedContainer;
        Match match = diff.getMatch();
        if (diff.getKind() == DifferenceKind.MOVE) {
            boolean undoingRight;
            boolean undoingLeft = rightToLeft && diff.getSource() == DifferenceSource.LEFT;
            boolean bl = undoingRight = !rightToLeft && diff.getSource() == DifferenceSource.RIGHT;
            expectedContainer = (undoingLeft || undoingRight) && match.getOrigin() != null ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        } else {
            expectedContainer = match.getOrigin() != null && diff.getKind() == DifferenceKind.DELETE ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        }
        Object sourceList = expectedContainer != null ? ((temp = (List)ReferenceUtil.safeEGet(expectedContainer, feature)) instanceof InternalEList ? ((InternalEList)temp).basicList() : temp) : ImmutableList.of();
        return sourceList;
    }

    private static <E> boolean contains(Comparison comparison, EqualityHelper equalityHelper, Iterable<E> sequence, E element) {
        for (E candidate : sequence) {
            if (!equalityHelper.matchingValues(comparison, candidate, element)) continue;
            return true;
        }
        return false;
    }

    private static <E> Iterable<E> computeIgnoredElements(Iterable<E> candidates, final Diff diff) {
        return Iterables.filter(candidates, (Predicate)new Predicate<Object>(){

            public boolean apply(Object element) {
                EAttribute feature;
                Match match = diff.getMatch();
                if (diff instanceof AttributeChange) {
                    feature = ((AttributeChange)diff).getAttribute();
                } else if (diff instanceof ReferenceChange) {
                    feature = ((ReferenceChange)diff).getReference();
                } else {
                    return false;
                }
                Iterable filteredCandidates = Iterables.filter(match.getDifferences(), diff.getClass());
                return Iterables.any((Iterable)filteredCandidates, (Predicate)DiffUtil.unresolvedDiffMatching((EStructuralFeature)feature, element));
            }
        });
    }

    private static <E> Predicate<? super Diff> unresolvedDiffMatching(final EStructuralFeature feature, final E element) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                boolean apply = false;
                apply = input instanceof AttributeChange ? input.getState() == DifferenceState.UNRESOLVED && ((AttributeChange)input).getAttribute() == feature && ((AttributeChange)input).getValue() == element : (input instanceof ReferenceChange ? input.getState() == DifferenceState.UNRESOLVED && ((ReferenceChange)input).getReference() == feature && ((ReferenceChange)input).getValue() == element : false);
                return apply;
            }
        };
    }
}

