/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class MatchUtil {
    private MatchUtil() {
    }

    public static EObject getOriginObject(Comparison comparison, EObject object) {
        EObject result = null;
        Match match = comparison.getMatch(object);
        if (match != null) {
            result = comparison.isThreeWay() ? match.getOrigin() : (object == match.getLeft() ? match.getRight() : match.getLeft());
        }
        return result;
    }

    public static EObject getOriginValue(Comparison comparison, ReferenceChange difference) {
        Object originValue;
        EObject originContainer;
        if (!difference.getReference().isContainment() && !difference.getReference().isMany() && difference.getKind().equals((Object)DifferenceKind.CHANGE) && (originContainer = MatchUtil.getOriginContainer(comparison, difference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)difference.getReference())) instanceof EObject) {
            return (EObject)originValue;
        }
        return null;
    }

    public static EObject getOriginContainer(Comparison comparison, ReferenceChange difference) {
        EObject diffContainer = comparison.isThreeWay() ? difference.getMatch().getOrigin() : (MatchUtil.getContainer(comparison, difference) == difference.getMatch().getLeft() ? difference.getMatch().getRight() : difference.getMatch().getLeft());
        return diffContainer;
    }

    public static EObject getContainer(Comparison comparison, ReferenceChange difference) {
        EObject result = null;
        Match match = difference.getMatch();
        DifferenceSource source = difference.getSource();
        DifferenceKind kind = difference.getKind();
        switch (kind) {
            case DELETE: {
                if (comparison.isThreeWay()) {
                    result = match.getOrigin();
                    break;
                }
                result = match.getRight();
                break;
            }
            case ADD: 
            case MOVE: {
                if (source == DifferenceSource.LEFT) {
                    result = match.getLeft();
                    break;
                }
                result = match.getRight();
                break;
            }
            case CHANGE: {
                EObject value = difference.getValue();
                result = ReferenceUtil.getAsList(match.getLeft(), (EStructuralFeature)difference.getReference()).contains(value) ? match.getLeft() : (ReferenceUtil.getAsList(match.getRight(), (EStructuralFeature)difference.getReference()).contains(value) ? match.getRight() : match.getOrigin());
            }
        }
        return result;
    }

    public static EObject getContainer(Diff difference) {
        EObject result = difference.getMatch().getLeft();
        if (result == null) {
            result = difference.getMatch().getRight();
        }
        if (result == null) {
            result = difference.getMatch().getOrigin();
        }
        return result;
    }

    public static EObject getContainer(Comparison comparison, Diff difference) {
        EObject result = null;
        result = difference instanceof ReferenceChange ? MatchUtil.getContainer(comparison, (ReferenceChange)difference) : MatchUtil.getContainer(difference);
        return result;
    }
}

