/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.PruningIterator;
import org.eclipse.emf.compare.ide.IAdditiveResourceMappingMerger;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMappingMerger;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.AdditiveMergeCriterion;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditiveResourceMappingMerger
extends EMFResourceMappingMerger
implements IAdditiveResourceMappingMerger {
    @Override
    protected void mergeMapping(ResourceMapping mapping, IMergeContext mergeContext, Set<ResourceMapping> failingMappings, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
        this.removeNonExistingStorages(syncModel.getLeftTraversal());
        LinkedHashSet resources = Sets.newLinkedHashSet(syncModel.getResources());
        IdenticalResourceMinimizer minimizer = new IdenticalResourceMinimizer();
        minimizer.minimize(syncModel, (IProgressMonitor)subMonitor.newChild(1));
        IComparisonScope scope = ComparisonScopeBuilder.create(syncModel, (IProgressMonitor)subMonitor.newChild(3));
        EMFCompare.Builder builder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        Comparison comparison = builder.build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)10)));
        EMFResourceMappingMerger.ResourceAdditionAndDeletionTracker resourceTracker = new EMFResourceMappingMerger.ResourceAdditionAndDeletionTracker();
        Set<URI> conflictingURIs = this.performPreMerge(comparison, subMonitor.newChild(3));
        this.save(scope.getLeft(), syncModel.getLeftTraversal(), syncModel.getRightTraversal(), syncModel.getOriginTraversal());
        if (!conflictingURIs.isEmpty()) {
            failingMappings.add(mapping);
            this.markResourcesAsMerged(mergeContext, resources, conflictingURIs, subMonitor.newChild(2));
        } else {
            this.delegateMergeOfUnmergedResourcesAndMarkDiffsAsMerged(syncModel, mergeContext, resourceTracker, subMonitor.newChild(2));
        }
        scope.getLeft().eAdapters().remove((Object)resourceTracker);
        subMonitor.setWorkRemaining(0);
    }

    private Set<URI> performPreMerge(Comparison comparison, SubMonitor subMonitor) {
        IGraph differencesGraph = MergeDependenciesUtil.mapDifferences((Comparison)comparison, (IMerger.Registry)MERGER_REGISTRY, (boolean)true, null);
        PruningIterator iterator = differencesGraph.breadthFirstIterator();
        Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor);
        LinkedHashSet<URI> conflictingURIs = new LinkedHashSet<URI>();
        while (iterator.hasNext()) {
            Diff next = (Diff)iterator.next();
            this.doMergeForDiff(next, (IGraph<Diff>)differencesGraph, (PruningIterator<Diff>)iterator, emfMonitor, conflictingURIs);
        }
        return conflictingURIs;
    }

    private void doMergeForDiff(Diff diff, IGraph<Diff> differencesGraph, PruningIterator<Diff> iterator, Monitor emfMonitor, Set<URI> conflictingURIs) {
        if (diff.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        if (EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)diff)) {
            if (this.isInAdditiveConflict(diff)) {
                if (diff.getSource() == DifferenceSource.LEFT) {
                    if (this.isRequiredByDeletion(diff)) {
                        AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
                    } else {
                        diff.setState(DifferenceState.MERGED);
                    }
                } else if (this.isRequiredByDeletion(diff)) {
                    diff.setState(DifferenceState.DISCARDED);
                } else {
                    AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
                }
            } else {
                iterator.prune();
                conflictingURIs.addAll(this.collectConflictingResources(differencesGraph.depthFirstIterator((Object)diff)));
            }
        } else if (this.isPseudoConflicting(diff)) {
            EList conflictingDiffs = diff.getConflict().getDifferences();
            Collection conflictingRACList = Collections2.filter((Collection)conflictingDiffs, (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
            if (conflictingRACList.size() == 1) {
                for (Diff conflictingDiff : conflictingDiffs) {
                    if (conflictingDiff instanceof ResourceAttachmentChange) {
                        if (conflictingDiff.getSource() == DifferenceSource.LEFT) {
                            AbstractMerger.getMergerDelegate((Diff)conflictingDiff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(conflictingDiff, emfMonitor);
                            continue;
                        }
                        conflictingDiff.setState(DifferenceState.MERGED);
                        continue;
                    }
                    conflictingDiff.setState(DifferenceState.MERGED);
                }
            } else {
                for (Diff conflictingDiff : conflictingDiffs) {
                    conflictingDiff.setState(DifferenceState.MERGED);
                }
            }
        } else if (diff.getSource() == DifferenceSource.LEFT) {
            if (this.isRequiredByDeletion(diff)) {
                AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
            } else {
                diff.setState(DifferenceState.MERGED);
            }
        } else if (this.isRequiredByDeletion(diff)) {
            diff.setState(DifferenceState.DISCARDED);
        } else {
            AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
        }
    }

    @Override
    protected void delegateMergeOfUnmergedResourcesAndMarkDiffsAsMerged(SynchronizationModel syncModel, IMergeContext mergeContext, EMFResourceMappingMerger.ResourceAdditionAndDeletionTracker resourceTracker, SubMonitor subMonitor) throws CoreException {
        IDiff diff;
        IPath fullPath;
        for (IFile deletedFile : resourceTracker.getDeletedIFiles()) {
            IDiff diff2 = mergeContext.getDiffTree().getDiff((IResource)deletedFile);
            this.markAsMerged(diff2, mergeContext, subMonitor);
        }
        for (IStorage storage : syncModel.getLeftTraversal().getStorages()) {
            fullPath = ResourceUtil.getFixedPath((IStorage)storage);
            if (fullPath == null) {
                EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeIncomplete")));
                continue;
            }
            diff = mergeContext.getDiffTree().getDiff(fullPath);
            if (diff == null) continue;
            this.markAsMerged(diff, mergeContext, subMonitor.newChild(1));
        }
        for (IStorage rightStorage : syncModel.getRightTraversal().getStorages()) {
            fullPath = ResourceUtil.getFixedPath((IStorage)rightStorage);
            if (fullPath == null || (diff = mergeContext.getDiffTree().getDiff(fullPath)) == null || 1 != diff.getKind()) continue;
            if (!resourceTracker.containsAddedResource(fullPath)) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
                IProject project = file.getProject();
                if (project.isAccessible()) {
                    this.merge(diff, mergeContext, subMonitor.newChild(1));
                    continue;
                }
                try {
                    InputStream inputStream = rightStorage.getContents();
                    FileOutputStream outputStream = new FileOutputStream(ResourceUtil.getAbsolutePath((IStorage)rightStorage).toFile());
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                    inputStream.close();
                    outputStream.close();
                }
                catch (FileNotFoundException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
                catch (IOException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
                continue;
            }
            this.markAsMerged(diff, mergeContext, subMonitor.newChild(1));
        }
    }

    private boolean isRequiredByDeletion(Diff diff) {
        if (diff.getKind() == DifferenceKind.DELETE) {
            return true;
        }
        EList requiredBy = diff.getRequiredBy();
        for (Diff requiredDiff : requiredBy) {
            if (!this.isRequiredByDeletion(requiredDiff)) continue;
            return true;
        }
        return false;
    }

    private boolean isPseudoConflicting(Diff diff) {
        Conflict conflict = diff.getConflict();
        return conflict != null && conflict.getKind() == ConflictKind.PSEUDO;
    }

    private boolean isInAdditiveConflict(Diff diff) {
        boolean isAdditiveConflict = false;
        EList leftDifferences = diff.getConflict().getLeftDifferences();
        EList rightDifferences = diff.getConflict().getRightDifferences();
        if (this.inAdditiveConflict((EList<Diff>)leftDifferences)) {
            isAdditiveConflict = true;
        } else if (this.inAdditiveConflict((EList<Diff>)rightDifferences)) {
            isAdditiveConflict = true;
        }
        return isAdditiveConflict;
    }

    private boolean inAdditiveConflict(EList<Diff> diffs) {
        boolean isCorrect = false;
        for (Diff diff : diffs) {
            if (!(diff instanceof ReferenceChange) || !((ReferenceChange)diff).getReference().isContainment()) continue;
            isCorrect = true;
            break;
        }
        return isCorrect;
    }
}

