/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.SideLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeWayComparisonGroupProvider
extends AbstractDifferenceGroupProvider {
    @Override
    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return comparison != null && comparison.isThreeWay();
    }

    @Override
    protected Collection<? extends IDifferenceGroup> buildGroups(Comparison comparison2) {
        String rightLabel;
        String leftLabel;
        Adapter adapter = EcoreUtil.getAdapter((List)this.getComparison().eAdapters(), SideLabelProvider.class);
        if (adapter instanceof SideLabelProvider) {
            SideLabelProvider labelProvider = (SideLabelProvider)adapter;
            leftLabel = labelProvider.getLeftLabel();
            rightLabel = labelProvider.getRightLabel();
        } else {
            leftLabel = EMFCompareRCPUIMessages.getString("ThreeWayComparisonGroupProvider.left.label");
            rightLabel = EMFCompareRCPUIMessages.getString("ThreeWayComparisonGroupProvider.right.label");
        }
        ConflictsGroupImpl conflicts = new ConflictsGroupImpl(this.getComparison(), (Predicate<? super Diff>)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}), EMFCompareRCPUIMessages.getString("ThreeWayComparisonGroupProvider.conflicts.label"), this.getCrossReferenceAdapter());
        ((BasicDifferenceGroupImpl)conflicts).buildSubTree();
        BasicDifferenceGroupImpl leftSide = new BasicDifferenceGroupImpl(this.getComparison(), (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}))), leftLabel, this.getCrossReferenceAdapter());
        leftSide.buildSubTree();
        BasicDifferenceGroupImpl rightSide = new BasicDifferenceGroupImpl(this.getComparison(), (Predicate<? super Diff>)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}))), rightLabel, this.getCrossReferenceAdapter());
        rightSide.buildSubTree();
        return ImmutableList.of((Object)conflicts, (Object)leftSide, (Object)rightSide);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConflictsGroupImpl
    extends BasicDifferenceGroupImpl {
        public ConflictsGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, filter, name, crossReferenceAdapter);
        }

        @Override
        public IStyledString.IComposedStyledString getStyledName() {
            ComposedStyledString ret = new ComposedStyledString();
            Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getChildren().iterator(), (Function)E_ALL_CONTENTS));
            Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
            UnmodifiableIterator eAllDiffData = Iterators.filter((Iterator)eAllData, Diff.class);
            HashSet diffs = Sets.newHashSet((Iterator)eAllDiffData);
            boolean unresolvedDiffs = Iterables.any((Iterable)diffs, (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO})));
            if (unresolvedDiffs) {
                ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
            }
            ret.append(this.getName());
            return ret;
        }

        @Override
        public synchronized void buildSubTree() {
            this.children = Lists.newArrayList();
            this.extensionDiffProcessed = Sets.newLinkedHashSet();
            for (Conflict conflict : this.getComparison().getConflicts()) {
                TreeNode buildSubTree = this.buildSubTree(conflict);
                if (buildSubTree == null) continue;
                this.children.add(buildSubTree);
            }
            this.registerCrossReferenceAdapter(this.children);
        }

        protected TreeNode buildSubTree(Conflict conflict) {
            TreeNode ret = this.wrap((EObject)conflict);
            for (Match match : this.getComparison().getMatches()) {
                this.buildSubTree(ret, conflict, match, Sets.newLinkedHashSet());
            }
            return ret;
        }

        protected void buildSubTree(TreeNode parentNode, Conflict conflict, Match match, Collection<Match> alreadyProcessedContainedMatches) {
            this.buildSubTree(parentNode, conflict, match, alreadyProcessedContainedMatches, Sets.newHashSet());
        }

        private void buildSubTree(TreeNode parentNode, Conflict conflict, Match match, Collection<Match> alreadyProcessedContainedMatches, Collection<Match> alreadyProcessedMatches) {
            Sets.SetView setView = Sets.intersection((Set)Sets.newLinkedHashSet((Iterable)match.getDifferences()), (Set)Sets.newHashSet((Iterable)conflict.getDifferences()));
            for (Diff diff : setView) {
                if (this.isParentPseudoConflictFromOtherSide(diff, parentNode.getData())) continue;
                TreeNode diffNode = this.wrap((EObject)diff);
                parentNode.getChildren().add((Object)diffNode);
                if (this.isContainment(diff)) {
                    Match diffMatch = ComparisonUtil.getComparison((Diff)diff).getMatch(((ReferenceChange)diff).getValue());
                    if (diffMatch == null || alreadyProcessedContainedMatches.contains(diffMatch)) continue;
                    LinkedHashSet updatedProcessedContainedMatches = Sets.newLinkedHashSet(alreadyProcessedContainedMatches);
                    updatedProcessedContainedMatches.add(diffMatch);
                    this.buildSubTree(diffNode, conflict, diffMatch, updatedProcessedContainedMatches);
                    continue;
                }
                alreadyProcessedMatches.add(match);
                for (Diff refinedBy : diff.getRefinedBy()) {
                    Match refinedByMatch = refinedBy.getMatch();
                    if (!alreadyProcessedMatches.add(refinedByMatch)) continue;
                    this.buildSubTree(diffNode, conflict, refinedByMatch, alreadyProcessedContainedMatches, alreadyProcessedMatches);
                }
            }
            for (Match subMatch : match.getSubmatches()) {
                if (this.isMatchOfConflictContainmentDiff(conflict, subMatch)) continue;
                this.buildSubTree(parentNode, conflict, subMatch, alreadyProcessedContainedMatches, alreadyProcessedMatches);
                alreadyProcessedMatches.add(subMatch);
            }
        }

        private boolean isParentPseudoConflictFromOtherSide(Diff diff, EObject parent) {
            Conflict conflict;
            boolean ret = false;
            if (parent instanceof Diff && (conflict = ((Diff)parent).getConflict()) != null && ConflictKind.PSEUDO == conflict.getKind()) {
                ret = !EMFComparePredicates.fromSide((DifferenceSource)((Diff)parent).getSource()).apply((Object)diff);
            }
            return ret;
        }

        protected boolean isMatchOfConflictContainmentDiff(Conflict conflict, Match subMatch) {
            if (subMatch != null) {
                for (Diff diff : conflict.getDifferences()) {
                    Match realMatch;
                    if (!this.isContainment(diff) || !subMatch.equals(realMatch = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue()))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isContainment(Diff diff) {
            return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
        }
    }
}

