/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RejectedCommitException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.Hook;
import org.eclipse.jgit.util.ProcessResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitCommand
extends GitCommand<RevCommit> {
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<String> only = new ArrayList<String>();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List<ObjectId> parents = new LinkedList<ObjectId>();
    private String reflogComment;
    private boolean noVerify;
    private boolean noPostRewrite;

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException, NoHeadException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException {
        this.checkCallable();
        Collections.sort(this.only);
        RevWalk rw = new RevWalk(this.repo);
        try {
            try {
                Ref head;
                RepositoryState state = this.repo.getRepositoryState();
                if (!state.canCommit()) {
                    throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().cannotCommitOnARepoWithState, state.name()));
                }
                if (!this.noVerify) {
                    ByteArrayOutputStream errorByteArray = new ByteArrayOutputStream();
                    PrintStream hookErrRedirect = new PrintStream(errorByteArray);
                    ProcessResult preCommitHookResult = FS.DETECTED.runIfPresent(this.repo, Hook.PRE_COMMIT, new String[0], System.out, hookErrRedirect, null);
                    String errorDetails = errorByteArray.toString();
                    if (preCommitHookResult.getStatus() == ProcessResult.Status.OK && preCommitHookResult.getExitCode() != 0) {
                        this.commitRejectedByHook(Hook.PRE_COMMIT, errorDetails);
                    }
                }
                this.processOptions(state, rw);
                if (this.all && !this.repo.isBare() && this.repo.getWorkTree() != null) {
                    Git git = new Git(this.repo);
                    try {
                        git.add().addFilepattern(".").setUpdate(true).call();
                    }
                    catch (NoFilepatternException e) {
                        throw new JGitInternalException(e.getMessage(), e);
                    }
                }
                if ((head = this.repo.getRef("HEAD")) == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                ObjectId headId = this.repo.resolve("HEAD^{commit}");
                if (headId == null && this.amend) {
                    throw new WrongRepositoryStateException(JGitText.get().commitAmendOnInitialNotPossible);
                }
                if (headId != null) {
                    if (this.amend) {
                        RevCommit previousCommit = rw.parseCommit(headId);
                        for (RevCommit p : previousCommit.getParents()) {
                            this.parents.add(p.getId());
                        }
                        if (this.author == null) {
                            this.author = previousCommit.getAuthorIdent();
                        }
                    } else {
                        this.parents.add(0, headId);
                    }
                }
                if (!this.noVerify && FS.DETECTED.tryFindHook(this.repo, Hook.COMMIT_MSG) != null) {
                    this.exportPreparedMessage(this.message);
                    ByteArrayOutputStream errorByteArray = new ByteArrayOutputStream();
                    PrintStream hookErrRedirect = new PrintStream(errorByteArray);
                    String messageFilePath = this.getMessageFile(false).getAbsolutePath();
                    messageFilePath = messageFilePath.replace(File.separatorChar, '/');
                    ProcessResult commitMsgHookResult = FS.DETECTED.runIfPresent(this.repo, Hook.COMMIT_MSG, new String[]{messageFilePath}, System.out, hookErrRedirect, null);
                    String errorDetails = errorByteArray.toString();
                    if (commitMsgHookResult.getStatus() == ProcessResult.Status.OK && commitMsgHookResult.getExitCode() != 0) {
                        this.commitRejectedByHook(Hook.COMMIT_MSG, errorDetails);
                    }
                    this.message = this.readPreparedMessage();
                }
                RevCommit revCommit = null;
                DirCache index = this.repo.lockDirCache();
                try {
                    if (!this.only.isEmpty()) {
                        index = this.createTemporaryIndex(headId, index, rw);
                    }
                    ObjectInserter odi = this.repo.newObjectInserter();
                    try {
                        ObjectId indexTreeId = index.writeTree(odi);
                        if (this.insertChangeId) {
                            this.insertChangeId(indexTreeId);
                        }
                        CommitBuilder commit = new CommitBuilder();
                        commit.setCommitter(this.committer);
                        commit.setAuthor(this.author);
                        commit.setMessage(this.message);
                        commit.setParentIds(this.parents);
                        commit.setTreeId(indexTreeId);
                        ObjectId commitId = odi.insert(commit);
                        odi.flush();
                        revCommit = rw.parseCommit(commitId);
                        RefUpdate ru = this.repo.updateRef("HEAD");
                        ru.setNewObjectId(commitId);
                        if (this.reflogComment != null) {
                            ru.setRefLogMessage(this.reflogComment, false);
                        } else {
                            String prefix = this.amend ? "commit (amend): " : (this.parents.size() == 0 ? "commit (initial): " : "commit: ");
                            ru.setRefLogMessage(prefix + revCommit.getShortMessage(), false);
                        }
                        if (headId != null) {
                            ru.setExpectedOldObjectId(headId);
                        } else {
                            ru.setExpectedOldObjectId(ObjectId.zeroId());
                        }
                        RefUpdate.Result rc = ru.forceUpdate();
                        switch (rc) {
                            case NEW: 
                            case FORCED: 
                            case FAST_FORWARD: {
                                this.setCallable(false);
                                if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
                                    this.repo.writeMergeCommitMsg(null);
                                    this.repo.writeMergeHeads(null);
                                    break;
                                }
                                if (state == RepositoryState.CHERRY_PICKING_RESOLVED) {
                                    this.repo.writeMergeCommitMsg(null);
                                    this.repo.writeCherryPickHead(null);
                                    break;
                                }
                                if (state == RepositoryState.REVERTING_RESOLVED) {
                                    this.repo.writeMergeCommitMsg(null);
                                    this.repo.writeRevertHead(null);
                                }
                                break;
                            }
                            case REJECTED: 
                            case LOCK_FAILURE: {
                                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                            }
                            default: {
                                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", commitId.toString(), rc}));
                            }
                        }
                        Object var14_20 = null;
                        odi.release();
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        odi.release();
                        throw throwable;
                    }
                    Object var16_23 = null;
                    index.unlock();
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    index.unlock();
                    throw throwable;
                }
                ProcessResult postCommitHookResult = FS.DETECTED.runIfPresent(this.repo, Hook.POST_COMMIT, new String[0]);
                if (postCommitHookResult.getStatus() != ProcessResult.Status.OK || postCommitHookResult.getExitCode() != 0) {
                    // empty if block
                }
                if (this.amend && headId != null && !this.noPostRewrite) {
                    ObjectId oldId = headId;
                    ObjectId newId = revCommit.getId();
                    String rewritten = oldId.getName() + ' ' + newId.getName() + '\n';
                    ProcessResult postRewriteHookResult = FS.DETECTED.runIfPresent(this.repo, Hook.POST_REWRITE, new String[]{"amend"}, System.out, System.err, rewritten);
                    if (postRewriteHookResult.getStatus() != ProcessResult.Status.OK || postRewriteHookResult.getExitCode() != 0) {
                        // empty if block
                    }
                }
                RevCommit revCommit2 = revCommit;
                Object var18_26 = null;
                rw.dispose();
                return revCommit2;
            }
            catch (UnmergedPathException e) {
                throw new UnmergedPathsException(e);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfCommitCommand, e);
            }
        }
        catch (Throwable throwable) {
            Object var18_27 = null;
            rw.dispose();
            throw throwable;
        }
    }

    private void insertChangeId(ObjectId treeId) throws IOException {
        ObjectId firstParentId = null;
        if (!this.parents.isEmpty()) {
            firstParentId = this.parents.get(0);
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(treeId, firstParentId, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, changeId);
        if (changeId != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + changeId.getName() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirCache createTemporaryIndex(ObjectId headId, DirCache index, RevWalk rw) throws IOException {
        ObjectInserter inserter = null;
        DirCacheBuilder existingBuilder = index.builder();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder tempBuilder = inCoreIndex.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean emptyCommit = true;
        TreeWalk treeWalk = new TreeWalk(this.repo);
        int dcIdx = treeWalk.addTree(new DirCacheBuildIterator(existingBuilder));
        int fIdx = treeWalk.addTree(new FileTreeIterator(this.repo));
        int hIdx = -1;
        if (headId != null) {
            hIdx = treeWalk.addTree(rw.parseTree(headId));
        }
        treeWalk.setRecursive(true);
        String lastAddedFile = null;
        while (treeWalk.next()) {
            String path = treeWalk.getPathString();
            int pos = this.lookupOnly(path);
            CanonicalTreeParser hTree = null;
            if (hIdx != -1) {
                hTree = treeWalk.getTree(hIdx, CanonicalTreeParser.class);
            }
            DirCacheIterator dcTree = treeWalk.getTree(dcIdx, DirCacheIterator.class);
            if (pos >= 0) {
                boolean tracked;
                FileTreeIterator fTree = treeWalk.getTree(fIdx, FileTreeIterator.class);
                boolean bl = tracked = dcTree != null || hTree != null;
                if (!tracked) break;
                if (path.equals(lastAddedFile)) continue;
                lastAddedFile = path;
                if (fTree != null) {
                    boolean objectExists;
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    long entryLength = fTree.getEntryLength();
                    dcEntry.setLength(entryLength);
                    dcEntry.setLastModified(fTree.getEntryLastModified());
                    dcEntry.setFileMode(fTree.getIndexFileMode(dcTree));
                    boolean bl2 = objectExists = dcTree != null && fTree.idEqual(dcTree) || hTree != null && fTree.idEqual(hTree);
                    if (objectExists) {
                        dcEntry.setObjectId(fTree.getEntryObjectId());
                    } else if (FileMode.GITLINK.equals(dcEntry.getFileMode())) {
                        dcEntry.setObjectId(fTree.getEntryObjectId());
                    } else {
                        Object var28_26;
                        if (inserter == null) {
                            inserter = this.repo.newObjectInserter();
                        }
                        long contentLength = fTree.getEntryContentLength();
                        InputStream inputStream = fTree.openEntryStream();
                        try {
                            dcEntry.setObjectId(inserter.insert(3, contentLength, inputStream));
                            var28_26 = null;
                        }
                        catch (Throwable throwable) {
                            var28_26 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    existingBuilder.add(dcEntry);
                    tempBuilder.add(dcEntry);
                    if (emptyCommit && (hTree == null || !hTree.idEqual(fTree) || hTree.getEntryRawMode() != fTree.getEntryRawMode())) {
                        emptyCommit = false;
                    }
                } else if (emptyCommit && hTree != null) {
                    emptyCommit = false;
                }
                this.onlyProcessed[pos] = true;
                continue;
            }
            if (hTree != null) {
                DirCacheEntry dcEntry = new DirCacheEntry(path);
                dcEntry.setObjectId(hTree.getEntryObjectId());
                dcEntry.setFileMode(hTree.getEntryFileMode());
                tempBuilder.add(dcEntry);
            }
            if (dcTree == null) continue;
            existingBuilder.add(dcTree.getDirCacheEntry());
        }
        for (int i = 0; i < this.onlyProcessed.length; ++i) {
            if (this.onlyProcessed[i]) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i)));
        }
        if (emptyCommit) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        existingBuilder.commit();
        tempBuilder.finish();
        return inCoreIndex;
    }

    private int lookupOnly(String pathString) {
        String p = pathString;
        while (true) {
            int position;
            if ((position = Collections.binarySearch(this.only, p)) >= 0) {
                return position;
            }
            int l = p.lastIndexOf("/");
            if (l < 1) break;
            p = p.substring(0, l);
        }
        return -1;
    }

    private void processOptions(RepositoryState state, RevWalk rw) throws NoMessageException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null && !this.amend) {
            this.author = this.committer;
        }
        if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
            try {
                this.parents = this.repo.readMergeHeads();
                if (this.parents != null) {
                    for (int i = 0; i < this.parents.size(); ++i) {
                        RevObject ro = rw.parseAny(this.parents.get(i));
                        if (!(ro instanceof RevTag)) continue;
                        this.parents.set(i, rw.peel(ro));
                    }
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        } else if (state == RepositoryState.SAFE && this.message == null) {
            try {
                this.message = this.repo.readSquashCommitMsg();
                if (this.message != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
    }

    private boolean isMergeDuringRebase(RepositoryState state) {
        if (state != RepositoryState.REBASING_INTERACTIVE && state != RepositoryState.REBASING_MERGE) {
            return false;
        }
        try {
            return this.repo.readMergeHeads() != null;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.checkCallable();
        if (!this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = all;
        return this;
    }

    public CommitCommand setAmend(boolean amend) {
        this.checkCallable();
        this.amend = amend;
        return this;
    }

    public CommitCommand setOnly(String only) {
        String o;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string = o = only.endsWith("/") ? only.substring(0, only.length() - 1) : only;
        if (!this.only.contains(o)) {
            this.only.add(o);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public CommitCommand setReflogComment(String reflogComment) {
        this.reflogComment = reflogComment;
        return this;
    }

    public CommitCommand setNoVerify(boolean noVerify) {
        this.noVerify = noVerify;
        return this;
    }

    public CommitCommand setNoPostRewrite(boolean noPostRewrite) {
        this.noPostRewrite = noPostRewrite;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportPreparedMessage(String msg) throws IOException {
        File messageFile = this.getMessageFile(true);
        if (messageFile == null) {
            String errorMessage = MessageFormat.format(JGitText.get().cannotCreateCommitMessageFile, this.repo.getDirectory().getAbsolutePath() + "COMMIT_EDITMSG");
            throw new IOException(errorMessage);
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(messageFile));
            writer.write(msg);
            Object var5_5 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (writer == null) throw throwable;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPreparedMessage() throws IOException {
        String string;
        block4: {
            File messageFile = this.getMessageFile(false);
            if (messageFile == null) {
                return "";
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(messageFile));
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    builder.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    builder.append('\n');
                }
                string = builder.toString();
                Object var7_6 = null;
                if (reader == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_7 = null;
                    if (reader == null) break block5;
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return string;
    }

    private File getMessageFile(boolean createOnDemand) throws IOException {
        File messageFile;
        File gitdir = this.repo.getDirectory();
        File[] messageFileCandidates = gitdir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().equals("COMMIT_EDITMSG");
            }
        });
        if (messageFileCandidates.length > 0) {
            messageFile = messageFileCandidates[0];
        } else if (createOnDemand) {
            messageFile = new File(gitdir.getAbsolutePath(), "COMMIT_EDITMSG");
            messageFile.createNewFile();
        } else {
            messageFile = null;
        }
        return messageFile;
    }

    private void commitRejectedByHook(Hook cause, String errorDetails) throws RejectedCommitException {
        String errorMessage = MessageFormat.format(JGitText.get().commitRejectedByHook, cause.getName());
        if (errorDetails.length() > 0) {
            errorMessage = errorMessage + '\n' + errorDetails;
        }
        throw new RejectedCommitException(errorMessage);
    }
}

