/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.Hook;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.SystemReader;

public abstract class FS_POSIX
extends FS {
    protected File discoverGitPrefix() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (gitExe != null) {
            return gitExe.getParentFile().getParentFile();
        }
        if (SystemReader.getInstance().isMacOS()) {
            String w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            if (w == null || w.length() == 0) {
                return null;
            }
            File parentFile = new File(w).getParentFile();
            if (parentFile == null) {
                return null;
            }
            return parentFile.getParentFile();
        }
        return null;
    }

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
    }

    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    public void setHidden(File path, boolean hidden) throws IOException {
    }

    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    public ProcessResult runIfPresent(Repository repository, Hook hook, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        File hookFile = this.tryFindHook(repository, hook);
        if (hookFile == null) {
            return new ProcessResult(ProcessResult.Status.NOT_PRESENT);
        }
        String hookPath = hookFile.getAbsolutePath();
        File runDirectory = repository.isBare() ? repository.getDirectory() : repository.getWorkTree();
        String cmd = FileUtils.relativize(runDirectory.getAbsolutePath(), hookPath);
        ProcessBuilder hookProcess = this.runInShell(cmd, args);
        hookProcess.directory(runDirectory);
        try {
            return new ProcessResult(this.runProcess(hookProcess, outRedirect, errRedirect, stdinArgs), ProcessResult.Status.OK);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfHook, hook.getName()), e);
        }
        catch (InterruptedException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionHookExecutionInterrupted, hook.getName()), e);
        }
    }
}

