/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToMany;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.util.StoreUtil;

public class UnidirectionalManyToManyAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(UnidirectionalManyToManyAnnotator.class);

    public void annotate(PAnnotatedEReference aReference) {
        JoinTable joinTable;
        String featureLogStr = String.valueOf(aReference.getModelEReference().getName()) + "/" + aReference.getModelEReference().getEContainingClass().getName();
        if (aReference.getOneToMany() != null || aReference.getOneToOne() != null || aReference.getManyToOne() != null) {
            throw new StoreMappingException("The feature/eclass " + featureLogStr + " should be a ManyToMany but " + "it already has a OneToMany, OneToOne or ManyToOne annotation");
        }
        EReference eReference = (EReference)aReference.getModelElement();
        ManyToMany mtm = aReference.getManyToMany();
        if (log.isDebugEnabled()) {
            log.debug((Object)"ManyToMany present check if default information should be added");
        }
        mtm.setEModelElement((EModelElement)eReference);
        if (eReference.isContainment() || this.getPersistenceOptions().isSetDefaultCascadeOnNonContainment()) {
            this.setCascade((List<CascadeType>)mtm.getCascade(), eReference.isContainment());
        }
        if (mtm.getTargetEntity() == null) {
            mtm.setTargetEntity(this.getEntityName(eReference.getEReferenceType()));
        }
        if ((joinTable = aReference.getJoinTable()) == null) {
            joinTable = this.getFactory().createJoinTable();
            aReference.setJoinTable(joinTable);
            if (StoreUtil.isAuditEntryEClass(aReference.getModelEReference().getEContainingClass()) && this.getPersistenceOptions().getAuditingDBSchema() != null && this.getPersistenceOptions().getAuditingDBSchema().length() > 0) {
                joinTable.setSchema(this.getPersistenceOptions().getAuditingDBSchema());
            }
        }
        joinTable.setEModelElement((EModelElement)eReference);
        if (this.getPersistenceOptions().isSetForeignKeyNames() && aReference.getForeignKey() == null) {
            aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
        }
        if (joinTable.getName() == null) {
            joinTable.setName(this.getSqlNameStrategy().getJoinTableName(aReference));
        }
        if (joinTable.getJoinColumns() == null) {
            List<String> names = this.getSqlNameStrategy().getJoinTableJoinColumns(aReference, false);
            joinTable.getJoinColumns().addAll(this.getJoinColumns(names, false, true, (PAnnotation)mtm));
        }
    }
}

