/**
 * <copyright>
 * </copyright>
 *
 * $Id: HbAnnotatedEClassValidator.java,v 1.6 2008/04/23 15:44:25 mtaal Exp $
 */
package org.eclipse.emf.teneo.hibernate.hbmodel.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cache;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbannotation.FilterDef;
import org.eclipse.emf.teneo.hibernate.hbannotation.NamedQuery;
import org.eclipse.emf.teneo.hibernate.hbannotation.OnDelete;
import org.eclipse.emf.teneo.hibernate.hbannotation.Proxy;
import org.eclipse.emf.teneo.hibernate.hbannotation.Where;

/**
 * A sample validator interface for
 * {@link org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEClass}. This doesn't really do
 * anything, and it's not a real EMF artifact. It was generated by the
 * org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can
 * be extended. This can be disabled with -vmargs
 * -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface HbAnnotatedEClassValidator {
	boolean validate();

	boolean validateHbCache(Cache value);

	boolean validateHbOnDelete(OnDelete value);

	boolean validateHbWhere(Where value);

	boolean validateHbProxy(Proxy value);

	boolean validateHbNamedQuery(EList<NamedQuery> value);

	boolean validateFilterDef(EList<FilterDef> value);

	boolean validateFilter(EList<Filter> value);
}
