/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.auditing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.auditing.AuditDataStore;
import org.eclipse.emf.teneo.hibernate.auditing.AuditHandler;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditCommitInfo;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditEntry;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditKind;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoauditingFactory;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoauditingPackage;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;

public class AuditProcessHandler
implements AfterTransactionCompletionProcess,
BeforeTransactionCompletionProcess,
PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
ExtensionPoint {
    public static final long DEFAULT_END_TIMESTAMP = -1L;
    private static ThreadLocal<String> currentUserName = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private AuditDataStore dataStore;
    private Map<Transaction, List<AuditWork>> workQueue = new ConcurrentHashMap<Transaction, List<AuditWork>>();
    private int pruneCounter = 0;
    private long pruneTime = 0L;
    private long pruneInterval = 1000L;
    private List<String> auditEntityNames = null;
    private AuditHandler auditHandler = null;

    public static void setCurrentUserName(String user) {
        currentUserName.set(user);
    }

    private void addToAuditWorkQueue(EventSource session, TeneoAuditKind auditKind, Object entity) {
        List<Object> auditWorks;
        if (!this.auditHandler.isAudited(entity)) {
            return;
        }
        AuditWork auditWork = new AuditWork();
        auditWork.setAuditKind(auditKind);
        auditWork.setEntity(entity);
        if (this.workQueue.containsKey(session.getTransaction())) {
            auditWorks = this.workQueue.get(session.getTransaction());
        } else {
            auditWorks = new ArrayList();
            this.workQueue.put(session.getTransaction(), auditWorks);
            session.getActionQueue().registerProcess((AfterTransactionCompletionProcess)this);
            session.getActionQueue().registerProcess((BeforeTransactionCompletionProcess)this);
        }
        AuditWork existingAuditWork = null;
        for (AuditWork auditWork2 : auditWorks) {
            if (auditWork2.getEntity() != auditWork.getEntity()) continue;
            existingAuditWork = auditWork2;
            break;
        }
        if (existingAuditWork == null || existingAuditWork.getAuditKind() != TeneoAuditKind.ADD || auditWork.getAuditKind() != TeneoAuditKind.UPDATE) {
            if (existingAuditWork != null && existingAuditWork.getAuditKind() == TeneoAuditKind.ADD && auditWork.getAuditKind() == TeneoAuditKind.DELETE) {
                auditWorks.remove(existingAuditWork);
            } else if (existingAuditWork != null && existingAuditWork.getAuditKind() == TeneoAuditKind.UPDATE && auditWork.getAuditKind() == TeneoAuditKind.ADD) {
                auditWorks.remove(existingAuditWork);
            } else {
                auditWorks.remove(existingAuditWork);
                auditWorks.add(auditWork);
            }
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.UPDATE, event.getEntity());
    }

    public void onPostInsert(PostInsertEvent event) {
        this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.ADD, event.getEntity());
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.DELETE, event.getEntity());
    }

    public void doBeforeTransactionCompletion(SessionImplementor session) {
        if (!FlushMode.isManualFlushMode((FlushMode)session.getFlushMode())) {
            session.flush();
            List<AuditWork> auditWorks = this.getRemoveQueue((Session)session, false);
            if (auditWorks == null || auditWorks.isEmpty()) {
                return;
            }
            this.doAuditWorkInSession((Session)session, auditWorks);
        }
    }

    public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
        if (!success) {
            return;
        }
        List<AuditWork> auditWorks = this.getRemoveQueue((Session)session, true);
        if (auditWorks == null || auditWorks.isEmpty()) {
            this.pruneEntries(session);
            return;
        }
        Session tmpSession = null;
        boolean err = true;
        try {
            tmpSession = session.getFactory().openSession();
            tmpSession.beginTransaction();
            this.doAuditWorkInSession(tmpSession, auditWorks);
            tmpSession.getTransaction().commit();
            err = false;
        }
        finally {
            try {
                if (tmpSession != null && err) {
                    tmpSession.getTransaction().rollback();
                }
            }
            finally {
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
        }
        this.pruneEntries(session);
    }

    protected long getCommitTime() {
        return System.currentTimeMillis();
    }

    protected void doAuditWorkInSession(Session session, List<AuditWork> auditWorks) {
        long commitTime = this.getCommitTime();
        ArrayList<Object> toSaveEntries = new ArrayList<Object>();
        TeneoAuditCommitInfo commitInfo = TeneoauditingFactory.eINSTANCE.createTeneoAuditCommitInfo();
        if (currentUserName.get() != null) {
            commitInfo.setUser(currentUserName.get());
        }
        toSaveEntries.add(commitInfo);
        EClass lastEClass = null;
        EClass auditEntryEClass = null;
        for (AuditWork auditWork : auditWorks) {
            Object object = auditWork.getEntity();
            EClass eClass = this.auditHandler.getEClass(object);
            if (lastEClass != eClass) {
                auditEntryEClass = this.auditHandler.getAuditingModelElement(eClass);
                lastEClass = eClass;
            }
            String auditEntryEntityName = HbUtil.getEntityName(auditEntryEClass);
            TeneoAuditEntry auditEntry = (TeneoAuditEntry)auditEntryEClass.getEPackage().getEFactoryInstance().create(auditEntryEClass);
            auditEntry.setTeneo_audit_kind(auditWork.getAuditKind());
            auditEntry.setTeneo_commit_info(commitInfo);
            auditEntry.setTeneo_end(-1L);
            auditEntry.setTeneo_start(commitTime);
            auditEntry.setTeneo_object_id(this.auditHandler.entityToIdString(session, auditWork.getEntity()));
            if (auditWork.getEntity() instanceof EObject) {
                this.auditHandler.setContainerInfo(session, auditEntry, auditWork.getEntity());
            }
            this.auditHandler.copyContentToAuditEntry(session, auditWork.getEntity(), auditEntry, auditWork.getAuditKind() != TeneoAuditKind.DELETE);
            Query infoQuery = session.createQuery("select teneo_start from " + auditEntryEntityName + " e where teneo_object_id=:objectId and teneo_end=" + -1L);
            infoQuery.setMaxResults(1);
            infoQuery.setString("objectId", auditEntry.getTeneo_object_id());
            List list = infoQuery.list();
            if (!list.isEmpty()) {
                Long startTime = (Long)list.get(0);
                auditEntry.setTeneo_previous_start(startTime);
                this.updateEndTime(session, auditEntryEntityName, auditEntry.getTeneo_object_id(), commitTime - 1L, false);
                this.updateEndTimeDerivedObjects(session, auditEntryEClass, auditEntry.getTeneo_object_id(), commitTime - 1L);
            }
            toSaveEntries.add(auditEntry);
            this.setCommitInfoInReferencedObjects(auditEntry, toSaveEntries);
        }
        session.flush();
        for (AuditWork auditWork : toSaveEntries) {
            session.save(HbUtil.getEntityName(this.auditHandler.getEClass(auditWork)), (Object)auditWork);
        }
        session.flush();
        for (AuditWork auditWork : toSaveEntries) {
            session.evict((Object)auditWork);
        }
        this.getRemoveQueue(session, false);
        ++this.pruneCounter;
    }

    private void setCommitInfoInReferencedObjects(TeneoAuditEntry source, List<Object> toSaveObjects) {
        for (EReference eReference : source.eClass().getEAllReferences()) {
            if (!TeneoauditingPackage.eINSTANCE.getTeneoAuditEntry().isSuperTypeOf(eReference.getEReferenceType())) continue;
            if (eReference.isMany()) {
                int i = 0;
                for (Object value : (Collection)source.eGet((EStructuralFeature)eReference)) {
                    TeneoAuditEntry target = (TeneoAuditEntry)value;
                    toSaveObjects.add(target);
                    this.setAuditEntryValues(String.valueOf(eReference.getName()) + "_" + i++, source, target);
                }
                continue;
            }
            if (!source.eIsSet((EStructuralFeature)eReference) || source.eGet((EStructuralFeature)eReference) == null) continue;
            this.setAuditEntryValues(String.valueOf(eReference.getName()) + "_", source, (TeneoAuditEntry)source.eGet((EStructuralFeature)eReference));
            toSaveObjects.add((TeneoAuditEntry)source.eGet((EStructuralFeature)eReference));
        }
    }

    private void updateEndTimeDerivedObjects(Session session, EClass sourceEClass, String objectId, long newEnd) {
        for (EReference eReference : sourceEClass.getEAllReferences()) {
            EClass targetEClass = eReference.getEReferenceType();
            if (!TeneoauditingPackage.eINSTANCE.getTeneoAuditEntry().isSuperTypeOf(targetEClass)) continue;
            this.updateEndTime(session, this.dataStore.toEntityName(targetEClass), objectId, newEnd, true);
        }
    }

    private void updateEndTime(Session session, String entityName, String objectId, long newEnd, boolean useOwner) {
        String qryStr = "update " + entityName + " e set e.teneo_end = :newEnd " + "where e." + (useOwner ? "teneo_owner_object_id" : "teneo_object_id") + " = :objectId and e.teneo_end = :oldEnd";
        Query qry = session.createQuery(qryStr);
        qry.setParameter("newEnd", (Object)newEnd);
        qry.setParameter("objectId", (Object)objectId);
        qry.setParameter("oldEnd", (Object)-1L);
        qry.executeUpdate();
    }

    private void setAuditEntryValues(String prefix, TeneoAuditEntry source, TeneoAuditEntry target) {
        target.setTeneo_commit_info(source.getTeneo_commit_info());
        target.setTeneo_audit_kind(source.getTeneo_audit_kind());
        target.setTeneo_start(source.getTeneo_start());
        target.setTeneo_object_id(String.valueOf(prefix) + "_" + source.getTeneo_object_id());
        target.setTeneo_owner_object_id(source.getTeneo_object_id());
        target.setTeneo_previous_start(source.getTeneo_previous_start());
    }

    private synchronized List<AuditWork> getRemoveQueue(Session session, boolean remove) {
        List<AuditWork> auditWorks = this.workQueue.get(session.getTransaction());
        if (auditWorks != null && remove) {
            this.workQueue.remove(session.getTransaction());
        } else {
            this.workQueue.put(session.getTransaction(), new ArrayList());
        }
        return auditWorks;
    }

    public AuditDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(AuditDataStore dataStore) {
        this.dataStore = dataStore;
        this.pruneTime = 86400000L * Long.parseLong(dataStore.getDataStoreProperties().getProperty("teneo.mapping.auditing.prune.days"));
        this.pruneInterval = Long.parseLong(dataStore.getDataStoreProperties().getProperty("teneo.mapping.auditing.prune.commit.interval"));
        this.auditHandler = dataStore.getAuditHandler();
    }

    private synchronized void pruneEntries(SessionImplementor session) {
        if (this.pruneTime == 0L) {
            return;
        }
        if ((long)this.pruneCounter > this.pruneInterval) {
            return;
        }
        this.pruneCounter = 0;
        if (this.auditEntityNames == null) {
            this.auditEntityNames = new ArrayList<String>();
            EPackage[] ePackageArray = this.dataStore.getEPackages();
            int n = ePackageArray.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage = ePackageArray[n2];
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass) || !StoreUtil.isAuditEntryEClass((EClass)((EClass)eClassifier))) continue;
                    this.auditEntityNames.add(this.dataStore.toEntityName((EClass)eClassifier));
                }
                ++n2;
            }
        }
        Session tmpSession = null;
        boolean err = true;
        try {
            tmpSession = session.getFactory().openSession();
            tmpSession.beginTransaction();
            long currentPruneTime = System.currentTimeMillis() - this.pruneTime;
            for (String auditEntityName : this.auditEntityNames) {
                Query qry = tmpSession.createQuery("select e from " + auditEntityName + " e where e.teneo_start < :pruneTime");
                qry.setParameter("pruneTime", (Object)currentPruneTime);
                ScrollableResults results = qry.scroll(ScrollMode.FORWARD_ONLY);
                while (results.next()) {
                    tmpSession.delete(results.get()[0]);
                }
                results.close();
            }
            tmpSession.getTransaction().commit();
            err = false;
        }
        finally {
            try {
                if (tmpSession != null && err) {
                    tmpSession.getTransaction().rollback();
                }
            }
            finally {
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
        }
    }

    public void setPruneTime(long thePruneTime) {
        this.pruneTime = thePruneTime;
    }

    public long getPruneTime() {
        return this.pruneTime;
    }

    protected class AuditWork {
        private Object entity;
        private TeneoAuditKind auditKind;

        protected AuditWork() {
        }

        public Object getEntity() {
            return this.entity;
        }

        public void setEntity(Object entity) {
            this.entity = entity;
        }

        public TeneoAuditKind getAuditKind() {
            return this.auditKind;
        }

        public void setAuditKind(TeneoAuditKind auditKind) {
            this.auditKind = auditKind;
        }
    }
}

