/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.tuplizer;

import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.teneo.ERuntime;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.tuplizer.EMFInstantiator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.component.AbstractComponentTuplizer;

public class EMFComponentTuplizer
extends AbstractComponentTuplizer {
    private static final long serialVersionUID = 6316160569897347041L;
    private EClass eClass;

    public EMFComponentTuplizer(Component component) {
        super(component);
    }

    private EClass getEClass(Component component) {
        if (this.eClass == null) {
            HbDataStore ds = HbHelper.INSTANCE.getDataStore(component);
            this.eClass = ds.getEntityNameStrategy().toEClass(component.getComponentClassName());
            if (this.eClass == null) {
                this.eClass = ERuntime.INSTANCE.getEClass(component.getComponentClass());
            }
            if (this.eClass == null) {
                this.eClass = HbUtil.getEClassFromMeta(component);
            }
        }
        if (this.eClass == null) {
            throw new HbMapperException("No eclass found for entityname: " + component.getComponentClassName());
        }
        return this.eClass;
    }

    protected Instantiator buildInstantiator(Component component, Property property) {
        return this.buildInstantiator(component);
    }

    protected Instantiator buildInstantiator(Component component) {
        return new EMFInstantiator(this.getEClass(component), component);
    }

    protected Getter buildGetter(Component component, Property mappedProperty) {
        return this.getPropertyAccessor(mappedProperty, component).getGetter(null, mappedProperty.getName());
    }

    protected Setter buildSetter(Component component, Property mappedProperty) {
        return this.getPropertyAccessor(mappedProperty, component).getSetter(null, mappedProperty.getName());
    }

    public PropertyAccessor getPropertyAccessor(Property mappedProperty, Component comp) {
        HbDataStore ds = HbHelper.INSTANCE.getDataStore(comp);
        return HbUtil.getPropertyAccessor(mappedProperty, ds, comp.getComponentClassName(), this.getEClass(comp));
    }

    public Class<?> getMappedClass() {
        return EObject.class;
    }

    public Object getParent(Object component) {
        return null;
    }

    public boolean hasParentProperty() {
        return false;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public void setParent(Object component, Object parent, SessionFactoryImplementor factory) {
    }
}

