/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.StoreAnnotationsException;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.EFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.DiscriminatorColumn;
import org.eclipse.emf.teneo.annotations.pannotation.DiscriminatorValue;
import org.eclipse.emf.teneo.annotations.pannotation.Entity;
import org.eclipse.emf.teneo.annotations.pannotation.Inheritance;
import org.eclipse.emf.teneo.annotations.pannotation.InheritanceType;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationFactory;
import org.eclipse.emf.teneo.annotations.pannotation.PrimaryKeyJoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.SecondaryTable;
import org.eclipse.emf.teneo.annotations.pannotation.Table;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.mapping.strategy.StrategyUtil;

public class EClassAnnotator
extends AbstractAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(EClassAnnotator.class);
    private InheritanceType optionDefaultInheritanceMapping = InheritanceType.SINGLE_TABLE;
    private final ArrayList<PAnnotatedEClass> processedAClasses = new ArrayList();
    private EFeatureAnnotator eFeatureAnnotator = null;

    protected boolean annotate(PAnnotatedEClass aClass) {
        InheritanceType inheritanceType;
        boolean mappable;
        boolean isInheritanceRoot;
        if (aClass == null) {
            throw new StoreAnnotationsException("Mapping Exception, no Annotated Class for EClass, a common cause is that you did not register all EPackages in the DataStore/Helper Class. When there are references between EClasses in different EPackages then they need to be handled in one DataStore/Helper Class.");
        }
        EClass eclass = (EClass)aClass.getModelElement();
        if (this.processedAClasses.contains(aClass)) {
            return false;
        }
        if (!this.getPersistenceOptions().isMapDocumentRoot() && ExtendedMetaData.INSTANCE.isDocumentRoot(eclass)) {
            return false;
        }
        log.debug((Object)("Creating mapping for eclass " + eclass.getName()));
        for (EClass superEclass : aClass.getModelEClass().getESuperTypes()) {
            PAnnotatedEClass superAClass = aClass.getPaModel().getPAnnotated(superEclass);
            if (superAClass == null) {
                throw new StoreAnnotationsException("Mapping Exception, no Annotated Class for EClass: " + superEclass.getName() + " a common cause is that you did not register all EPackages in the DataStore/Helper Class. " + "When there are references between EClasses in different EPackages then they need to be handled in one DataStore/Helper Class.");
            }
            if (this.processedAClasses.contains(superAClass)) continue;
            this.annotate(superAClass);
            if (superAClass.getEavMapping() == null) continue;
            aClass.setEavMapping(PannotationFactory.eINSTANCE.createEAVMapping());
        }
        if (this.getPersistenceOptions().isEAVMapping() && aClass.getNoEAVMapping() == null) {
            aClass.setEavMapping(PannotationFactory.eINSTANCE.createEAVMapping());
        }
        log.debug((Object)(" Adding default annotations for EClass: " + aClass.getModelElement().getName()));
        this.processedAClasses.add(aClass);
        log.debug((Object)"Setting the superentity of the eclass");
        this.setSuperEntity(aClass);
        boolean bl = isInheritanceRoot = aClass.getPaSuperEntity() == null || aClass.getPaSuperEntity().getMappedSuperclass() != null;
        if (isInheritanceRoot && aClass.getEavMapping() != null) {
            Inheritance inheritance = PannotationFactory.eINSTANCE.createInheritance();
            inheritance.setStrategy(InheritanceType.SINGLE_TABLE);
            aClass.setInheritance(inheritance);
        }
        if ((mappable = this.isMappableAnnotatedClass(aClass)) && aClass.getEntity() == null && aClass.getEmbeddable() == null) {
            Entity entity = this.getFactory().createEntity();
            entity.setEModelElement((EModelElement)eclass);
            aClass.setEntity(entity);
        }
        if (aClass.getEntity() != null && aClass.getEntity().getName() == null) {
            aClass.getEntity().setName(this.getEntityNameStrategy().toEntityName(eclass));
        }
        if (aClass.getInheritance() != null) {
            inheritanceType = aClass.getInheritance().getStrategy();
        } else {
            Inheritance inheritanceFromSupers = this.getInheritanceFromSupers(aClass);
            InheritanceType inheritanceType2 = inheritanceType = inheritanceFromSupers != null ? inheritanceFromSupers.getStrategy() : this.optionDefaultInheritanceMapping;
            if (isInheritanceRoot) {
                Inheritance inheritance = this.getFactory().createInheritance();
                inheritance.setStrategy(inheritanceType);
                inheritance.setEModelElement((EModelElement)eclass);
                aClass.setInheritance(inheritance);
            }
        }
        if (!isInheritanceRoot && inheritanceType.equals((Object)InheritanceType.JOINED) && aClass.getPrimaryKeyJoinColumns().size() == 0) {
            ArrayList<String> idFeatures = new ArrayList<String>();
            PAnnotatedEClass aSuperClass = null;
            for (EClass eSuperClass : aClass.getModelEClass().getESuperTypes()) {
                aSuperClass = this.getAnnotatedModel().getPAnnotated(eSuperClass);
                idFeatures.addAll(StrategyUtil.getIDFeaturesNames(aSuperClass, this.getPersistenceOptions().getDefaultIDFeatureName(), this.getPersistenceOptions()));
                if (!idFeatures.isEmpty()) break;
            }
            for (String idFeature : idFeatures) {
                PrimaryKeyJoinColumn pkjc = this.getFactory().createPrimaryKeyJoinColumn();
                pkjc.setName(this.getSqlNameStrategy().getPrimaryKeyJoinColumnName(aSuperClass, idFeature));
                aClass.getPrimaryKeyJoinColumns().add((Object)pkjc);
            }
        }
        if (aClass.getTable() == null && (isInheritanceRoot && inheritanceType.equals((Object)InheritanceType.SINGLE_TABLE) || inheritanceType.equals((Object)InheritanceType.JOINED) || inheritanceType.equals((Object)InheritanceType.TABLE_PER_CLASS))) {
            Table table = this.getFactory().createTable();
            table.setEModelElement((EModelElement)eclass);
            aClass.setTable(table);
        }
        if (aClass.getTable() != null && aClass.getTable().getName() == null) {
            aClass.getTable().setName(this.getSqlNameStrategy().getTableName(aClass));
        }
        if (this.addDiscriminator(aClass)) {
            DiscriminatorColumn dc;
            if (isInheritanceRoot && aClass.getDiscriminatorColumn() == null && inheritanceType.equals((Object)InheritanceType.SINGLE_TABLE)) {
                dc = this.getFactory().createDiscriminatorColumn();
                dc.setEModelElement((EModelElement)eclass);
                dc.setName(this.getSqlNameStrategy().getDiscriminatorColumnName());
                aClass.setDiscriminatorColumn(dc);
            }
            if (aClass.getDiscriminatorColumn() != null) {
                if (aClass.getDiscriminatorColumn().getColumn() == null) {
                    dc = aClass.getDiscriminatorColumn();
                    Column col = this.getFactory().createColumn();
                    dc.setColumn(col);
                    col.setName(dc.getName());
                    col.setIndex(String.valueOf(aClass.getTable().getName()) + dc.getName());
                    col.setNullable(false);
                }
                if (aClass.getDiscriminatorColumn().getColumn().getName() == null) {
                    aClass.getDiscriminatorColumn().getColumn().setName(aClass.getDiscriminatorColumn().getName());
                }
            }
            if (aClass.getDiscriminatorValue() == null && inheritanceType.equals((Object)InheritanceType.SINGLE_TABLE)) {
                DiscriminatorValue dv = this.getFactory().createDiscriminatorValue();
                DiscriminatorColumn dc2 = this.getDiscriminatorColumn(aClass);
                if (dc2 != null && dc2.getDiscriminatorType() != null && dc2.getDiscriminatorType().getValue() == 2) {
                    String entityName = this.getEntityName(eclass);
                    log.warn((Object)("Generating an integer discriminator value for entity " + entityName + ". The hashcode of the entityName is used as the discriminatorvalue. This may not be unique! To ensure uniques you should set a @DiscriminatorValue annotation"));
                    dv.setValue("" + entityName.hashCode());
                } else {
                    dv.setValue(this.getEntityName(eclass));
                }
                dv.setEModelElement((EModelElement)eclass);
                aClass.setDiscriminatorValue(dv);
            }
        }
        for (SecondaryTable secondaryTable : aClass.getSecondaryTables()) {
            EList pkJoinColumns = secondaryTable.getPkJoinColumns();
            if (pkJoinColumns.size() != 0) continue;
            List aIdFeatures = aClass.getPaIdFeatures();
            for (PAnnotatedEStructuralFeature idef : aIdFeatures) {
                PrimaryKeyJoinColumn pkJoinColumn = PannotationFactory.eINSTANCE.createPrimaryKeyJoinColumn();
                pkJoinColumn.setName(this.getSqlNameStrategy().getSecondaryTablePrimaryKeyJoinColumnName(idef));
                pkJoinColumns.add((Object)pkJoinColumn);
            }
        }
        for (PAnnotatedEStructuralFeature aStructuralFeature : aClass.getPaEStructuralFeatures()) {
            this.eFeatureAnnotator.annotate(aStructuralFeature);
        }
        return true;
    }

    protected boolean addDiscriminator(PAnnotatedEClass aClass) {
        return true;
    }

    protected DiscriminatorColumn getDiscriminatorColumn(PAnnotatedEClass aClass) {
        if (aClass.getDiscriminatorColumn() != null) {
            return aClass.getDiscriminatorColumn();
        }
        if (aClass.getPaSuperEntity() != null) {
            return this.getDiscriminatorColumn(aClass.getPaSuperEntity());
        }
        return null;
    }

    protected void initialize() {
        super.initialize();
        this.eFeatureAnnotator = this.createAnnotator(EFeatureAnnotator.class);
    }

    protected Inheritance getInheritanceFromSupers(PAnnotatedEClass childPA) {
        if (childPA == null) {
            return null;
        }
        if (childPA.getInheritance() != null) {
            return childPA.getInheritance();
        }
        return this.getInheritanceFromSupers(childPA.getPaSuperEntity());
    }

    protected void setSuperEntity(PAnnotatedEClass aClass) {
        assert (aClass.getPaSuperEntity() == null);
        EClass eclass = aClass.getModelEClass();
        if (eclass.getESuperTypes().size() == 0) {
            return;
        }
        if (aClass.getEntity() != null && aClass.getEntity().getExtends() != null) {
            EClass superEClass = aClass.getPaModel().getEClass(aClass.getEntity().getExtends());
            PAnnotatedEClass superAClass = aClass.getPaModel().getPAnnotated(superEClass);
            if (!this.processedAClasses.contains(superAClass)) {
                this.annotate(superAClass);
            }
            aClass.setPaSuperEntity(superAClass);
            return;
        }
        PAnnotatedEClass superAClass = aClass.getPaModel().getPAnnotated((EClass)eclass.getESuperTypes().get(0));
        if (superAClass.getEntity() != null || superAClass.getMappedSuperclass() != null) {
            aClass.setPaSuperEntity(superAClass);
        }
    }

    protected boolean isMappableAnnotatedClass(PAnnotatedEClass aClass) {
        EClass eclass = aClass.getModelEClass();
        if (!this.mapInterfaceEClass() && eclass.isInterface()) {
            log.debug((Object)"Not mapping interfaces and this is an interface eclass, ignore it");
            return false;
        }
        if (aClass.getTransient() != null) {
            return false;
        }
        if (!this.getPersistenceOptions().isSetEntityAutomatically() && aClass.getEntity() == null && aClass.getEmbeddable() == null) {
            log.debug((Object)("Entities are not added automatically and this eclass: " + aClass.getModelEClass().getName() + " does not have an entity/embeddable annotation."));
            return false;
        }
        if (!this.mapMappedSuperEClass() && aClass.getMappedSuperclass() != null) {
            if (aClass.getEntity() != null) {
                log.warn((Object)("EClass " + eclass.getName() + " has entity as well as mappedsuperclass annotation, following mappedsuperclass annotation, therefore ignoring it for the mapping"));
            }
            return false;
        }
        return true;
    }

    protected boolean mapInterfaceEClass() {
        return false;
    }

    protected boolean mapMappedSuperEClass() {
        return true;
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        if (persistenceOptions.getInheritanceMapping() != null) {
            InheritanceType it = InheritanceType.get((String)persistenceOptions.getInheritanceMapping());
            if (it == InheritanceType.JOINED) {
                this.optionDefaultInheritanceMapping = InheritanceType.JOINED;
                log.debug((Object)"Option inheritance: joined");
            } else if (it == InheritanceType.SINGLE_TABLE) {
                this.optionDefaultInheritanceMapping = InheritanceType.SINGLE_TABLE;
                log.debug((Object)"Option inheritance: single");
            } else if (it == InheritanceType.TABLE_PER_CLASS) {
                this.optionDefaultInheritanceMapping = InheritanceType.TABLE_PER_CLASS;
                log.debug((Object)"Option inheritance: table per class");
            } else {
                throw new IllegalArgumentException("Inheritance mapping option: " + persistenceOptions.getInheritanceMapping() + " is not supported");
            }
        }
    }
}

