/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EcoreModelElementType
implements UserType,
ParameterizedType {
    private static final int[] SQL_TYPES = new int[]{12};
    private static final String SEPARATOR = "_;_";
    private EPackage.Registry registry = PackageRegistryProvider.getInstance().getPackageRegistry();

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.convertFromString((String)((Object)cached));
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return this.convertToString(value);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return this.convertFromString(value);
    }

    private Object convertFromString(String value) {
        String[] values = value.split(SEPARATOR);
        String nsuri = values[0];
        EPackage ePackage = this.registry.getEPackage(nsuri);
        if (values.length == 1) {
            return ePackage;
        }
        if (values.length == 2) {
            String eClassifierName = values[1];
            EClassifier eClassifier = ePackage.getEClassifier(eClassifierName);
            return eClassifier;
        }
        String eClassifierName = values[1];
        EClassifier eClassifier = ePackage.getEClassifier(eClassifierName);
        EClass eClass = (EClass)eClassifier;
        String eFeatureName = values[2];
        return eClass.getEStructuralFeature(eFeatureName);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, this.convertToString(value));
        }
    }

    private String convertToString(Object value) {
        if (value instanceof EPackage) {
            String uri = ((EPackage)value).getNsURI();
            return uri;
        }
        if (value instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)value;
            String uri = eClassifier.getEPackage().getNsURI();
            String eClassifierName = eClassifier.getName();
            return String.valueOf(uri) + SEPARATOR + eClassifierName;
        }
        EStructuralFeature feature = (EStructuralFeature)value;
        String uri = feature.getEContainingClass().getEPackage().getNsURI();
        String eClassName = feature.getEContainingClass().getName();
        String eFeatureName = feature.getName();
        return String.valueOf(uri) + SEPARATOR + eClassName + SEPARATOR + eFeatureName;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class<?> returnedClass() {
        return EStructuralFeature.class;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public void setParameterValues(Properties parameters) {
    }
}

