/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IParameterizedConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.util.XmlConfig;
import org.eclipse.emf.validation.xml.IXmlConstraintDescriptor;

public final class XmlConstraintDescriptor
extends AbstractConstraintDescriptor
implements IXmlConstraintDescriptor,
IParameterizedConstraintDescriptor {
    static final String RULE_INCOMPLETE;
    static final String RULE_ID;
    static final String RULE_NAME;
    static final String RULE_BODY;
    static final String MESSAGE_PATTERN;
    private static final String NAMESPACE_URI_SEPARATOR = ":";
    private static final String EOBJECT_CLASS_NAME = "org.eclipse.emf.ecore.EObject";
    private final IConfigurationElement config;
    private String name;
    private String id;
    private int statusCode;
    private String pluginId;
    private String description;
    private ConstraintSeverity severity;
    private EvaluationMode mode;
    private Map targetMap;
    private String messagePattern;
    private String body;
    private boolean resolved;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        RULE_INCOMPLETE = ValidationMessages.rule_incomplete_ERROR_;
        RULE_ID = ValidationMessages.rule_id;
        RULE_NAME = ValidationMessages.rule_name;
        RULE_BODY = ValidationMessages.rule_body;
        MESSAGE_PATTERN = ValidationMessages.rule_message;
    }

    public XmlConstraintDescriptor(IConfigurationElement config) throws ConstraintExistsException {
        block11: {
            int newStatusCode;
            this.severity = ConstraintSeverity.ERROR;
            this.targetMap = new HashMap();
            this.resolved = false;
            this.config = config;
            this.name = config.getAttribute("name");
            String statusCodeStr = config.getAttribute("statusCode");
            this.pluginId = config.getDeclaringExtension().getNamespaceIdentifier();
            this.id = XmlConstraintDescriptor.normalizedId(this.pluginId, config.getAttribute("id"));
            this.setEnabled(!EMFModelValidationPreferences.isConstraintDisabled(this.id));
            try {
                newStatusCode = Integer.parseInt(statusCodeStr);
            }
            catch (NumberFormatException numberFormatException) {
                newStatusCode = 1;
            }
            this.statusCode = newStatusCode;
            try {
                this.assertNotNull(this.id, RULE_ID);
                this.assertNotNull(this.name, RULE_NAME);
                this.parseDescription(config);
                this.parseSeverity(config);
                this.parseTargets(config);
                this.parseMessagePattern(config);
                this.setBody(config.getValue());
                ConstraintRegistry.getInstance().register(this);
                if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
                    Trace.trace("Initialized constraint " + this.id);
                }
            }
            catch (CoreException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.catching(clazz, "<init>", e);
                if (this.id == null) {
                    this.id = "$error." + System.identityHashCode(this);
                }
                if (this.name == null) {
                    this.name = this.id;
                }
                this.statusCode = 70;
                this.setError(e);
                this.setMessagePattern(e.getLocalizedMessage());
                if (!Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) break block11;
                Trace.trace("Initialized constraint " + this.id + " as error constraint.");
            }
        }
    }

    public static String normalizedId(String pluginId, String id) {
        if (!$assertionsDisabled && pluginId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        String result = id;
        if (!result.startsWith(pluginId)) {
            result = String.valueOf(pluginId) + '.' + result;
        }
        return result;
    }

    public IConfigurationElement getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public ConstraintSeverity getSeverity() {
        return this.severity;
    }

    private void setSeverity(ConstraintSeverity severity) {
        if (!$assertionsDisabled && (severity == null || severity.isNull())) {
            throw new AssertionError();
        }
        this.severity = severity;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private TargetDescriptor getTarget(Object key) {
        TargetDescriptor result;
        if (Trace.shouldTraceEntering()) {
            Trace.entering(this.getClass(), "getTarget", new Object[]{key});
        }
        if ((result = (TargetDescriptor)this.targetMap.get(key)) == null) {
            result = new TargetDescriptor();
            this.targetMap.put(key, result);
            if (key instanceof EClass) {
                this.inheritTriggers((EClass)key, result);
            }
        }
        if (Trace.shouldTraceExiting()) {
            Trace.exiting(this.getClass(), "getTarget", result);
        }
        return result;
    }

    public EvaluationMode getEvaluationMode() {
        return this.mode;
    }

    private void setEvaluationMode(EvaluationMode mode) {
        this.mode = mode;
    }

    public void resolveTargetTypes(String[] namespaceUris) {
        Map.Entry next;
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        Map oldMap = this.targetMap;
        this.targetMap = new HashMap();
        Iterator iter = oldMap.entrySet().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            String typeName = (String)next.getKey();
            EClass targetEClass = null;
            int separatorPosition = typeName.indexOf(NAMESPACE_URI_SEPARATOR);
            if (separatorPosition != -1) {
                String namespaceUri = typeName.substring(separatorPosition + 1);
                typeName = typeName.substring(0, separatorPosition);
                targetEClass = ModelValidationService.findClass(namespaceUri, typeName);
            } else {
                int i = 0;
                while (targetEClass == null && i < namespaceUris.length) {
                    targetEClass = ModelValidationService.findClass(namespaceUris[i], typeName);
                    ++i;
                }
            }
            if (targetEClass != null) {
                this.targetMap.put(targetEClass, next.getValue());
                if (!Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) continue;
                Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS, "Resolved target: " + typeName + " for: " + this);
                continue;
            }
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
                Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS, "Failed to resolve target: " + typeName + " for: " + this);
            }
            Log.warningMessage(70, EMFModelValidationStatusCodes.TARGET_TYPE_NOT_FOUND_MSG, new Object[]{this.getId(), typeName});
        }
        iter = this.targetMap.entrySet().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            this.inheritTriggers((EClass)next.getKey(), (TargetDescriptor)next.getValue());
        }
    }

    private void inheritTriggers(EClass target, TargetDescriptor descriptor) {
        Iterator iter = this.targetMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry next = iter.next();
            EClass otherTarget = (EClass)next.getKey();
            if (otherTarget == target || !otherTarget.isSuperTypeOf(target)) continue;
            descriptor.merge((TargetDescriptor)next.getValue());
        }
    }

    private boolean isUniversal() {
        return this.targetMap.isEmpty();
    }

    public boolean targetsTypeOf(EObject eObject) {
        return eObject == null ? false : this.isUniversal() || this.targetsType(eObject.eClass());
    }

    private boolean targetsType(EClass eClass) {
        return this.getTarget(eClass).isExplicit();
    }

    private TargetDescriptor addTargetType(String typeName) {
        TargetDescriptor result = typeName == null ? this.getTarget(EOBJECT_CLASS_NAME) : this.getTarget(typeName);
        result.setExplicit();
        return result;
    }

    public boolean targetsEvent(Notification notification) {
        if (notification.getNotifier() instanceof EObject) {
            EObject eObject = (EObject)notification.getNotifier();
            EMFEventType eventType = EMFEventType.getInstance(notification.getEventType());
            EStructuralFeature changedFeature = null;
            if (notification.getFeature() instanceof EStructuralFeature) {
                changedFeature = (EStructuralFeature)notification.getFeature();
            }
            return eObject == null || eventType.isNull() ? false : this.isUniversal() && EMFEventType.getPredefinedInstances().contains(eventType) || !this.isUniversal() && this.targetsEvent(eObject.eClass(), eventType, changedFeature);
        }
        return false;
    }

    private boolean targetsEvent(EClass eClass, EMFEventType eventType, EStructuralFeature feature) {
        return this.getTarget(eClass).hasEvent(eventType, feature);
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    private void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public String getBody() {
        return this.body;
    }

    private void setBody(String body) {
        this.body = body;
    }

    public String getLanguage() {
        return this.getConfig().getAttribute("lang");
    }

    public String getParameterValue(String name) {
        String result = XmlConfig.getParameter(this.getConfig(), name);
        if (result == null) {
            if ("class".equals(name)) {
                result = this.getConfig().getAttribute("class");
            } else if ("bundle".equals(name)) {
                result = this.getConfig().getDeclaringExtension().getNamespaceIdentifier();
            }
        }
        return result;
    }

    private void parseDescription(IConfigurationElement extConfig) {
        IConfigurationElement[] descConfig = extConfig.getChildren("description");
        if (descConfig.length > 0) {
            this.setDescription(descConfig[0].getValue());
        }
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
            Trace.trace("Parsed constraint " + this.id + " description");
        }
    }

    private void parseMessagePattern(IConfigurationElement extConfig) throws CoreException {
        IConfigurationElement[] msgConfig = extConfig.getChildren("message");
        String newMessagePattern = null;
        if (msgConfig.length > 0) {
            newMessagePattern = msgConfig[0].getValue();
        }
        this.assertNotNull(newMessagePattern, MESSAGE_PATTERN);
        this.setMessagePattern(newMessagePattern);
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
            Trace.trace("Parsed constraint " + this.id + " message: " + newMessagePattern);
        }
    }

    private void parseMode(IConfigurationElement extConfig) {
        String modeName = extConfig.getAttribute("mode");
        if (modeName == null) {
            this.setEvaluationMode(EvaluationMode.BATCH);
        } else {
            this.setEvaluationMode(EvaluationMode.getInstance(modeName));
        }
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
            Trace.trace("Parsed constraint " + this.id + " mode: " + modeName);
        }
    }

    private void parseSeverity(IConfigurationElement extConfig) {
        String severityName = extConfig.getAttribute("severity");
        if (severityName == null) {
            this.setSeverity(ConstraintSeverity.ERROR);
        } else {
            this.setSeverity(ConstraintSeverity.getInstance(severityName));
        }
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
            Trace.trace("Parsed constraint " + this.id + " severity: " + severityName);
        }
    }

    private void parseTargets(IConfigurationElement extConfig) {
        this.parseMode(extConfig);
        IConfigurationElement[] targets = extConfig.getChildren("target");
        int i = 0;
        while (i < targets.length) {
            IConfigurationElement target = targets[i];
            TargetDescriptor targetType = this.addTargetType(target.getAttribute("class"));
            if (this.getEvaluationMode().isLive()) {
                IConfigurationElement[] events = XmlConfig.getEvents(target);
                int j = 0;
                while (j < events.length) {
                    EMFEventType eventType = EMFEventType.getInstance(events[j].getAttribute("name"));
                    if (!eventType.isNull()) {
                        IConfigurationElement[] features = events[j].getChildren("feature");
                        if (features == null || features.length == 0) {
                            targetType.addEvent(eventType);
                        } else {
                            int k = 0;
                            while (k < features.length) {
                                targetType.addEvent(eventType, features[k].getAttribute("name"));
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
                Trace.trace("Parsed constraint " + this.id + " target: " + target.getAttribute("class") + ": " + targetType);
            }
            ++i;
        }
    }

    private void assertNotNull(Object value, String missingItem) throws CoreException {
        if (value == null) {
            CoreException ce = new CoreException((IStatus)new Status(4, EMFModelValidationPlugin.getPluginId(), 70, EMFModelValidationPlugin.getMessage(RULE_INCOMPLETE, new String[]{missingItem}), null));
            Trace.throwing(this.getClass(), "assertNotNull", ce);
            throw ce;
        }
    }

    private static class TargetDescriptor {
        private final Collection nonFeatureSpecificEvents = new HashSet();
        private final Map featureSpecificEvents = new HashMap();
        private boolean explicit;

        TargetDescriptor() {
        }

        boolean isExplicit() {
            return this.explicit;
        }

        void setExplicit() {
            this.explicit = true;
        }

        void addEvent(EMFEventType eventType) {
            this.nonFeatureSpecificEvents.add(eventType);
        }

        void addEvent(EMFEventType eventType, String featureName) {
            if (featureName != null) {
                HashSet<String> currentFeatures = (HashSet<String>)this.featureSpecificEvents.get(eventType);
                if (currentFeatures == null) {
                    currentFeatures = new HashSet<String>();
                    this.featureSpecificEvents.put(eventType, currentFeatures);
                }
                currentFeatures.add(featureName);
            }
        }

        boolean hasEvent(EMFEventType eventType, EStructuralFeature feature) {
            boolean result;
            if (Trace.shouldTraceEntering()) {
                Trace.entering(this.getClass(), "hasEvent", new Object[]{eventType, feature});
            }
            String featureName = feature == null ? null : feature.getName();
            boolean bl = result = this.nonFeatureSpecificEvents.isEmpty() && this.featureSpecificEvents.isEmpty() && this.isExplicit() && EMFEventType.getPredefinedInstances().contains(eventType);
            if (!result) {
                if (this.nonFeatureSpecificEvents.contains(eventType)) {
                    result = true;
                } else if (featureName != null && this.featureSpecificEvents.containsKey(eventType)) {
                    Collection eventFeatures = (Collection)this.featureSpecificEvents.get(eventType);
                    result = eventFeatures.contains(featureName);
                }
            }
            if (Trace.shouldTraceExiting()) {
                Trace.exiting(this.getClass(), "hasEvent", result ? Boolean.TRUE : Boolean.FALSE);
            }
            return result;
        }

        void merge(TargetDescriptor parent) {
            if (parent.isExplicit()) {
                this.setExplicit();
            }
            this.nonFeatureSpecificEvents.addAll(parent.nonFeatureSpecificEvents);
            Iterator iter = parent.featureSpecificEvents.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry next = iter.next();
                Object eventType = next.getKey();
                Collection features = (Collection)next.getValue();
                Collection myFeatures = (Collection)this.featureSpecificEvents.get(eventType);
                if (myFeatures == null) {
                    this.featureSpecificEvents.put(eventType, new HashSet(features));
                    continue;
                }
                myFeatures.addAll(features);
            }
        }
    }
}

