/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.breakpoint.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.internal.ui.debug.breakpoint.actions.BreakpointActionGroup;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class EnableDisableBreakpointAction
extends Action {
    private final TextEditor editor;
    private final BreakpointActionGroup group;
    private IBreakpoint fBreakpoint;

    protected EnableDisableBreakpointAction(TextEditor editor, BreakpointActionGroup group) {
        this.editor = editor;
        this.group = group;
        this.setToolTipText("enable or disable breakpoint");
    }

    public void updateText() {
        block5: {
            this.fBreakpoint = this.getBreakpoint();
            this.setEnabled(this.fBreakpoint != null);
            if (this.fBreakpoint != null) {
                try {
                    if (this.fBreakpoint.isEnabled()) {
                        this.setText("Disable Breakpoint");
                        break block5;
                    }
                    this.setText("Enable Breakpoint");
                }
                catch (CoreException coreException) {}
            } else {
                this.setText("Disable Breakpoint");
            }
        }
    }

    public void run() {
        if (this.fBreakpoint != null) {
            try {
                this.fBreakpoint.setEnabled(!this.fBreakpoint.isEnabled());
            }
            catch (CoreException e) {
                Activator.logError("Failed to toggle breakpoint enablement.", (Exception)((Object)e));
            }
        }
    }

    protected IBreakpoint getBreakpoint() {
        boolean isRulerSelected = this.group.isRulerSelected();
        int selectedLine = this.group.getLastSelectedLine();
        int selectedOffset = this.group.getLastSelectedOffset();
        IAnnotationModel annotationModel = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) continue;
                    Position position = annotationModel.getPosition((Annotation)markerAnnotation);
                    int line = document.getLineOfOffset(position.offset);
                    if ((!isRulerSelected || line != selectedLine) && (isRulerSelected || selectedOffset < position.offset || selectedOffset > position.offset + position.length) || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }
}

