/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public abstract class AbstractWorkflowComponent2
extends AbstractWorkflowComponent {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean skipOnErrors = false;

    public void setSkipOnErrors(boolean skip) {
        this.skipOnErrors = skip;
    }

    public final void checkConfiguration(Issues issues) {
        this.checkConfigurationInternal(issues);
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask("Running " + this.getComponentName() + "...", -1);
        }
        if (this.skipOnErrors && issues.hasErrors()) {
            this.log.info((Object)"execution skipped, since there are errors and skipOnErrors is set.");
            return;
        }
        this.invokeInternal(ctx, monitor, issues);
        if (monitor != null) {
            monitor.done();
        }
    }

    protected abstract void checkConfigurationInternal(Issues var1);
}

