/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowComponentWithID;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.container.CompositeComponent;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;

public abstract class AbstractWorkflowComponent
implements WorkflowComponentWithID {
    private static final Log log = LogFactory.getLog(AbstractWorkflowComponent.class);
    private String componentID;
    private boolean skipOnErrors = false;
    private CompositeComponent container;
    private Location location;

    public void checkRequiredConfigProperty(String configPropertyName, Object configPropertyValue, Issues issues) {
        boolean isError = false;
        if (configPropertyValue == null) {
            isError = true;
        } else if (configPropertyValue instanceof String && this.isBlank(configPropertyValue.toString())) {
            isError = true;
        }
        if (isError) {
            issues.addError("'" + configPropertyName + "' not specified.");
        }
    }

    public String getComponentName() {
        return this.getClass().getSimpleName();
    }

    public CompositeComponent getContainer() {
        return this.container;
    }

    public String getId() {
        return this.componentID;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getLogMessage() {
        return null;
    }

    public final void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (this.skipOnErrors && issues.hasErrors()) {
            log.info((Object)"execution skipped, since there are errors and skipOnErrors is set.");
            return;
        }
        this.invokeInternal(ctx, monitor, issues);
    }

    public void setContainer(CompositeComponent container) {
        this.container = container;
    }

    public void setId(String id) {
        this.componentID = id;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setSkipOnErrors(boolean skipOnErrors) {
        this.skipOnErrors = skipOnErrors;
    }

    protected abstract void invokeInternal(WorkflowContext var1, ProgressMonitor var2, Issues var3);

    private boolean isBlank(String string) {
        return string == null || string.trim().equals("");
    }
}

