/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.scoping;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe2.runtime.IFactory;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmReferenceTypeArgument;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeArgument;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.ITypeProvider;
import org.eclipse.xtext.common.types.access.TypeNotFoundException;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;

public class FactorySupport {
    @Inject
    private AbstractTypeScopeProvider typeScopeProvider;

    public void setTypeScopeProvider(AbstractTypeScopeProvider typeScopeProvider) {
        this.typeScopeProvider = typeScopeProvider;
    }

    public JvmType findFactoriesCreationType(JvmType containerType) {
        JvmType factoryType = this.getFactoryType((EObject)containerType);
        if (factoryType == null) {
            return null;
        }
        return this.findFactoriesCreationType(containerType, factoryType);
    }

    public JvmType findFactoriesCreationType(JvmType containerType, JvmType factoryType) {
        if (containerType instanceof JvmDeclaredType) {
            EList superTypes = ((JvmDeclaredType)containerType).getSuperTypes();
            for (JvmTypeReference ref : superTypes) {
                if (ref.getType().equals(factoryType)) {
                    JvmParameterizedTypeReference r = (JvmParameterizedTypeReference)ref;
                    JvmTypeArgument argument = (JvmTypeArgument)r.getArguments().get(0);
                    if (argument instanceof JvmReferenceTypeArgument) {
                        return ((JvmReferenceTypeArgument)argument).getTypeReference().getType();
                    }
                    return null;
                }
                JvmType result = this.findFactoriesCreationType(ref.getType(), factoryType);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public JvmType getFactoryType(EObject ctx) {
        ResourceSet resourceSet = ctx.eResource().getResourceSet();
        String factoryName = IFactory.class.getName();
        ITypeProvider typeProvider = this.typeScopeProvider.getTypeProvider(resourceSet);
        try {
            return typeProvider.findTypeByName(factoryName);
        }
        catch (TypeNotFoundException typeNotFoundException) {
            return null;
        }
    }
}

