/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.highlighting;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.services.Mwe2GrammarAccess;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private Mwe2GrammarAccess grammarAccess;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null) {
            return;
        }
        Iterable allNodes = NodeUtil.getAllContents((CompositeNode)resource.getParseResult().getRootNode());
        for (AbstractNode abstractNode : allNodes) {
            Component component;
            EObject grammarElement = abstractNode.getGrammarElement();
            if (grammarElement == this.grammarAccess.getPropertyReferenceAccess().getReferableDeclaredPropertyCrossReference_1_0()) {
                this.highlightNode(abstractNode, "property_ref", acceptor);
                this.highlightNode(abstractNode, "string_prop_ref", acceptor);
                for (AbstractNode sibling : abstractNode.getParent().getChildren()) {
                    if (sibling == abstractNode || sibling.getGrammarElement() != this.grammarAccess.getML_COMMENTRule() && sibling.getGrammarElement() != this.grammarAccess.getSL_COMMENTRule()) continue;
                    this.highlightNode(sibling, "comment", acceptor);
                }
                if (!(abstractNode instanceof CompositeNode)) continue;
                for (AbstractNode child : ((CompositeNode)abstractNode).getChildren()) {
                    if (child.getGrammarElement() != this.grammarAccess.getML_COMMENTRule() && child.getGrammarElement() != this.grammarAccess.getSL_COMMENTRule()) continue;
                    this.highlightNode(child, "comment", acceptor);
                }
                continue;
            }
            if (grammarElement == this.grammarAccess.getPropertyReferenceAccess().getDollarSignLeftCurlyBracketKeyword_0() || grammarElement == this.grammarAccess.getPropertyReferenceAccess().getRightCurlyBracketKeyword_2()) {
                this.highlightNode(abstractNode, "string_prop_ref", acceptor);
                continue;
            }
            if (grammarElement == this.grammarAccess.getReferenceAccess().getReferableReferrableCrossReference_0()) {
                this.highlightNode(abstractNode, "property_ref", acceptor);
                continue;
            }
            if (grammarElement == this.grammarAccess.getAssignmentAccess().getFeatureJvmFeatureCrossReference_0_0()) {
                JvmOperation operation;
                this.highlightNode(abstractNode, "feature_ref", acceptor);
                Assignment semanticObject = (Assignment)NodeUtil.getNearestSemanticObject((AbstractNode)abstractNode);
                if (!(semanticObject.getFeature() instanceof JvmOperation) || !this.isDeprecated((JvmAnnotationTarget)(operation = (JvmOperation)semanticObject.getFeature()))) continue;
                this.highlightNode(abstractNode, "deprecated_element", acceptor);
                continue;
            }
            if (grammarElement != this.grammarAccess.getComponentAccess().getTypeJvmTypeCrossReference_1_0_0() && grammarElement != this.grammarAccess.getRootComponentAccess().getTypeJvmTypeCrossReference_1_0_0() || !((component = (Component)NodeUtil.getNearestSemanticObject((AbstractNode)abstractNode)).getType() instanceof JvmAnnotationTarget) || !this.isDeprecated((JvmAnnotationTarget)component.getType())) continue;
            this.highlightNode(abstractNode, "deprecated_element", acceptor);
        }
    }

    public boolean isDeprecated(JvmAnnotationTarget annotatable) {
        if (annotatable == null) {
            return false;
        }
        EList annotations = annotatable.getAnnotations();
        for (JvmAnnotationReference annotation : annotations) {
            if (!Deprecated.class.getName().equals(annotation.getAnnotation().getCanonicalName())) continue;
            return true;
        }
        if (annotatable instanceof JvmMember) {
            return this.isDeprecated((JvmAnnotationTarget)((JvmMember)annotatable).getDeclaringType());
        }
        return false;
    }

    private void highlightNode(AbstractNode node, String id, IHighlightedPositionAcceptor acceptor) {
        if (node == null) {
            return;
        }
        if (node instanceof LeafNode) {
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{id});
        } else {
            for (LeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                acceptor.addPosition(leaf.getOffset(), leaf.getLength(), new String[]{id});
            }
        }
    }
}

