/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.outline;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.BooleanLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Import;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Reference;
import org.eclipse.emf.mwe2.language.mwe2.StringLiteral;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.transformer.AbstractDeclarativeSemanticModelTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mwe2Transformer
extends AbstractDeclarativeSemanticModelTransformer {
    @Inject
    private IImageHelper imageHelper;
    @Inject
    private ILabelProvider labelProvider;

    public ContentOutlineNode createNode(Module module, ContentOutlineNode outlineParentNode) {
        if (module.getCanonicalName() == null) {
            return null;
        }
        ContentOutlineNode result = super.createNode((EObject)module, outlineParentNode);
        if (!module.getImports().isEmpty()) {
            ContentOutlineNode imports = new ContentOutlineNode("import declarations");
            imports.setImage(this.imageHelper.getImage("impc_obj.gif"));
            result.getChildren().add(imports);
            for (Import imp : module.getImports()) {
                this.transformSemanticNode((EObject)imp, imports);
            }
        }
        if (!module.getDeclaredProperties().isEmpty()) {
            ContentOutlineNode properties = new ContentOutlineNode("property declarations");
            properties.setImage(this.imageHelper.getImage("settings_obj.gif"));
            result.getChildren().add(properties);
            for (DeclaredProperty prop : module.getDeclaredProperties()) {
                this.transformSemanticNode((EObject)prop, properties);
            }
        }
        return result;
    }

    public ContentOutlineNode createNode(Assignment ass, ContentOutlineNode outlineParentNode) {
        ContentOutlineNode result = super.createNode((EObject)ass, outlineParentNode);
        if (ass.getValue() != null) {
            result.setImage(this.labelProvider.getImage((Object)ass.getValue()));
        }
        return result;
    }

    public ContentOutlineNode createNode(DeclaredProperty prop, ContentOutlineNode outlineParentNode) {
        ContentOutlineNode result = super.createNode((EObject)prop, outlineParentNode);
        if (prop.getDefault() != null) {
            result.setImage(this.labelProvider.getImage((Object)prop.getDefault()));
        }
        return result;
    }

    public List<EObject> getChildren(Module module) {
        if (module.getRoot() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(module.getRoot());
    }

    public boolean consumeNode(Reference reference) {
        return false;
    }

    public List<EObject> getChildren(Reference reference) {
        return NO_CHILDREN;
    }

    public boolean consumeNode(StringLiteral literal) {
        return false;
    }

    public List<EObject> getChildren(StringLiteral literal) {
        return NO_CHILDREN;
    }

    public boolean consumeNode(BooleanLiteral literal) {
        return false;
    }

    public List<EObject> getChildren(BooleanLiteral literal) {
        return NO_CHILDREN;
    }

    public boolean consumeNode(Component comp) {
        return comp.eContainer() instanceof Module;
    }

    public List<EObject> getChildren(DeclaredProperty object) {
        if (object.getDefault() instanceof Component) {
            return Collections.singletonList(object.getDefault());
        }
        return NO_CHILDREN;
    }

    public List<EObject> getChildren(Assignment object) {
        if (object.getValue() instanceof Component) {
            return Collections.singletonList(object.getValue());
        }
        return NO_CHILDREN;
    }
}

