/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.contentassist;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.scoping.NamespaceAwareScopeProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.xtext.ui.JdtTypesProposalProvider;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public class NamespaceAwareTypesProposalProvider
extends JdtTypesProposalProvider {
    @Inject
    private NamespaceAwareScopeProvider nameSpaceAwareScopeProvider;

    protected void createTypeProposal(final String typeName, int flags, boolean isInnerType, ICompletionProposalFactory proposalFactory, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (acceptor.canAcceptMoreProposals() && !"java.lang.Object".equals(typeName)) {
            int lastDot = typeName.lastIndexOf(46);
            String displayString = typeName;
            if (lastDot != -1) {
                displayString = String.valueOf(typeName.substring(lastDot + 1)) + " - " + typeName.substring(0, lastDot);
            }
            Image img = this.computeImage(typeName, isInnerType, flags);
            final PrefixMatcher originalMatcher = context.getMatcher();
            PrefixMatcher adaptingMatcher = new PrefixMatcher(){

                public boolean isCandidateMatchingPrefix(String name, String prefix) {
                    return originalMatcher.isCandidateMatchingPrefix(typeName, prefix);
                }
            };
            try {
                context.setMatcher(adaptingMatcher);
                ICompletionProposal proposal = proposalFactory.createCompletionProposal(this.toShortName(context.getCurrentModel(), typeName), displayString, img, context);
                acceptor.accept(proposal);
            }
            finally {
                context.setMatcher(originalMatcher);
            }
        }
    }

    public String toShortName(EObject context, String typeName) {
        Set importNormalizer = this.nameSpaceAwareScopeProvider.getImportNormalizer(EcoreUtil2.getContainerOfType((EObject)context, Module.class));
        String result = typeName;
        for (ImportedNamespaceAwareLocalScopeProvider.ImportNormalizer normalizer : importNormalizer) {
            String candidate = normalizer.longToShortName(typeName);
            if (candidate == null || candidate.length() >= result.length()) continue;
            result = candidate;
        }
        return result;
    }
}

