/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.resource;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe2.language.mwe2.BooleanLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.emf.mwe2.language.mwe2.Reference;
import org.eclipse.emf.mwe2.language.mwe2.StringLiteral;
import org.eclipse.emf.mwe2.language.mwe2.Value;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MweResourceDescription
extends DefaultResourceDescription {
    private static final Logger log = Logger.getLogger(MweResourceDescription.class);
    public static final String DECLARED_PROPERTY__MANDATORY = "mandatory";
    public static final String MANDATORY_TRUE = "true";
    public static final String DECLARED_PROPERTY__TYPE = "type";
    public static final String TYPE__BOOLEAN = "boolean";
    public static final String TYPE__STRING = "String";

    public MweResourceDescription(Resource resource, IQualifiedNameProvider nameProvider) {
        super(resource, nameProvider);
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        this.loadResourceIfNecessary();
        if (this.getResource().getContents().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        Module module = (Module)this.getResource().getContents().get(0);
        IEObjectDescription moduleDescription = this.createIEObjectDescription(module);
        if (moduleDescription != null) {
            result.add(moduleDescription);
        }
        for (DeclaredProperty property : module.getDeclaredProperties()) {
            IEObjectDescription description = this.createIEObjectDescription(property);
            if (description == null) continue;
            result.add(description);
        }
        return result;
    }

    protected void loadResourceIfNecessary() {
        if (!this.getResource().isLoaded()) {
            try {
                this.getResource().load(null);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected IEObjectDescription createIEObjectDescription(DeclaredProperty property) {
        String qualifiedName = this.getNameProvider().getQualifiedName((EObject)property);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String nodeModelValue = this.getValueFromNodeModel(property, Mwe2Package.Literals.REFERRABLE__TYPE);
        if (nodeModelValue != null) {
            builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)nodeModelValue);
            if (property.getDefault() == null) {
                builder.put((Object)DECLARED_PROPERTY__MANDATORY, (Object)MANDATORY_TRUE);
            }
        } else {
            Value value = property.getDefault();
            if (value == null) {
                builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)TYPE__STRING);
                builder.put((Object)DECLARED_PROPERTY__MANDATORY, (Object)MANDATORY_TRUE);
            } else if (value instanceof BooleanLiteral) {
                builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)TYPE__BOOLEAN);
            } else if (value instanceof StringLiteral) {
                builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)TYPE__STRING);
            } else if (value instanceof Component) {
                nodeModelValue = this.getValueFromNodeModel(value, Mwe2Package.Literals.COMPONENT__MODULE);
                if (nodeModelValue != null) {
                    builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)nodeModelValue);
                } else {
                    nodeModelValue = this.getValueFromNodeModel(value, Mwe2Package.Literals.REFERRABLE__TYPE);
                    if (nodeModelValue != null) {
                        builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)nodeModelValue);
                    }
                }
            } else if (value instanceof Reference && (nodeModelValue = this.getValueFromNodeModel(value, Mwe2Package.Literals.ABSTRACT_REFERENCE__REFERABLE)) != null) {
                builder.put((Object)DECLARED_PROPERTY__TYPE, (Object)nodeModelValue);
            }
        }
        ImmutableMap userData = builder.build();
        return EObjectDescription.create((String)qualifiedName, (EObject)property, (Map)userData);
    }

    protected String getValueFromNodeModel(EObject object, EReference feature) {
        List typeNodes = NodeUtil.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (typeNodes.isEmpty()) {
            return null;
        }
        if (typeNodes.size() != 1) {
            throw new IllegalStateException("Unexpected multiple values for feature '" + feature + "' in object '" + object + "'.");
        }
        EList leafNodes = ((AbstractNode)typeNodes.get(0)).getLeafNodes();
        StringBuilder result = new StringBuilder();
        for (LeafNode leafNode : leafNodes) {
            if (leafNode.isHidden()) continue;
            result.append(leafNode.getText());
        }
        return result.toString();
    }
}

