/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mwe2.language.mwe2.AbstractReference;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.emf.mwe2.language.mwe2.Referrable;
import org.eclipse.emf.mwe2.language.scoping.FactorySupport;
import org.eclipse.emf.mwe2.language.scoping.Mwe2ScopeProvider;
import org.eclipse.emf.mwe2.language.validation.AbstractMwe2JavaValidator;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.IAssignabilityComputer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mwe2JavaValidator
extends AbstractMwe2JavaValidator {
    @Inject
    private IAssignabilityComputer assignabilityComputer;
    @Inject
    private FactorySupport factorySupport;
    @Inject
    private Mwe2ScopeProvider scopeProvider;
    public static final String INCOMPATIBLE_ASSIGNMENT = "incompatible_assignment";
    public static final String UNUSED_LOCAL = "unused_local_variable";
    public static final String DUPLICATE_LOCAL = "duplicate_local_variable";
    public static final String MISSING_DEFAULT_CONSTRUCTOR = "missing_default_constructor";
    public static final String ABSTRACT_OR_INTERFACE = "abstract_or_interface";
    public static final String MISSING_MANDATORY_FEATURE = "missing_mandatory_feature";

    @Check
    public void checkCompatibility(Assignment assignment) {
        JvmFeature feature = assignment.getFeature();
        if (feature.eIsProxy()) {
            return;
        }
        JvmTypeReference left = null;
        if (feature instanceof JvmOperation) {
            JvmOperation op = (JvmOperation)feature;
            left = ((JvmFormalParameter)op.getParameters().get(0)).getParameterType();
        } else if (feature instanceof DeclaredProperty) {
            DeclaredProperty property = (DeclaredProperty)feature;
            JvmType propertyType = property.getActualType();
            JvmParameterizedTypeReference propertyTypeRef = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            propertyTypeRef.setType(propertyType);
            left = propertyTypeRef;
        } else {
            throw new UnsupportedOperationException("Can not handle features of type " + feature.getClass().getName() + " - " + feature);
        }
        if (left != null) {
            if (assignment.getValue() == null || assignment.getValue().eIsProxy()) {
                return;
            }
            JvmParameterizedTypeReference right = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            JvmType actualType = assignment.getValue().getActualType();
            if (actualType == null || actualType.eIsProxy()) {
                return;
            }
            JvmType factoryType = this.factorySupport.findFactoriesCreationType(actualType);
            if (factoryType != null) {
                right.setType(factoryType);
            } else {
                right.setType(actualType);
            }
            if (!this.assignabilityComputer.isAssignableFrom(left, (JvmTypeReference)right)) {
                this.error("A value of type '" + actualType.getCanonicalName() + "' can not be assigned to the feature " + feature.getSimpleName(), 1, INCOMPATIBLE_ASSIGNMENT, new String[0]);
            }
        }
    }

    @Check
    public void checkCompatibility(DeclaredProperty property) {
        if (property.getType() != null && property.getDefault() != null) {
            JvmParameterizedTypeReference left = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            left.setType(property.getType());
            JvmParameterizedTypeReference right = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            JvmType actualType = property.getDefault().getActualType();
            JvmType factoryType = this.factorySupport.findFactoriesCreationType(actualType);
            if (factoryType != null) {
                right.setType(factoryType);
            } else {
                right.setType(actualType);
            }
            if (!this.assignabilityComputer.isAssignableFrom((JvmTypeReference)left, (JvmTypeReference)right)) {
                this.error("A value of type '" + actualType.getCanonicalName() + "' can not be assigned to a reference of type " + property.getType().getCanonicalName(), 2, INCOMPATIBLE_ASSIGNMENT, new String[0]);
            }
        }
    }

    @Check
    public void checkReferables(Module referable) {
        TreeIterator iterator = referable.eResource().getAllContents();
        HashSet referenced = Sets.newHashSet();
        HashMultimap declared = Multimaps.newHashMultimap();
        while (iterator.hasNext()) {
            Component component;
            EObject next = (EObject)iterator.next();
            if (next instanceof Referrable) {
                String name = ((Referrable)next).getName();
                if (name != null) {
                    declared.put((Object)name, (Object)((Referrable)next));
                }
            } else if (next instanceof AbstractReference) {
                referenced.add(((AbstractReference)next).getReferable().getName());
            }
            if (!(next instanceof Component) || !(component = (Component)next).isAutoInject()) continue;
            Set<String> featureNames = this.collectFeatureNames(component);
            HashSet explicitlyAssignedFeature = Sets.newHashSet();
            for (Assignment assignment : component.getAssignment()) {
                explicitlyAssignedFeature.add(assignment.getFeatureName());
            }
            featureNames.removeAll(explicitlyAssignedFeature);
            featureNames.retainAll(declared.keySet());
            referenced.addAll(featureNames);
        }
        HashMultimap copy = Multimaps.newHashMultimap((Multimap)declared);
        copy.keySet().removeAll(referenced);
        for (Referrable referrable : copy.values()) {
            this.warning("The var '" + referrable.getName() + "' is never read locally.", referrable, 1, UNUSED_LOCAL, new String[0]);
        }
        for (String name : declared.keySet()) {
            Collection collection = declared.get((Object)name);
            if (collection.size() <= 1) continue;
            for (Referrable referrable : collection) {
                this.error("Duplicate var '" + referrable.getName() + "'.", referrable, 1, DUPLICATE_LOCAL, new String[0]);
            }
        }
    }

    public Set<String> collectFeatureNames(Component component) {
        HashSet result = Sets.newHashSet();
        IScope scope = this.scopeProvider.createComponentFeaturesScope(component);
        for (IEObjectDescription description : scope.getAllContents()) {
            result.add(description.getName());
        }
        return result;
    }

    @Check
    public void checkInstantiable(Component component) {
        if (component.getModule() != null) {
            return;
        }
        JvmType actualType = component.getActualType();
        if (actualType == null || actualType.eIsProxy()) {
            return;
        }
        JvmDeclaredType declaredType = (JvmDeclaredType)actualType;
        if (!(declaredType.isAbstract() || declaredType instanceof JvmGenericType && ((JvmGenericType)declaredType).isInterface())) {
            for (JvmMember member : declaredType.getMembers()) {
                if (!(member instanceof JvmConstructor) || !((JvmConstructor)member).getParameters().isEmpty() || !member.getVisibility().equals((Object)JvmVisibility.PUBLIC)) continue;
                return;
            }
            this.error("'" + declaredType.getCanonicalName() + "' does not have a public default constructor.", component, 0, MISSING_DEFAULT_CONSTRUCTOR, new String[0]);
        }
    }

    @Check
    public void checkComponentTypeIsInterfaceOrAbstract(Component component) {
        if (component.getModule() != null) {
            return;
        }
        JvmType actualType = component.getActualType();
        if (actualType == null || actualType.eIsProxy()) {
            return;
        }
        JvmDeclaredType declaredType = (JvmDeclaredType)actualType;
        if (declaredType.isAbstract() || declaredType instanceof JvmGenericType && ((JvmGenericType)declaredType).isInterface()) {
            this.error("'" + declaredType.getCanonicalName() + "' is not instantiable.", component, 0, ABSTRACT_OR_INTERFACE, new String[0]);
        }
    }

    @Check
    public void checkManadatoryFeaturesAssigned(Component component) {
        Map<String, JvmFeature> mandatoryFeatures = this.collectMandatoryFeatures(component);
        if (!mandatoryFeatures.isEmpty()) {
            Map<String, Referrable> availableProperties = this.collectReferablesUpTo(component);
            Set<String> assignedFeatures = this.getAssignedFeatures(availableProperties, component);
            mandatoryFeatures.keySet().removeAll(assignedFeatures);
            if (!mandatoryFeatures.isEmpty()) {
                Integer featureId;
                ArrayList missingAssignments = Lists.newArrayList(mandatoryFeatures.keySet());
                Collections.sort(missingAssignments);
                String concatenated = Strings.concat((String)", ", (List)missingAssignments);
                EReference feature = null;
                if (component.getType() != null) {
                    feature = Mwe2Package.Literals.REFERRABLE__TYPE;
                } else if (component.getModule() != null) {
                    feature = Mwe2Package.Literals.COMPONENT__MODULE;
                } else if (component.getName() != null) {
                    feature = Mwe2Package.Literals.REFERRABLE__NAME;
                }
                Integer n = featureId = feature == null ? null : Integer.valueOf(component.eClass().getFeatureID((EStructuralFeature)feature));
                if (missingAssignments.size() == 1) {
                    this.error("Mandatory feature was not assigned: '" + concatenated + "'.", component, featureId, MISSING_MANDATORY_FEATURE, new String[0]);
                } else {
                    this.error("Mandatory features were not assigned: '" + concatenated + "'.", component, featureId, MISSING_MANDATORY_FEATURE, new String[0]);
                }
            }
        }
    }

    private Set<String> getAssignedFeatures(Map<String, Referrable> availableProperties, Component component) {
        HashSet result = Sets.newHashSet();
        if (component.isAutoInject()) {
            result.addAll(availableProperties.keySet());
        }
        for (Assignment assignment : component.getAssignment()) {
            if (assignment.getFeature() == null || assignment.getFeature().eIsProxy()) continue;
            JvmFeature feature = assignment.getFeature();
            if (feature instanceof JvmOperation) {
                result.add(Strings.toFirstLower((String)feature.getSimpleName().substring(3)));
                continue;
            }
            result.add(feature.getSimpleName());
        }
        return result;
    }

    public Map<String, Referrable> collectReferablesUpTo(Component component) {
        ArrayList result = Lists.newArrayList();
        this.scopeProvider.collectReferablesUpTo((EObject)component, true, (List<Referrable>)result);
        HashMap indexed = Maps.newHashMap();
        for (Referrable referrable : result) {
            if (referrable.getName() == null) continue;
            indexed.put(referrable.getName(), referrable);
        }
        return indexed;
    }

    public Map<String, JvmFeature> collectMandatoryFeatures(Component component) {
        HashMap result = Maps.newHashMap();
        IScope scope = this.scopeProvider.createComponentFeaturesScope(component);
        for (IEObjectDescription description : scope.getAllContents()) {
            JvmFeature jvmFeature = (JvmFeature)description.getEObjectOrProxy();
            if (!this.isMandatory(jvmFeature)) continue;
            result.put(description.getName(), jvmFeature);
        }
        return result;
    }

    public boolean isMandatory(JvmFeature feature) {
        if (feature.eIsProxy()) {
            return false;
        }
        if (feature instanceof DeclaredProperty) {
            return ((DeclaredProperty)feature).getDefault() == null;
        }
        JvmOperation operation = (JvmOperation)feature;
        for (JvmAnnotationReference annotation : operation.getAnnotations()) {
            if (!Mandatory.class.getName().equals(annotation.getAnnotation().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<EPackage> getEPackages() {
        List<EPackage> ePackages = super.getEPackages();
        ePackages.add(Mwe2Package.eINSTANCE);
        return ePackages;
    }
}

