/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotations.model.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExistenceType implements Enumerator
{
    CHECKCACHE(0, "CHECKCACHE", "CHECK_CACHE"),
    CHECKDATABASE(1, "CHECKDATABASE", "CHECK_DATABASE"),
    ASSUMEEXISTENCE(2, "ASSUMEEXISTENCE", "ASSUME_EXISTENCE"),
    ASSUMENONEXISTENCE(3, "ASSUMENONEXISTENCE", "ASSUME_NON_EXISTENCE");

    public static final int CHECKCACHE_VALUE = 0;
    public static final int CHECKDATABASE_VALUE = 1;
    public static final int ASSUMEEXISTENCE_VALUE = 2;
    public static final int ASSUMENONEXISTENCE_VALUE = 3;
    private static final ExistenceType[] VALUES_ARRAY;
    public static final List<ExistenceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExistenceType[]{CHECKCACHE, CHECKDATABASE, ASSUMEEXISTENCE, ASSUMENONEXISTENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExistenceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExistenceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExistenceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExistenceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExistenceType get(int value) {
        switch (value) {
            case 0: {
                return CHECKCACHE;
            }
            case 1: {
                return CHECKDATABASE;
            }
            case 2: {
                return ASSUMEEXISTENCE;
            }
            case 3: {
                return ASSUMENONEXISTENCE;
            }
        }
        return null;
    }

    private ExistenceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

