/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.orm.annotations.model.orm.EnumType;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmPackage;
import org.eclipse.emf.texo.orm.annotator.BaseOrmAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORMJavaAnnotationGenerator {
    public static final String PACKAGE_PREFIX_SOURCE = "texo.package.prefix";
    private static ORMJavaAnnotationGenerator instance = new ORMJavaAnnotationGenerator();
    private List<EClassifier> eclipseLinkEClassifiers = new ArrayList<EClassifier>();
    private List<String> classFeatureNames = new ArrayList<String>();
    private Map<Class<?>, String> enumTypeNames = new HashMap();
    private Map<EStructuralFeature, String> eFeatureAnnotationMapping = new HashMap<EStructuralFeature, String>();

    public static ORMJavaAnnotationGenerator getInstance() {
        return instance;
    }

    public static void setInstance(ORMJavaAnnotationGenerator instance) {
        ORMJavaAnnotationGenerator.instance = instance;
    }

    public ORMJavaAnnotationGenerator() {
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getAccessMethods());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getBasicCollection());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getBasicMap());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCache());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCacheCoordinationType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCacheInterceptor());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCacheType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getChangeTracking());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getChangeTrackingType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCloneCopyPolicy());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getConversionValue());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getConverter());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCopyPolicy());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getCustomizer());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getDirectionType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getDiscriminatorClass());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getEclipselinkCollectionTable());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getExistenceType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getIdValidation());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getInstantiationCopyPolicy());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getJoinFetchType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getNamedStoredProcedureQuery());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getPrimaryKey());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getProperty());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getObjectTypeConverter());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getOptimisticLocking());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getOptimisticLockingType());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getQueryRedirectors());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getReadTransformer());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getStoredProcedureParameter());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getStructConverter());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getTimeOfDay());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getTransformation());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getTypeConverter());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getVariableOneToOne());
        this.eclipseLinkEClassifiers.add((EClassifier)OrmPackage.eINSTANCE.getWriteTransformer());
        this.classFeatureNames.add("entityClass");
        this.classFeatureNames.add("targetEntity");
        this.classFeatureNames.add("targetClass");
        this.classFeatureNames.add("class");
        this.enumTypeNames.put(EnumType.class, "EnumType");
        this.eFeatureAnnotationMapping.put((EStructuralFeature)OrmPackage.eINSTANCE.getElementCollection_Convert(), "org.eclipse.persistence.annotations.Convert");
        this.eFeatureAnnotationMapping.put((EStructuralFeature)OrmPackage.eINSTANCE.getBasic_Convert(), "org.eclipse.persistence.annotations.Convert");
    }

    public String generateJavaAnnotation(EObject annotation, List<EStructuralFeature> includeFeatures, boolean referencesEnumsAsSeparateAnnotation, String identifier) {
        StringBuilder separateAnnotation = new StringBuilder();
        List<Object> localIncludedFeatures = includeFeatures;
        if (localIncludedFeatures == null) {
            localIncludedFeatures = Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@" + this.getJavaPackage((EClassifier)annotation.eClass()) + "." + annotation.eClass().getName());
        sb.append("(");
        boolean addComma = false;
        for (EStructuralFeature eFeature : annotation.eClass().getEStructuralFeatures()) {
            Collection values;
            Object value = annotation.eGet(eFeature);
            if (!annotation.eIsSet(eFeature) || eFeature.getName().equals("description") || value == null || value instanceof Collection && ((Collection)value).isEmpty() || eFeature.getEContainingClass() != OrmPackage.eINSTANCE.getConverter() && eFeature.getName().equals("class")) continue;
            if (this.eFeatureAnnotationMapping.containsKey(eFeature)) {
                if (value instanceof String) {
                    separateAnnotation.append("@" + this.eFeatureAnnotationMapping.get(eFeature) + "(\"" + value + "\")");
                    continue;
                }
                separateAnnotation.append("@" + this.eFeatureAnnotationMapping.get(eFeature) + "(" + value + ")");
                continue;
            }
            if ((localIncludedFeatures.size() == 0 || !localIncludedFeatures.contains(eFeature)) && eFeature instanceof EAttribute && value instanceof Enumerator && referencesEnumsAsSeparateAnnotation) {
                if (separateAnnotation.length() > 0) {
                    separateAnnotation.append("\n");
                }
                Enumerator enumerator = (Enumerator)value;
                separateAnnotation.append(this.generateJavaAnnotation(eFeature, enumerator));
                continue;
            }
            if ((localIncludedFeatures.size() == 0 || !localIncludedFeatures.contains(eFeature)) && eFeature instanceof EReference && referencesEnumsAsSeparateAnnotation) {
                if (separateAnnotation.length() > 0) {
                    separateAnnotation.append("\n");
                }
                if (((EReference)eFeature).isMany()) {
                    values = (Collection)value;
                    if (values.isEmpty()) continue;
                    separateAnnotation.append("@" + this.getJavaPackage(eFeature.getEType()) + "." + this.pluralize(this.upperCaseFirst(eFeature.getName())) + "({");
                    boolean addArrayComma = false;
                    for (Object val : values) {
                        if (!(val instanceof BaseOrmAnnotation)) continue;
                        if (addArrayComma) {
                            separateAnnotation.append(", ");
                        }
                        addArrayComma = true;
                        separateAnnotation.append(((BaseOrmAnnotation)val).getJavaAnnotation(identifier));
                    }
                    separateAnnotation.append("})");
                    continue;
                }
                separateAnnotation.append(((BaseOrmAnnotation)value).getJavaAnnotation(identifier));
                continue;
            }
            if (localIncludedFeatures.size() > 0 && !localIncludedFeatures.contains(eFeature)) continue;
            if (addComma) {
                sb.append(", ");
            }
            addComma = true;
            if (value instanceof Collection) {
                if (eFeature.getName().endsWith("s")) {
                    sb.append(String.valueOf(eFeature.getName()) + "=");
                } else {
                    sb.append(String.valueOf(eFeature.getName()) + "s=");
                }
                values = (Collection)value;
                sb.append("{");
                boolean doAddComma = false;
                for (Object val : values) {
                    if (doAddComma) {
                        sb.append(", ");
                    }
                    sb.append(this.generateJavaAnnotation(eFeature, val, identifier));
                    doAddComma = true;
                }
                sb.append("}");
                continue;
            }
            if (eFeature == OrmPackage.eINSTANCE.getConverter_Class()) {
                sb.append("converterClass=");
            } else {
                sb.append(String.valueOf(eFeature.getName()) + "=");
            }
            sb.append(this.generateJavaAnnotation(eFeature, value, identifier));
        }
        sb.append(")");
        if (separateAnnotation.length() > 0) {
            sb.append("\n" + separateAnnotation);
        }
        return sb.toString();
    }

    private String pluralize(String value) {
        if (value == null) {
            return null;
        }
        if (value.endsWith("y")) {
            return String.valueOf(value.substring(0, value.length() - 1)) + "ies";
        }
        return String.valueOf(value) + "s";
    }

    private String upperCaseFirst(String value) {
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1);
    }

    public String generateJavaAnnotation(EStructuralFeature eFeature, Object value, String identifier) {
        if (value instanceof String) {
            if (this.classFeatureNames.contains(eFeature.getName())) {
                return value + ".class";
            }
            return "\"" + value + "\"";
        }
        if (eFeature instanceof EReference) {
            if (value instanceof BaseOrmAnnotation) {
                return ((BaseOrmAnnotation)value).getJavaAnnotation(identifier);
            }
            return "";
        }
        if (eFeature.getEType() instanceof EEnum) {
            Enumerator enumerator = (Enumerator)value;
            return String.valueOf(this.getJavaPackage(eFeature.getEType())) + "." + eFeature.getEType().getName() + "." + enumerator.getLiteral();
        }
        return "" + value;
    }

    private String generateJavaAnnotation(EStructuralFeature eFeature, Enumerator enumerator) {
        String valueType = enumerator.getClass().getSimpleName();
        if (this.enumTypeNames.containsKey(enumerator.getClass())) {
            valueType = this.enumTypeNames.get(enumerator.getClass());
        } else if (!valueType.endsWith("Type")) {
            valueType = String.valueOf(valueType) + "Type";
        }
        return "@" + this.getJavaPackage(eFeature.getEType()) + "." + this.upperCaseFirst(eFeature.getName()) + "(" + this.getJavaPackage(eFeature.getEType()) + "." + valueType + "." + enumerator.getLiteral() + ")";
    }

    private String getJavaPackage(EClassifier eClassifier) {
        for (EClassifier chkEClassifier : this.eclipseLinkEClassifiers) {
            if (chkEClassifier != eClassifier) continue;
            return "org.eclipse.persistence.annotations";
        }
        return "javax.persistence";
    }
}

