/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.texo.generator.GeneratorUtils;
import org.eclipse.emf.texo.orm.ormannotations.EPackageORMAnnotation;

public class ORMNamingStrategy {
    private static char[] removables = new char[]{'u', 'o', 'a', 'e', 'i', 'U', 'O', 'A', 'E', 'I'};
    private EPackageORMAnnotation ePackageORMAnnotation = null;
    private Properties nameDictionary = null;
    private Set<String> sqlReservedWords = null;

    protected String renameReservedWord(String name) {
        if (this.sqlReservedWords == null) {
            try {
                this.sqlReservedWords = new HashSet<String>();
                InputStream is = ORMNamingStrategy.class.getResourceAsStream("reserved-sql-words.txt");
                Properties props = new Properties();
                props.load(is);
                is.close();
                for (Object key : props.keySet()) {
                    this.sqlReservedWords.add((String)key);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.sqlReservedWords.contains(name.toUpperCase())) {
            return String.valueOf(this.getRenamePrefix()) + name;
        }
        return name;
    }

    protected String getRenamePrefix() {
        return "T_";
    }

    public boolean isGenerateAllDBSchemaNames() {
        return this.getePackageORMAnnotation().isGenerateFullDbSchemaNames();
    }

    public String getEntityName(EClass eClass) {
        return this.makeSafe(String.valueOf(this.getUniqueMakingPrefix(eClass)) + eClass.getName());
    }

    public String getPrimaryKeyJoinColumn(EClass eClass) {
        String localName = this.getDictionariedName((ENamedElement)eClass, "parent");
        if (localName == null) {
            localName = String.valueOf(this.getEntityName(eClass)) + "_parent_id";
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    public String getTableName(EClass eClass) {
        String localName = this.getDictionariedName((ENamedElement)eClass, null);
        if (localName == null) {
            localName = this.getEntityName(eClass);
        }
        return this.processName(localName, this.ePackageORMAnnotation.getTableNamePrefix());
    }

    public String getCollectionElementColumnName(EStructuralFeature eFeature) {
        String localName = this.getDictionariedName((ENamedElement)eFeature, "element");
        if (localName == null) {
            localName = "element";
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    public String getIndexColumnName(EStructuralFeature eFeature) {
        String localName = this.getDictionariedName((ENamedElement)eFeature, "index");
        if (localName == null) {
            localName = this.ePackageORMAnnotation.isEnforceUniqueNames() ? String.valueOf(this.getEntityName(eFeature.getEContainingClass())) + "_" + eFeature.getName() + "_ind" : String.valueOf(eFeature.getName()) + "_ind";
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    public String getJoinTableName(EStructuralFeature eFeature) {
        String localName = this.getDictionariedName((ENamedElement)eFeature, "joinTable");
        if (localName == null) {
            localName = String.valueOf(this.getEntityName(eFeature.getEContainingClass())) + "_" + eFeature.getName();
        }
        return this.processName(localName, this.ePackageORMAnnotation.getTableNamePrefix());
    }

    public String getForeignKeyColumnName(EStructuralFeature eFeature) {
        String localName = this.getDictionariedName((ENamedElement)eFeature, "foreignKeyColumn");
        if (localName == null) {
            localName = this.ePackageORMAnnotation.isEnforceUniqueNames() ? String.valueOf(this.getEntityName(eFeature.getEContainingClass())) + "_" + eFeature.getName() : eFeature.getName();
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    public String getJoinColumnName(EStructuralFeature eFeature) {
        String localName = this.getDictionariedName((ENamedElement)eFeature, "joinColumn");
        if (localName == null) {
            localName = this.ePackageORMAnnotation.isEnforceUniqueNames() || eFeature instanceof EReference && eFeature.getEType() == eFeature.getEContainingClass() ? String.valueOf(this.getEntityName(eFeature.getEContainingClass())) + "_" + eFeature.getName() : String.valueOf(this.getEntityName(eFeature.getEContainingClass())) + "_id";
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    public String getInverseJoinColumnName(EReference eReference) {
        String localName = this.getDictionariedName((ENamedElement)eReference, "inverseJoinColumn");
        if (localName == null) {
            if (this.ePackageORMAnnotation.isEnforceUniqueNames() || eReference.getEReferenceType() == eReference.getEContainingClass()) {
                localName = String.valueOf(eReference.getName()) + "_" + this.getEntityName(eReference.getEReferenceType());
            } else {
                if (eReference.getEOpposite() != null) {
                    return this.getJoinColumnName((EStructuralFeature)eReference.getEOpposite());
                }
                localName = String.valueOf(this.getEntityName(eReference.getEReferenceType())) + "_id";
            }
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    public String getFeatureMapEntityName(EAttribute eAttribute) {
        return String.valueOf(this.getUniqueMakingPrefix(eAttribute.getEContainingClass())) + eAttribute.getEContainingClass().getName() + "_" + eAttribute.getName();
    }

    public String getColumnName(EStructuralFeature eFeature) {
        String localName = this.getDictionariedName((ENamedElement)eFeature, null);
        if (localName == null) {
            localName = eFeature.getName();
        }
        return this.processName(localName, this.ePackageORMAnnotation.getColumnNamePrefix());
    }

    private String getUniqueMakingPrefix(EClass eClass) {
        if (this.ePackageORMAnnotation.isUniqueEntityNames()) {
            return String.valueOf(eClass.getEPackage().getNsPrefix()) + "_";
        }
        return "";
    }

    protected String makeSafe(String toBeMadeSafe) {
        char[] chrs = toBeMadeSafe.toCharArray();
        char[] targetChrs = new char[chrs.length];
        int i = 0;
        char[] cArray = chrs;
        int n = chrs.length;
        int n2 = 0;
        while (n2 < n) {
            int chr = cArray[n2];
            targetChrs[i++] = i > 0 && 48 <= chr && chr <= 57 ? chr : (97 <= chr && chr <= 122 ? chr : (65 <= chr && chr <= 90 ? chr : (chr == 95 ? chr : 95)));
            ++n2;
        }
        return new String(targetChrs);
    }

    public EPackageORMAnnotation getePackageORMAnnotation() {
        return this.ePackageORMAnnotation;
    }

    public void setePackageORMAnnotation(EPackageORMAnnotation ePackageORMAnnotation) {
        this.ePackageORMAnnotation = ePackageORMAnnotation;
    }

    private String getSafePrefixStr(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getDictionariedName(ENamedElement eNamedElement, String qualifier) {
        String dictionaryName = this.getNameDictionary().getProperty(this.getPropertyName(eNamedElement, qualifier));
        if (GeneratorUtils.isNotEmptyAndNotNull((String)dictionaryName)) {
            return dictionaryName;
        }
        return null;
    }

    private Properties getNameDictionary() {
        if (this.nameDictionary != null) {
            return this.nameDictionary;
        }
        this.nameDictionary = new Properties();
        if (GeneratorUtils.isNotEmptyAndNotNull((String)this.getePackageORMAnnotation().getNameDictionaryPropertyFile()) && this.getePackageORMAnnotation().getNameDictionaryPropertyFile().trim().length() > 0) {
            URI uri = this.getePackageORMAnnotation().getEPackage().eResource().getURI();
            uri = uri.trimSegments(1);
            uri = uri.appendSegment(this.getePackageORMAnnotation().getNameDictionaryPropertyFile());
            try {
                InputStream is = new ExtensibleURIConverterImpl().createInputStream(uri);
                if (is != null) {
                    this.nameDictionary.load(is);
                    is.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        return this.nameDictionary;
    }

    protected String getPropertyName(ENamedElement eNamedElement, String qualifier) {
        String searchName = eNamedElement.getName();
        if (eNamedElement instanceof EStructuralFeature) {
            searchName = String.valueOf(((EStructuralFeature)eNamedElement).getEContainingClass().getName()) + "." + searchName;
        }
        if (GeneratorUtils.isNotEmptyAndNotNull((String)qualifier)) {
            searchName = String.valueOf(searchName) + "." + qualifier;
        }
        if (GeneratorUtils.isNotEmptyAndNotNull((String)searchName)) {
            if (searchName.length() == 1) {
                return searchName.toLowerCase();
            }
            return String.valueOf(searchName.substring(0, 1).toLowerCase()) + searchName.substring(1);
        }
        return searchName;
    }

    protected String processName(String name, String prefix) {
        String localPrefix = this.getSafePrefixStr(prefix);
        String localName = this.makeSafe(name);
        if (localPrefix.trim().length() == 0) {
            localName = this.renameReservedWord(localName);
        }
        if (this.getePackageORMAnnotation().isLowerCasedNames()) {
            localName = localName.toLowerCase();
            localPrefix = localPrefix.toLowerCase();
        } else if (this.getePackageORMAnnotation().isUpperCasedNames()) {
            localName = localName.toUpperCase();
            localPrefix = localPrefix.toUpperCase();
        }
        int maxSqlLength = this.getePackageORMAnnotation().getMaximumSqlNameLength();
        if (localName.length() > maxSqlLength - localPrefix.length()) {
            localName = this.trunc(localName, maxSqlLength - localPrefix.length());
        }
        return String.valueOf(localPrefix) + localName;
    }

    protected String trunc(String name, int targetLength) {
        String correctedName = name;
        char correctedNameFirstChar = correctedName.charAt(0);
        String correctedNameTail = correctedName.substring(1);
        int truncSize = 1 + correctedNameTail.length() - targetLength;
        if (truncSize <= 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        char[] chrs = correctedNameTail.toCharArray();
        char[] removes = this.getRemovableCharacters();
        int i = chrs.length - 1;
        while (i >= 0) {
            char chr = chrs[i];
            boolean add = true;
            if (truncSize > 0) {
                char[] cArray = removes;
                int n = removes.length;
                int n2 = 0;
                while (n2 < n) {
                    char vowel = cArray[n2];
                    if (vowel == chr) {
                        add = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (add) {
                sb.insert(0, chr);
            } else {
                --truncSize;
            }
            --i;
        }
        if (truncSize == 0) {
            return String.valueOf(correctedNameFirstChar) + sb.toString();
        }
        return this.doLengthTruncation(String.valueOf(correctedNameFirstChar) + correctedNameTail, targetLength);
    }

    protected String doLengthTruncation(String correctedName, int targetLength) {
        int underscore = correctedName.lastIndexOf(95);
        if (underscore == -1) {
            return correctedName.substring(0, targetLength);
        }
        String[] parts = correctedName.split("_");
        int maxLength = -1;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() > maxLength && part.length() > 0) {
                maxLength = part.length();
            }
            ++n2;
        }
        int totalLength = correctedName.length();
        while (maxLength > 1 && totalLength > targetLength) {
            totalLength = 0;
            int newMax = 0;
            int i = 0;
            while (i < parts.length) {
                if (parts[i].length() == maxLength) {
                    parts[i] = parts[i].substring(0, maxLength - 1);
                }
                if (parts[i].length() > newMax) {
                    newMax = parts[i].length();
                }
                totalLength += parts[i].length();
                ++i;
            }
            totalLength += parts.length - 1;
            maxLength = newMax;
        }
        StringBuffer result = new StringBuffer();
        String[] stringArray2 = parts;
        int n3 = parts.length;
        int n4 = 0;
        while (n4 < n3) {
            String part = stringArray2[n4];
            if (result.length() > 0) {
                result.append("_");
            }
            result.append(part);
            ++n4;
        }
        return result.toString();
    }

    protected char[] getRemovableCharacters() {
        return removables;
    }
}

