/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.eclipse.ProjectPropertyUtil;
import org.eclipse.emf.texo.orm.annotations.model.orm.Converter;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotator.ORMMappingOptions;

public class ORMUtils {
    public static final String OBJECT_CONVERTER_CLASS = "org.eclipse.emf.texo.test.TexoTestObjectConverter";
    public static final String OBJECT_CONVERTER_NAME = "TexoTestObjectConverter";

    public static Converter createDefaultConverter() {
        Converter converter = OrmFactory.eINSTANCE.createConverter();
        converter.setClass(OBJECT_CONVERTER_CLASS);
        converter.setName(OBJECT_CONVERTER_NAME);
        return converter;
    }

    public static void setORMMappingOptionsFromProjectProperties(IProject project) {
        Properties props = ProjectPropertyUtil.getProjectProperties((IProject)project);
        ORMMappingOptions options = (ORMMappingOptions)ComponentProvider.getInstance().newInstance(ORMMappingOptions.class);
        options.setAddOrderColumnToListMappings(ORMUtils.isTrue(props.getProperty("ORM_ADD_ORDER_COLUMN")));
        options.setEnforceUniqueNames(ORMUtils.isTrue(props.getProperty("ORM_ENFORCE_UNIQUE_NAMES")));
        options.setGenerateFullDbSchemaNames(ORMUtils.isTrue(props.getProperty("ORM_GENERATE_FULL_DB_SCHEMA_NAMES")));
        options.setRenameSQLReservedNames(ORMUtils.isTrue(props.getProperty("ORM_RENAME_SQL_RESERVED_NAMES")));
        if (props.getProperty("ORM_MAX_SQL_NAME_LENGTH") != null) {
            try {
                int val = Integer.parseInt(props.getProperty("ORM_MAX_SQL_NAME_LENGTH"));
                if (val > 0) {
                    options.setMaximumSqlNameLength(val);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ORMMappingOptions.setDefaultOptions(options);
    }

    private static boolean isTrue(String value) {
        return value != null && value.equals("true");
    }
}

