/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.orm.annotator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.annotations.annotationsmodel.AnnotatedModel;
import org.eclipse.emf.texo.generator.AnnotationManager;
import org.eclipse.emf.texo.generator.ModelController;
import org.eclipse.emf.texo.orm.annotations.model.orm.DocumentRoot;
import org.eclipse.emf.texo.orm.annotations.model.orm.EntityMappingsType;
import org.eclipse.emf.texo.orm.annotations.model.orm.OrmFactory;
import org.eclipse.emf.texo.orm.annotations.model.orm.SupportedVersionsType;
import org.eclipse.emf.texo.orm.annotator.ORMGenerator;
import org.eclipse.emf.texo.orm.ormannotations.util.OrmannotationsResourceFactoryImpl;
import org.eclipse.emf.texo.orm.ormannotations.util.OrmannotationsResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardORMGenerator
extends ORMGenerator {
    private static final String STANDARD_ORM_NS = "http://java.sun.com/xml/ns/persistence/orm";
    private static final String ECLIPSELINK_ORM_NS = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";

    @Override
    public ModelController generateStoreORM(List<EPackage> ePackages, URI ormUri) {
        try {
            ORMGenerator.setInStandardsCompliantMode(true);
            ModelController modelController = super.generateStoreORM(ePackages, ormUri);
            return modelController;
        }
        finally {
            ORMGenerator.setInStandardsCompliantMode(null);
        }
    }

    @Override
    protected void storeORM(URI fileUri, AnnotatedModel annotatedModel, AnnotationManager annotationManager, EntityMappingsType entityMappings) {
        if (ORMGenerator.areInStandardsCompliantMode()) {
            entityMappings.setVersion(SupportedVersionsType._20);
        } else {
            entityMappings.setVersion(SupportedVersionsType._23);
        }
        OrmannotationsResourceImpl ormResource = (OrmannotationsResourceImpl)new OrmannotationsResourceFactoryImpl().createResource(fileUri);
        try {
            File file = new File(fileUri.toFileString());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            DocumentRoot docRoot = OrmFactory.eINSTANCE.createDocumentRoot();
            docRoot.setEntityMappings(entityMappings);
            ormResource.getContents().add((Object)docRoot);
            StringWriter sw = new StringWriter();
            ormResource.save(sw, Collections.emptyMap());
            FileWriter fw = new FileWriter(file);
            String result = sw.toString();
            while (result.contains(ECLIPSELINK_ORM_NS)) {
                result = result.replace(ECLIPSELINK_ORM_NS, STANDARD_ORM_NS);
            }
            fw.write(result);
            fw.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

