/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.DiagramPropertiesPlugin;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ColorPalettePopup {
    public static final Point ICON_SIZE = new Point(20, 20);
    private static final InventoryColorDescriptor WHITE = new InventoryColorDescriptor(new RGB(255, 255, 255));
    private static final InventoryColorDescriptor BLACK = new InventoryColorDescriptor(new RGB(0, 0, 0));
    private static final InventoryColorDescriptor LIGHT_GRAY = new InventoryColorDescriptor(new RGB(192, 192, 192));
    private static final InventoryColorDescriptor GRAY = new InventoryColorDescriptor(new RGB(128, 128, 128));
    private static final InventoryColorDescriptor RED = new InventoryColorDescriptor(new RGB(227, 164, 156));
    private static final InventoryColorDescriptor GREEN = new InventoryColorDescriptor(new RGB(166, 193, 152));
    private static final InventoryColorDescriptor BLUE = new InventoryColorDescriptor(new RGB(152, 168, 191));
    private static final InventoryColorDescriptor YELLOW = new InventoryColorDescriptor(new RGB(225, 225, 135));
    private static final InventoryColorDescriptor PURPLE = new InventoryColorDescriptor(new RGB(184, 151, 192));
    private static final InventoryColorDescriptor TEAL = new InventoryColorDescriptor(new RGB(155, 199, 204));
    private static final InventoryColorDescriptor PINK = new InventoryColorDescriptor(new RGB(228, 179, 229));
    private static final InventoryColorDescriptor ORANGE = new InventoryColorDescriptor(new RGB(237, 201, 122));
    private static final HashMap imageColorMap = new HashMap();
    private static final String DEAFULT_COLOR_STRING = DiagramUIPropertiesMessages.ColorPalettePopup_default;
    private static final String CUSTOM_COLOR_STRING = DiagramUIPropertiesMessages.ColorPalettePopup_custom;
    private Shell shell;
    private String preferenceId;
    private RGB selectedColor = null;

    static {
        imageColorMap.put(ColorPalettePopup.WHITE.rgb, WHITE.createImage());
        imageColorMap.put(ColorPalettePopup.BLACK.rgb, BLACK.createImage());
        imageColorMap.put(ColorPalettePopup.LIGHT_GRAY.rgb, LIGHT_GRAY.createImage());
        imageColorMap.put(ColorPalettePopup.GRAY.rgb, GRAY.createImage());
        imageColorMap.put(ColorPalettePopup.RED.rgb, RED.createImage());
        imageColorMap.put(ColorPalettePopup.GREEN.rgb, GREEN.createImage());
        imageColorMap.put(ColorPalettePopup.BLUE.rgb, BLUE.createImage());
        imageColorMap.put(ColorPalettePopup.YELLOW.rgb, YELLOW.createImage());
        imageColorMap.put(ColorPalettePopup.PURPLE.rgb, PURPLE.createImage());
        imageColorMap.put(ColorPalettePopup.TEAL.rgb, TEAL.createImage());
        imageColorMap.put(ColorPalettePopup.PINK.rgb, PINK.createImage());
        imageColorMap.put(ColorPalettePopup.ORANGE.rgb, ORANGE.createImage());
    }

    public ColorPalettePopup(Shell parent, String preferenceId, int rowHeight) {
        this(parent, rowHeight);
        this.preferenceId = preferenceId;
    }

    private ColorPalettePopup(Shell parent, int rowHeight) {
        this.shell = new Shell(parent, ColorPalettePopup.checkStyle(0));
        GridLayout layout = new GridLayout(4, true);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        Iterator e = imageColorMap.keySet().iterator();
        while (e.hasNext()) {
            Button button = new Button((Composite)this.shell, 8);
            GridData data = new GridData(256);
            data.heightHint = rowHeight;
            data.widthHint = rowHeight;
            button.setLayoutData((Object)data);
            final RGB rgb = (RGB)e.next();
            Image image = (Image)imageColorMap.get(rgb);
            button.setImage(image);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e1) {
                    ColorPalettePopup.this.selectedColor = rgb;
                    ColorPalettePopup.this.shell.dispose();
                }
            });
        }
        Button defaultColor = new Button((Composite)this.shell, 8);
        defaultColor.setText(DEAFULT_COLOR_STRING);
        GridData data = new GridData(256);
        data.horizontalSpan = 4;
        data.heightHint = rowHeight;
        defaultColor.setLayoutData((Object)data);
        defaultColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IPreferenceStore store = DiagramPropertiesPlugin.getDefault().getPreferenceStore();
                if (ColorPalettePopup.this.preferenceId != null) {
                    ColorPalettePopup.this.selectedColor = PreferenceConverter.getColor((IPreferenceStore)store, (String)ColorPalettePopup.this.preferenceId);
                }
                ColorPalettePopup.this.shell.dispose();
            }
        });
        Button moreColors = new Button((Composite)this.shell, 8);
        moreColors.setText(CUSTOM_COLOR_STRING);
        data = new GridData(256);
        data.horizontalSpan = 4;
        data.heightHint = rowHeight;
        moreColors.setLayoutData((Object)data);
        moreColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
                WindowUtil.centerDialog((Shell)dialog.getParent(), (Shell)Display.getCurrent().getActiveShell());
                dialog.open();
                ColorPalettePopup.this.selectedColor = dialog.getRGB();
                ColorPalettePopup.this.shell.dispose();
            }
        });
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                ColorPalettePopup.this.shell.setVisible(false);
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 0x6000000;
        return style & mask;
    }

    public RGB open(Point location) {
        Point listSize = this.shell.computeSize(-1, -1, false);
        this.shell.setBounds(location.x, location.y, listSize.x, listSize.y);
        this.shell.open();
        this.shell.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getSelectedColor();
    }

    public RGB getSelectedColor() {
        return this.selectedColor;
    }

    private static class InventoryColorDescriptor
    extends ImageDescriptor {
        private static final RGB OUTLINE_COLOR = new RGB(192, 192, 192);
        public RGB rgb;

        public InventoryColorDescriptor(RGB colorValue) {
            this.rgb = colorValue;
        }

        public ImageData getImageData() {
            ImageData data = new ImageData(ColorPalettePopup.ICON_SIZE.x, ColorPalettePopup.ICON_SIZE.y, 1, new PaletteData(new RGB[]{this.rgb, OUTLINE_COLOR}));
            int i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.y) {
                data.setPixel(0, i, 1);
                ++i;
            }
            i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.y) {
                data.setPixel(ColorPalettePopup.ICON_SIZE.x - 1, i, 1);
                ++i;
            }
            i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.x) {
                data.setPixel(i, 0, 1);
                ++i;
            }
            i = 0;
            while (i < ColorPalettePopup.ICON_SIZE.x) {
                data.setPixel(i, ColorPalettePopup.ICON_SIZE.y - 1, 1);
                ++i;
            }
            return data;
        }

        public Image createImage() {
            Display device = Display.getCurrent();
            ImageData data = this.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
            }
            try {
                if (data.transparentPixel >= 0) {
                    ImageData maskData = data.getTransparencyMask();
                    return new Image((Device)device, data, maskData);
                }
                return new Image((Device)device, data);
            }
            catch (SWTException sWTException) {
                try {
                    return new Image((Device)device, DEFAULT_IMAGE_DATA);
                }
                catch (SWTException sWTException2) {
                    return null;
                }
            }
        }
    }
}

