/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.ide.actions.global;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalActionManager;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalAction;
import org.eclipse.gmf.runtime.common.ui.action.ide.actions.global.GlobalBookmarkAction;
import org.eclipse.gmf.runtime.common.ui.action.ide.actions.global.GlobalCloseProjectAction;
import org.eclipse.gmf.runtime.common.ui.action.ide.actions.global.GlobalOpenProjectAction;
import org.eclipse.gmf.runtime.common.ui.action.ide.global.IDEGlobalActionId;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class IDEGlobalActionManager
extends GlobalActionManager {
    private static final List actionIdStrings = new ArrayList();
    private static IDEGlobalActionManager instance;
    private static GlobalActionManager globalActionManager;

    static {
        actionIdStrings.add(IDEGlobalActionId.BOOKMARK);
        actionIdStrings.add(IDEGlobalActionId.OPEN_PROJECT);
        actionIdStrings.add(IDEGlobalActionId.CLOSE_PROJECT);
        instance = new IDEGlobalActionManager();
        globalActionManager = GlobalActionManager.getInstance();
    }

    public static GlobalActionManager getInstance() {
        return instance;
    }

    private IDEGlobalActionManager() {
        Iterator it = actionIdStrings.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            this.addActionId(id);
        }
    }

    public GlobalAction createActionHandler(IWorkbenchPage page, String id) {
        GlobalBookmarkAction action = null;
        action = id.equals(IDEGlobalActionId.BOOKMARK) ? new GlobalBookmarkAction(page) : globalActionManager.createActionHandler(page, id);
        if (action != null) {
            action.init();
        }
        return action;
    }

    public GlobalAction createActionHandler(IWorkbenchPart part, String id) {
        GlobalAction action = null;
        action = id.equals(IDEGlobalActionId.BOOKMARK) ? new GlobalBookmarkAction(part) : (id.equals(IDEGlobalActionId.OPEN_PROJECT) ? new GlobalOpenProjectAction(part) : (id.equals(IDEGlobalActionId.CLOSE_PROJECT) ? new GlobalCloseProjectAction(part) : globalActionManager.createActionHandler(part, id)));
        if (action != null) {
            action.init();
        }
        return action;
    }

    public GlobalAction[] createGlobalActions(IWorkbenchPart part, String[] actionIds) {
        ArrayList<String> forSuper = new ArrayList<String>();
        ArrayList<String> forGlobalActionManager = new ArrayList<String>();
        int i = 0;
        while (i < actionIds.length) {
            if (actionIdStrings.contains(actionIds[i])) {
                forSuper.add(actionIds[i]);
            } else {
                forGlobalActionManager.add(actionIds[i]);
            }
            ++i;
        }
        String[] superArray = new String[forSuper.size()];
        String[] globalActionManagerArray = new String[forGlobalActionManager.size()];
        forSuper.toArray(superArray);
        forGlobalActionManager.toArray(globalActionManagerArray);
        GlobalAction[] actions1 = globalActionManager.createGlobalActions(part, globalActionManagerArray);
        GlobalAction[] actions2 = new GlobalAction[]{};
        if (superArray.length > 0) {
            actions2 = super.createGlobalActions(part, superArray);
        }
        GlobalAction[] allActions = new GlobalAction[actions1.length + actions2.length];
        System.arraycopy(actions1, 0, allActions, 0, actions1.length);
        System.arraycopy(actions2, 0, allActions, actions1.length, actions2.length);
        return allActions;
    }

    public GlobalAction[] createGlobalActions(IWorkbenchPart part) {
        GlobalAction[] actions1 = globalActionManager.createGlobalActions(part);
        GlobalAction[] actions2 = super.createGlobalActions(part);
        GlobalAction[] allActions = new GlobalAction[actions1.length + actions2.length];
        System.arraycopy(actions1, 0, allActions, 0, actions1.length);
        System.arraycopy(actions2, 0, allActions, actions1.length, actions2.length);
        return allActions;
    }

    public GlobalAction getGlobalAction(IWorkbenchPart part, String actionId) {
        GlobalAction action = super.getGlobalAction(part, actionId);
        return action != null ? action : globalActionManager.getGlobalActionHandler(part, actionId);
    }

    public GlobalAction getGlobalActionHandler(IWorkbenchPart part, String globalActionId) {
        GlobalAction action = super.getGlobalActionHandler(part, globalActionId);
        return action != null ? action : globalActionManager.getGlobalActionHandler(part, globalActionId);
    }

    public void refreshGlobalActions(IWorkbenchPart part) {
        globalActionManager.refreshGlobalActions(part);
        super.refreshGlobalActions(part);
    }

    public void setGlobalActionHandlers(IActionBars bar, IWorkbenchPart part) {
        globalActionManager.setGlobalActionHandlers(bar, part);
        super.setGlobalActionHandlers(bar, part);
    }

    public void unSetGlobalActionHandlers(IActionBars bar, IWorkbenchPart part) {
        globalActionManager.unSetGlobalActionHandlers(bar, part);
        super.unSetGlobalActionHandlers(bar, part);
    }
}

