/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.editparts;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScalableFreeformLayeredPane;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.ScaledGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedMapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.graphics.RenderedScaledGraphics;
import org.eclipse.gmf.runtime.gef.ui.internal.editparts.AnimatedZoomListener;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;

public class RenderedDiagramRootEditPart
extends DiagramRootEditPart {
    public RenderedDiagramRootEditPart() {
    }

    public RenderedDiagramRootEditPart(MeasurementUnit mu) {
        super(mu);
    }

    protected org.eclipse.draw2d.ScalableFreeformLayeredPane createScalableFreeformLayeredPane() {
        this.setLayers((org.eclipse.draw2d.ScalableFreeformLayeredPane)new DiagramRenderedScalableFreeformLayeredPane(this.getMapMode()));
        return this.getLayers();
    }

    protected void refreshEnableAntiAlias() {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getPreferencesHint().getPreferenceStore();
        boolean antiAlias = preferenceStore.getBoolean("Global.enableAntiAlias");
        if (this.getLayers() instanceof ScalableFreeformLayeredPane) {
            ((ScalableFreeformLayeredPane)this.getLayers()).setAntiAlias(antiAlias);
        }
    }

    protected static class DiagramRenderedScalableFreeformLayeredPane
    extends DiagramRootEditPart.DiagramScalableFreeformLayeredPane
    implements AnimatedZoomListener {
        private boolean animatedZoomOn;
        private static final Dimension MAX_RENDER_SIZE = new Dimension(PlatformUI.getWorkbench().getDisplay().getBounds().width, PlatformUI.getWorkbench().getDisplay().getBounds().height);

        protected ScaledGraphics createScaledGraphics(MapModeGraphics gMM) {
            if (this.animatedZoomOn) {
                return new ScaledGraphics((Graphics)gMM);
            }
            return new RenderedScaledGraphics((Graphics)gMM, true, MAX_RENDER_SIZE);
        }

        protected MapModeGraphics createMapModeGraphics(Graphics graphics) {
            RenderedMapModeGraphics gMM = new RenderedMapModeGraphics(graphics, this.getMapMode(), true, MAX_RENDER_SIZE);
            return gMM;
        }

        public void animatedZoomEnded() {
            this.animatedZoomOn = false;
            Layer primaryLayer = this.getLayer("Printable Layers");
            if (primaryLayer != null) {
                this.paintScalableImageFigures(primaryLayer.getChildren());
            }
        }

        private void paintScalableImageFigures(List figures) {
            ListIterator iter = figures.listIterator();
            Rectangle absbounds = this.getBounds().getCopy();
            this.translateToAbsolute((Translatable)absbounds);
            while (iter.hasNext()) {
                IFigure fig = (IFigure)iter.next();
                if (fig instanceof ScalableImageFigure) {
                    Rectangle absfigbounds = fig.getBounds().getCopy();
                    fig.translateToAbsolute((Translatable)absfigbounds);
                    if (!absbounds.intersects(absfigbounds)) continue;
                    fig.repaint();
                    continue;
                }
                this.paintScalableImageFigures(fig.getChildren());
            }
        }

        public void animatedZoomStarted() {
            this.animatedZoomOn = true;
        }

        public DiagramRenderedScalableFreeformLayeredPane(IMapMode mm) {
            super(mm);
        }
    }
}

