/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ListComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ModifySortFilterEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.NestedResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.notation.Filtering;
import org.eclipse.gmf.runtime.notation.FilteringStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Sorting;
import org.eclipse.gmf.runtime.notation.SortingDirection;
import org.eclipse.gmf.runtime.notation.SortingStyle;
import org.eclipse.gmf.runtime.notation.View;

public abstract class ListCompartmentEditPart
extends ResizableCompartmentEditPart {
    static long count = 0L;
    protected List modelChildrenListeners;
    protected boolean listening;

    public ListCompartmentEditPart(EObject model) {
        super(model);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ModifySortFilterPolicy", (EditPolicy)new ModifySortFilterEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ListComponentEditPolicy());
    }

    public IFigure createFigure() {
        ResizableCompartmentFigure rcf = this.getParent() == this.getTopGraphicEditPart() ? (ResizableCompartmentFigure)super.createFigure() : new NestedResizableCompartmentFigure(this.getMapMode());
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
        layout.setStretchMajorAxis(false);
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(1);
        rcf.getContentPane().setLayoutManager((LayoutManager)layout);
        return rcf;
    }

    protected final List getModelChildren() {
        ArrayList sortedFilteredChildren = new ArrayList(this.getSortedChildren());
        sortedFilteredChildren.removeAll(this.getFilteredChildren());
        return sortedFilteredChildren;
    }

    protected List getBaseModelChildren() {
        return super.getChildren();
    }

    protected abstract boolean hasModelChildrenChanged(Notification var1);

    protected void handleNotificationEvent(Notification event) {
        if (this.hasModelChildrenChanged(event) && this.modeAutomatic()) {
            this.removeSemanticChildrenListeners();
            this.addSemanticChildrenListeners();
            this.refresh();
        }
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFilteringStyle_Filtering().equals(feature) || NotationPackage.eINSTANCE.getFilteringStyle_FilteringKeys().equals(feature) || NotationPackage.eINSTANCE.getFilteringStyle_FilteredObjects().equals(feature) || NotationPackage.eINSTANCE.getSortingStyle_Sorting().equals(feature) || NotationPackage.eINSTANCE.getSortingStyle_SortingKeys().equals(feature) || NotationPackage.eINSTANCE.getSortingStyle_SortedObjects().equals(feature)) {
            this.refresh();
            if (this.modeAutomatic() && !this.listening) {
                this.removeSemanticChildrenListeners();
                this.addSemanticChildrenListeners();
            }
            if (!this.modeAutomatic() && this.listening) {
                this.removeSemanticChildrenListeners();
            }
        } else {
            super.handleNotificationEvent(event);
        }
        if (this.isAffectingSortingFiltering(feature) && this.modeAutomatic()) {
            this.refresh();
        }
    }

    protected List getSortedChildren() {
        SortingStyle style = (SortingStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getSortingStyle());
        if (style != null) {
            Sorting sorting = style.getSorting();
            if (Sorting.NONE_LITERAL == sorting) {
                return super.getModelChildren();
            }
            if (Sorting.MANUAL_LITERAL == sorting) {
                View view;
                List allChildren = super.getModelChildren();
                if (allChildren.isEmpty()) {
                    return allChildren;
                }
                List sortedChildren = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSortingStyle_SortedObjects()) ? style.getSortedObjects() : Collections.EMPTY_LIST;
                ArrayList<View> sorted = new ArrayList<View>();
                Iterator i = sortedChildren.iterator();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    view = this.getModelChildByID(eObject);
                    if (view == null) continue;
                    sorted.add(view);
                }
                int j = 0;
                while (j < allChildren.size()) {
                    view = (View)allChildren.get(j);
                    if (!sorted.contains(view)) {
                        sorted.add(view);
                    }
                    ++j;
                }
                return sorted;
            }
            if (Sorting.AUTOMATIC_LITERAL == sorting) {
                Map sortingKeys = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getSortingStyle_SortingKeys()) ? style.getSortingKeys() : Collections.EMPTY_MAP;
                return this.getChildrenSortedBy(sortingKeys);
            }
        }
        return super.getModelChildren();
    }

    protected List getChildrenSortedBy(Map sortingKeys) {
        SortingDirection direction;
        Set keySet;
        Iterator i;
        String name;
        Comparator comparator;
        ArrayList allChildren = new ArrayList(super.getModelChildren());
        if (sortingKeys != null && !sortingKeys.isEmpty() && (comparator = this.getComparator(name = (String)(i = (keySet = sortingKeys.keySet()).iterator()).next(), direction = (SortingDirection)sortingKeys.get(name))) != null) {
            Collections.sort(allChildren, this.getComparator(name, direction));
        }
        return allChildren;
    }

    protected Comparator getComparator(String name, SortingDirection direction) {
        return null;
    }

    protected List getFilteredChildren() {
        View view;
        FilteringStyle style;
        Object model = this.getModel();
        if (model instanceof View && (style = (FilteringStyle)(view = (View)model).getStyle(NotationPackage.eINSTANCE.getFilteringStyle())) != null) {
            Filtering filtering = style.getFiltering();
            if (Filtering.NONE_LITERAL == filtering) {
                return Collections.EMPTY_LIST;
            }
            if (Filtering.MANUAL_LITERAL == filtering) {
                List filteredChildren = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getFilteringStyle_FilteredObjects()) ? style.getFilteredObjects() : Collections.EMPTY_LIST;
                ArrayList<View> filteredViews = new ArrayList<View>();
                Iterator i = filteredChildren.iterator();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    filteredViews.add(this.getModelChildByID(eObject));
                }
                return filteredViews;
            }
            if (Filtering.AUTOMATIC_LITERAL == filtering) {
                List filteringKeys = style.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getFilteringStyle_FilteringKeys()) ? style.getFilteringKeys() : Collections.EMPTY_LIST;
                return this.getChildrenFilteredBy(filteringKeys);
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected List getChildrenFilteredBy(List filterKeys) {
        return Collections.EMPTY_LIST;
    }

    public String getCompartmentName() {
        return null;
    }

    protected View getModelChildByID(EObject eObject) {
        int i = 0;
        while (i < super.getModelChildren().size()) {
            View view = (View)super.getModelChildren().get(i);
            EObject e = ViewUtil.resolveSemanticElement((View)view);
            if (eObject.equals(e)) {
                return view;
            }
            ++i;
        }
        return null;
    }

    protected boolean modeAutomatic() {
        View view = this.getNotationView();
        if (view != null) {
            SortingStyle sortingStyle = (SortingStyle)view.getStyle(NotationPackage.eINSTANCE.getSortingStyle());
            FilteringStyle filteringStyle = (FilteringStyle)view.getStyle(NotationPackage.eINSTANCE.getFilteringStyle());
            if (sortingStyle != null && Sorting.AUTOMATIC_LITERAL == sortingStyle.getSorting()) {
                return true;
            }
            if (filteringStyle != null && Filtering.AUTOMATIC_LITERAL == filteringStyle.getFiltering()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAffectingSortingFiltering(Object feature) {
        return false;
    }

    protected void addSemanticChildrenListeners() {
        this.modelChildrenListeners = super.getModelChildren();
        int i = 0;
        while (i < this.modelChildrenListeners.size()) {
            EObject eObject = ViewUtil.resolveSemanticElement((View)((View)this.modelChildrenListeners.get(i)));
            if (eObject != null) {
                this.addListenerFilter("SemanticModel" + i, this, eObject);
            }
            ++i;
        }
        this.listening = true;
    }

    protected void removeSemanticChildrenListeners() {
        if (this.modelChildrenListeners != null) {
            int i = 0;
            while (i < this.modelChildrenListeners.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
            this.modelChildrenListeners.clear();
        }
        this.listening = false;
    }

    protected void addSemanticListeners() {
        if (this.modeAutomatic() && !this.listening) {
            this.addSemanticChildrenListeners();
        }
        super.addSemanticListeners();
    }

    protected void removeSemanticListeners() {
        this.removeSemanticChildrenListeners();
        this.modelChildrenListeners = null;
        this.listening = false;
        super.removeSemanticListeners();
    }
}

