/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ICanonicalShapeCompartmentLayout;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

public abstract class CanonicalConnectionEditPolicy
extends CanonicalEditPolicy {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected abstract List getSemanticConnectionsList();

    protected abstract EObject getSourceElement(EObject var1);

    protected abstract EObject getTargetElement(EObject var1);

    protected List getSemanticChildrenList() {
        return Collections.EMPTY_LIST;
    }

    protected void refreshOnActivate() {
        List c = this.getHost().getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        this.refresh();
    }

    protected boolean canCreateConnection(EditPart sep, EditPart tep, EObject connection) {
        if (sep != null && sep.isActive() && tep != null && tep.isActive()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            View src = (View)sep.getAdapter((Class)clazz);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            View tgt = (View)tep.getAdapter((Class)clazz2);
            if (src != null && tgt != null) {
                return sep.getParent().getEditPolicy((Object)"Canonical") != null && tep.getParent().getEditPolicy((Object)"Canonical") != null;
            }
        }
        return false;
    }

    private EditPart getEditPartFor(EObject element, EObject context) {
        EditPartViewer viewer;
        if (element != null && !(element instanceof View) && (viewer = this.getHost().getViewer()) instanceof IDiagramGraphicalViewer) {
            EObject container;
            EditPart containerEP;
            List parts;
            IDiagramGraphicalViewer iDiagramGraphicalViewer = (IDiagramGraphicalViewer)viewer;
            String string = EMFCoreUtil.getProxyID((EObject)element);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((parts = iDiagramGraphicalViewer.findEditPartsForElement(string, clazz)).isEmpty() && (containerEP = this.getEditPartFor(container = element.eContainer(), null)) != null) {
                containerEP.refresh();
                IDiagramGraphicalViewer iDiagramGraphicalViewer2 = (IDiagramGraphicalViewer)viewer;
                String string2 = EMFCoreUtil.getProxyID((EObject)element);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                parts = iDiagramGraphicalViewer2.findEditPartsForElement(string2, clazz2);
            }
            return this.findEditPartForElement(element, context, parts);
        }
        return (EditPart)this.host().getViewer().getEditPartRegistry().get(element);
    }

    protected EditPart findEditPartForElement(EObject element, EObject context, List parts) {
        EditPart ancestor = this.getHost();
        while (ancestor != null) {
            EditPart ep = this.reachForEditPartWithAncestor(parts, ancestor);
            if (ep != null) {
                return ep;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private EditPart reachForEditPartWithAncestor(List results, EditPart ancestor) {
        ListIterator li = results.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            EditPart walker = ep.getParent();
            while (walker != null) {
                if (walker.equals(ancestor)) {
                    return ep;
                }
                walker = walker.getParent();
            }
        }
        return null;
    }

    protected String getDefaultFactoryHint() {
        return "";
    }

    protected final Edge createConnectionView(EObject connection, int index) {
        EditPart tep;
        EditPart sep = this.getSourceEditPartFor(connection);
        if (!this.canCreateConnection(sep, tep = this.getTargetEditPartFor(connection), connection)) {
            return null;
        }
        View sView = (View)sep.getModel();
        View tView = (View)tep.getModel();
        Edge model = null;
        String factoryHint = this.getDefaultFactoryHint();
        CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(connection, factoryHint);
        CreateConnectionViewRequest ccr = this.getCreateConnectionViewRequest((IAdaptable)elementAdapter, this.getFactoryHint((IAdaptable)elementAdapter, factoryHint), index);
        ccr.setType("connection start");
        ccr.setSourceEditPart(sep);
        this.getCreateViewCommand((CreateRequest)ccr);
        ccr.setTargetEditPart(tep);
        ccr.setType("connection end");
        Command cmd = this.getCreateViewCommand((CreateRequest)ccr);
        if (cmd != null && cmd.canExecute()) {
            ArrayList<EObjectAdapter> viewAdapters = new ArrayList<EObjectAdapter>();
            viewAdapters.add(new EObjectAdapter((EObject)((View)this.host().getModel()).getDiagram()));
            viewAdapters.add(new EObjectAdapter((EObject)sView));
            viewAdapters.add(new EObjectAdapter((EObject)tView));
            SetViewMutabilityCommand.makeMutable(viewAdapters).execute();
            this.executeCommand(cmd);
            IAdaptable adapter = (IAdaptable)ccr.getNewObject();
            SetViewMutabilityCommand.makeMutable(adapter).execute();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.notation.Edge");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((model = (Edge)adapter.getAdapter((Class)clazz)) == null) {
                String eMsg = NLS.bind((String)DiagramUIMessages.CanonicalEditPolicy_create_view_failed_ERROR_, (Object)connection);
                IllegalStateException ise = new IllegalStateException(eMsg);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)eMsg, (Throwable)ise);
                throw ise;
            }
        }
        return model;
    }

    protected EditPart getTargetEditPartFor(EObject connection) {
        EObject tel = this.getTargetElement(connection);
        EditPart tep = this.getEditPartFor(tel, connection);
        return tep;
    }

    protected EditPart getSourceEditPartFor(EObject connection) {
        EObject sel = this.getSourceElement(connection);
        EditPart sep = this.getEditPartFor(sel, connection);
        return sep;
    }

    protected Command getCreateViewCommand(CreateRequest request) {
        if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest ccr = (CreateConnectionViewRequest)request;
            EditPart ep = ccr.getTargetEditPart() == null ? ccr.getSourceEditPart() : ccr.getTargetEditPart();
            return ep.getCommand((Request)request);
        }
        return super.getCreateViewCommand(request);
    }

    protected CreateViewRequest getCreateViewRequest(CreateViewRequest.ViewDescriptor descriptor) {
        return this.getCreateViewRequest(Collections.singletonList(descriptor));
    }

    protected CreateViewRequest getCreateViewRequest(List descriptors) {
        CreateViewRequest cvr = super.getCreateViewRequest(descriptors);
        Point loc = ICanonicalShapeCompartmentLayout.UNDEFINED.getLocation();
        cvr.setLocation(loc);
        return cvr;
    }

    private CreateConnectionViewRequest getCreateConnectionViewRequest(IAdaptable elementAdapter, String hint, int index) {
        return new CreateConnectionViewRequest(this.getConnectionViewDescriptor(elementAdapter, hint, index));
    }

    private CreateConnectionViewRequest.ConnectionViewDescriptor getConnectionViewDescriptor(IAdaptable elementAdapter, String hint, int index) {
        return new CreateConnectionViewRequest.ConnectionViewDescriptor(elementAdapter, hint, index, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
    }

    protected List refreshSemanticConnections() {
        Collection viewChildren = this.getConnectionViews();
        HashSet semanticChildren = new HashSet();
        semanticChildren.addAll(this.getSemanticConnectionsList());
        List orphaned = this.cleanCanonicalSemanticChildren(viewChildren, semanticChildren);
        this.deleteViews(orphaned.iterator());
        ArrayList<EObjectAdapter> viewDescriptors = new ArrayList<EObjectAdapter>();
        Iterator semanticChildrenIT = semanticChildren.iterator();
        while (semanticChildrenIT.hasNext()) {
            EObject semanticChild = (EObject)semanticChildrenIT.next();
            Edge viewChild = this.createConnectionView(semanticChild, -1);
            if (viewChild == null) continue;
            viewDescriptors.add(new EObjectAdapter((EObject)viewChild));
        }
        this.makeViewsMutable(viewDescriptors);
        HashSet<EditPart> ends = new HashSet<EditPart>();
        ListIterator li = viewDescriptors.listIterator();
        while (li.hasNext()) {
            EditPart targetEP;
            Edge edge;
            EditPart sourceEP;
            IAdaptable adaptable = (IAdaptable)li.next();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.gmf.runtime.notation.Edge");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((sourceEP = this.getEditPartFor((EObject)(edge = (Edge)adaptable.getAdapter((Class)clazz)).getSource(), (EObject)edge)) != null) {
                ends.add(sourceEP);
            }
            if ((targetEP = this.getEditPartFor((EObject)edge.getTarget(), (EObject)edge)) == null) continue;
            ends.add(targetEP);
        }
        Iterator iter = ends.iterator();
        while (iter.hasNext()) {
            EditPart end = (EditPart)iter.next();
            end.refresh();
        }
        return viewDescriptors;
    }

    protected void refreshSemantic() {
        List createdViews = super.refreshSemanticChildren();
        List createdConnectionViews = this.refreshSemanticConnections();
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand(new ICommandProxy((ICommand)layoutCmd));
        }
        ArrayList allViews = new ArrayList(createdConnectionViews.size() + createdViews.size());
        allViews.addAll(createdViews);
        allViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(allViews);
    }

    protected boolean shouldDeleteView(View view) {
        return ViewUtil.resolveSemanticElement((View)view) == null;
    }

    protected void postProcessRefreshSemantic(List viewDescriptors) {
        this.makeViewsMutable(viewDescriptors);
        super.postProcessRefreshSemantic(viewDescriptors);
    }

    protected Collection getConnectionViews() {
        List children = this.getViewChildren();
        HashSet connections = new HashSet();
        if (this.getHost() instanceof IGraphicalEditPart) {
            IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost();
            this.getConnectionViews(connections, gep.getNotationView(), children);
        }
        return connections;
    }

    private void getConnectionViews(Set connections, View view, Collection viewChildren) {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost();
        View hostView = gep.getNotationView();
        if (hostView != view && !this.shouldCheckForConnections(view, viewChildren)) {
            return;
        }
        ListIterator sourceIter = view.getSourceEdges().listIterator();
        while (sourceIter.hasNext()) {
            Edge sourceEdge = (Edge)sourceIter.next();
            if (!this.shouldIncludeConnection(sourceEdge, viewChildren)) continue;
            connections.add(sourceEdge);
        }
        ListIterator targetIter = view.getTargetEdges().listIterator();
        while (targetIter.hasNext()) {
            Edge targetEdge = (Edge)targetIter.next();
            if (!this.shouldIncludeConnection(targetEdge, viewChildren)) continue;
            connections.add(targetEdge);
        }
        EList children = view.getChildren();
        ListIterator iter = children.listIterator();
        while (iter.hasNext()) {
            View viewChild = (View)iter.next();
            if (!(viewChild instanceof Node)) continue;
            this.getConnectionViews(connections, viewChild, viewChildren);
        }
    }

    protected boolean shouldCheckForConnections(View view, Collection viewChildren) {
        return view != null && (viewChildren.contains(view) || viewChildren.contains(view.eContainer()));
    }

    protected boolean shouldIncludeConnection(Edge connection, Collection children) {
        return this.shouldCheckForConnections(connection.getSource(), children) || this.shouldCheckForConnections(connection.getTarget(), children);
    }

    public Command getCommand(Request request) {
        if (this.understandsRequest(request) && this.isEnabled() && request instanceof DropObjectsRequest) {
            return this.getDropCommand((DropObjectsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getDropCommand(DropObjectsRequest request) {
        boolean enabled = this.isEnabled();
        List children = this.getSemanticChildrenList();
        Iterator dropElements = request.getObjects().iterator();
        while (dropElements.hasNext()) {
            Object dropElement = dropElements.next();
            if (dropElement instanceof Diagram) continue;
            if (dropElement instanceof EObject && this.preventDropElement(dropElement)) {
                return UnexecutableCommand.INSTANCE;
            }
            boolean containsElement = children.contains(dropElement);
            if (!enabled || !containsElement && !this.preventDropElement(dropElement)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return null;
    }

    protected boolean preventDropElement(Object dropElement) {
        return dropElement instanceof EObject ? !PackageUtil.canContain((EClass)this.getSemanticHost().eClass(), (EClass)((EObject)dropElement).eClass(), (boolean)false) : false;
    }

    public boolean understandsRequest(Request req) {
        return "drop_objects".equals(req.getType()) || req instanceof DropObjectsRequest || "create child".equals(req.getType()) ? true : super.understandsRequest(req);
    }
}

