/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.util;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EditPartUtil {
    public static String getSemanticEClassName(IGraphicalEditPart editPart) {
        if (editPart.getModel() instanceof View) {
            View view = (View)editPart.getModel();
            EObject element = view.getElement();
            return element == null ? null : PackageUtil.getID((ENamedElement)EMFCoreUtil.getProxyClass((EObject)element));
        }
        return null;
    }

    public static void synchronizeRunnableToMainThread(IGraphicalEditPart editPart, Runnable runThreadSafe) {
        InternalTransactionalEditingDomain editingDomain = (InternalTransactionalEditingDomain)editPart.getEditingDomain();
        if (Display.getCurrent() == null && editingDomain != null && editingDomain.getActiveTransaction() != null) {
            if (editingDomain != null) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)editingDomain.createPrivilegedRunnable(runThreadSafe));
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(runThreadSafe);
        } else {
            runThreadSafe.run();
        }
    }

    public static boolean isWriteTransactionInProgress(IGraphicalEditPart editPart, boolean includeUnprotected, boolean otherThread) {
        InternalTransactionalEditingDomain internalEditingDomain;
        InternalTransaction transaction;
        TransactionalEditingDomain theEditingDomain = editPart.getEditingDomain();
        if (theEditingDomain instanceof InternalTransactionalEditingDomain && (transaction = (internalEditingDomain = (InternalTransactionalEditingDomain)theEditingDomain).getActiveTransaction()) != null && !transaction.isReadOnly()) {
            Object unprotectedMode;
            if (!includeUnprotected && (unprotectedMode = transaction.getOptions().get("unprotected")) != null && unprotectedMode == Boolean.TRUE) {
                return false;
            }
            if (otherThread && Thread.currentThread() != transaction.getOwner()) {
                return true;
            }
            if (!otherThread) {
                return true;
            }
        }
        return false;
    }
}

