/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.action.filter;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.HashUtil;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.TestAttributeOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionPlugin;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.filter.IActionFilterProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActionFilterService
extends Service
implements IActionFilterProvider,
IOperationHistoryListener {
    protected static final String PREFIX = "@";
    private static final ActionFilterService instance = new ActionFilterService();
    private final Map cachedResults = new HashMap();
    private WeakReference cachedSelection = null;

    static {
        instance.configureProviders(CommonUIServicesActionPlugin.getPluginId(), "actionFilterProviders");
    }

    protected ActionFilterService() {
        super(true);
        this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
    }

    public static ActionFilterService getInstance() {
        return instance;
    }

    private Map getCachedResults() {
        return this.cachedResults;
    }

    private ISelection getCachedSelection() {
        Object sel;
        if (this.cachedSelection != null && (sel = this.cachedSelection.get()) != null) {
            return (ISelection)sel;
        }
        return StructuredSelection.EMPTY;
    }

    private void setCachedSelection(ISelection selection) {
        this.cachedSelection = new WeakReference<ISelection>(selection);
    }

    protected ActionManager getActionManager() {
        return ActionManager.getDefault();
    }

    protected IOperationHistory getOperationHistory() {
        return this.getActionManager().getOperationHistory();
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public final void clearCachedResults() {
        this.getCachedResults().clear();
    }

    protected void updateCachedData() {
        ISelection selection = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            selection = window.getSelectionService().getSelection();
        }
        Object object = selection = selection == null ? StructuredSelection.EMPTY : selection;
        if (!this.getCachedSelection().equals(selection)) {
            this.clearCachedResults();
            this.setCachedSelection(selection);
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        Object[] parameters = new Object[]{String.valueOf(target), name, value};
        if (Trace.shouldTrace((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.METHODS_ENTERING)) {
            Trace.entering((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.METHODS_ENTERING, this.getClass(), (String)"testAttribute", (Object[])parameters);
        }
        this.updateCachedData();
        Integer key = new Integer(HashUtil.hash((int)HashUtil.hash((Object)name), (Object)value));
        Boolean result = (Boolean)this.getCachedResults().get(key);
        if (result == null) {
            List results;
            String normalizedname = name;
            if (name.startsWith(PREFIX)) {
                normalizedname = name.substring(1);
            }
            result = (results = this.execute(ExecutionStrategy.FIRST, new TestAttributeOperation(target, normalizedname, value))).isEmpty() ? Boolean.FALSE : (Boolean)results.get(0);
            this.getCachedResults().put(key, result);
        }
        return result;
    }

    public void historyNotification(OperationHistoryEvent event) {
        this.clearCachedResults();
        this.setCachedSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        protected static final String A_NAME = "name";
        protected static final String A_VALUE = "value";
        protected static final String E_ATTRIBUTE = "Attribute";

        protected ProviderDescriptor(IConfigurationElement element) {
            super(element);
        }

        public boolean provides(IOperation operation) {
            IConfigurationElement[] elements = this.getElement().getChildren(E_ATTRIBUTE);
            if (elements.length > 0) {
                TestAttributeOperation tao = (TestAttributeOperation)operation;
                int i = 0;
                while (i < elements.length) {
                    try {
                        String name = elements[i].getAttribute(A_NAME);
                        String value = elements[i].getAttribute(A_VALUE);
                        if (name.equals(tao.getName()) && (value == null || value.equals(tao.getValue()))) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"provides", (Throwable)e);
                        Log.error((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)MessageFormat.format("Invalid XML element ({0}).", elements[i].getName()), (Throwable)e);
                    }
                    ++i;
                }
                return false;
            }
            return super.provides(operation);
        }
    }
}

