/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.reconcile.AbstractPool;
import org.eclipse.gmf.internal.common.reconcile.Copier;
import org.eclipse.gmf.internal.common.reconcile.Decision;
import org.eclipse.gmf.internal.common.reconcile.DecisionMaker;
import org.eclipse.gmf.internal.common.reconcile.Matcher;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;

public class Reconciler {
    private static final int PAIRS_POOL_SIZE = 100;
    private static final int STORAGE_POOL_SIZE = 10;
    private final ReconcilerConfig myConfig;
    private final MatchingSession myMatchingSession;
    private final StoragePool myStoragePool;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.common.reconcile.Reconciler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Reconciler(ReconcilerConfig config) {
        this.myConfig = config;
        this.myMatchingSession = new MatchingSession(new PairsPool(100));
        this.myStoragePool = new StoragePool(10);
    }

    protected void handleNotMatchedCurrent(EObject current) {
    }

    protected EObject handleNotMatchedOld(EObject currentParent, EObject notMatchedOld) {
        Copier copier = this.myConfig.getCopier(notMatchedOld.eClass());
        return copier.copyToCurrent(currentParent, notMatchedOld);
    }

    public void reconcileResource(Resource current, Resource old) {
        this.reconcileContents(null, (Collection)current.getContents(), (Collection)old.getContents());
    }

    public void reconcileTree(EObject currentRoot, EObject oldRoot) {
        this.reconcileVertex(currentRoot, oldRoot);
        this.reconcileContents(currentRoot, (Collection)currentRoot.eContents(), (Collection)oldRoot.eContents());
    }

    private void reconcileVertex(EObject current, EObject old) {
        if (!$assertionsDisabled && !current.eClass().equals(old.eClass())) {
            throw new AssertionError();
        }
        DecisionMaker[] decisionMakers = this.myConfig.getDecisionMakers(current.eClass());
        int i = 0;
        while (i < decisionMakers.length) {
            DecisionMaker next = decisionMakers[i];
            Decision decision = next.makeDecision(current, old);
            decision.apply(current, old, next.getFeature());
            ++i;
        }
    }

    private void reconcileContents(EObject currentParent, Collection allCurrents, Collection allOlds) {
        if (allCurrents.isEmpty() && allOlds.isEmpty()) {
            return;
        }
        List storage = this.myStoragePool.acquireList();
        this.myMatchingSession.match(allCurrents, allOlds, storage);
        Iterator pairs = storage.iterator();
        while (pairs.hasNext()) {
            Pair next = (Pair)pairs.next();
            EObject nextCurrent = next.current;
            EObject nextOld = next.old;
            if (!$assertionsDisabled && nextCurrent == null && nextOld == null) {
                throw new AssertionError();
            }
            this.myMatchingSession.releasePair(next);
            if (nextCurrent == null && currentParent != null) {
                nextCurrent = this.handleNotMatchedOld(currentParent, nextOld);
            }
            if (nextCurrent != null && nextOld != null) {
                this.reconcileTree(nextCurrent, nextOld);
                continue;
            }
            if (nextOld != null) continue;
            this.handleNotMatchedCurrent(nextCurrent);
        }
        this.myStoragePool.release(storage);
    }

    private static class Pair {
        public EObject current;
        public EObject old;

        private Pair() {
        }

        public void reset() {
            this.current = null;
            this.old = null;
        }
    }

    private class MatchingSession {
        private final Collection myCurrents;
        private final Collection myOlds;
        private final PairsPool myPool;
        private boolean myIsMatching;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.internal.common.reconcile.Reconciler$MatchingSession");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public MatchingSession(PairsPool pool) {
            this.myPool = pool;
            this.myCurrents = new LinkedList();
            this.myOlds = new HashSet();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void match(Collection currents, Collection olds, Collection output) {
            if (!$assertionsDisabled && this.myIsMatching) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.myOlds.isEmpty()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.myCurrents.isEmpty()) {
                throw new AssertionError();
            }
            if (this.myIsMatching) {
                throw new IllegalStateException("FIXME: remove me");
            }
            try {
                Iterator notMatchedOlds;
                this.myIsMatching = true;
                this.myCurrents.addAll(currents);
                this.myOlds.addAll(olds);
                Iterator currentContents = this.myCurrents.iterator();
                while (true) {
                    if (this.myOlds.isEmpty() || !currentContents.hasNext()) {
                        notMatchedOlds = this.myOlds.iterator();
                        break;
                    }
                    EObject nextCurrent = (EObject)currentContents.next();
                    Pair nextPair = this.acquirePair();
                    nextPair.current = nextCurrent;
                    nextPair.old = this.removeMatched(nextCurrent, this.myOlds);
                    output.add(nextPair);
                    currentContents.remove();
                }
                while (notMatchedOlds.hasNext()) {
                    Pair nextPair = this.acquirePair();
                    nextPair.current = null;
                    nextPair.old = (EObject)notMatchedOlds.next();
                    output.add(nextPair);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.myIsMatching = false;
                this.myCurrents.clear();
                this.myOlds.clear();
                throw throwable;
            }
            {
                Object var7_9 = null;
                this.myIsMatching = false;
                this.myCurrents.clear();
                this.myOlds.clear();
                return;
            }
        }

        private EObject removeMatched(EObject current, Collection allOld) {
            EClass eClass = current.eClass();
            Matcher matcher = Reconciler.this.myConfig.getMatcher(eClass);
            EObject result = null;
            if (matcher != Matcher.FALSE) {
                Iterator all = allOld.iterator();
                while (all.hasNext()) {
                    EObject next = (EObject)all.next();
                    if (!eClass.equals(next.eClass()) || !matcher.match(current, next)) continue;
                    result = next;
                    all.remove();
                    break;
                }
            }
            return result;
        }

        private Pair acquirePair() {
            return this.myPool.acquire();
        }

        public void releasePair(Pair pair) {
            this.myPool.release(pair);
        }
    }

    private static class PairsPool
    extends AbstractPool {
        public PairsPool(int capacity) {
            super(capacity);
        }

        public Pair acquire() {
            return (Pair)this.internalAcquire();
        }

        public void release(Pair pair) {
            pair.current = null;
            pair.old = null;
            this.internalRelease(pair);
        }

        protected Object createNew() {
            return new Pair();
        }
    }

    private static class StoragePool
    extends AbstractPool {
        public StoragePool(int capacity) {
            super(capacity);
        }

        public List acquireList() {
            return (List)this.internalAcquire();
        }

        public void release(List list) {
            list.clear();
            this.internalRelease(list);
        }

        protected Object createNew() {
            return new ArrayList();
        }
    }
}

