/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalOwnerShapeEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.AndGateFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.AndGateTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.OrGateFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.OrGateTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.OutputTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.TerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.XOrGateFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.AndGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class LogicGateEditPart
extends TerminalOwnerShapeEditPart {
    public LogicGateEditPart(View view) {
        super(view);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new NonResizableEditPolicyEx();
    }

    protected NodeFigure createMainFigure() {
        if (this.getModel() == null) {
            return null;
        }
        View view = (View)this.getModel();
        EObject semanticElement = view.getElement();
        EClass eClazz = semanticElement.eClass();
        Dimension gateSize = new Dimension(this.getMapMode().DPtoLP(15), this.getMapMode().DPtoLP(17));
        NodeFigure newFigure = eClazz == SemanticPackage.eINSTANCE.getOrGate() ? new OrGateFigure(gateSize) : (eClazz == SemanticPackage.eINSTANCE.getAndGate() ? new AndGateFigure(gateSize) : (eClazz == SemanticPackage.eINSTANCE.getXORGate() ? new XOrGateFigure(gateSize) : null));
        return newFigure;
    }

    protected void refreshBounds() {
        Dimension size = this.getFigure().getSize();
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    public Map createBoundsMap() {
        HashMap<String, Point> boundMap = new HashMap<String, Point>();
        if (this.getModel() == null || !(this.getModel() instanceof View)) {
            return boundMap;
        }
        View view = (View)this.getModel();
        EObject semanticElement = view.getElement();
        EClass eClazz = semanticElement.eClass();
        IMapMode mm = this.getMapMode();
        if (eClazz == SemanticPackage.eINSTANCE.getOrGate()) {
            boundMap.put("A", new Point(mm.DPtoLP(4), mm.DPtoLP(3)));
            boundMap.put("B", new Point(mm.DPtoLP(5), mm.DPtoLP(3)));
            boundMap.put("1", new Point(mm.DPtoLP(5), mm.DPtoLP(9)));
        } else if (eClazz == SemanticPackage.eINSTANCE.getAndGate()) {
            boundMap.put("A", new Point(mm.DPtoLP(4), mm.DPtoLP(3)));
            boundMap.put("B", new Point(mm.DPtoLP(9), mm.DPtoLP(3)));
            boundMap.put("1", new Point(mm.DPtoLP(6), mm.DPtoLP(9)));
        } else {
            boundMap.put("A", new Point(mm.DPtoLP(4), mm.DPtoLP(3)));
            boundMap.put("B", new Point(mm.DPtoLP(5), mm.DPtoLP(3)));
            boundMap.put("1", new Point(mm.DPtoLP(5), mm.DPtoLP(9)));
        }
        return boundMap;
    }

    public NodeFigure createOwnedTerminalFigure(TerminalEditPart terminalEP) {
        Terminal terminal = (Terminal)ViewUtil.resolveSemanticElement((View)((View)terminalEP.getModel()));
        if (terminal == null) {
            return null;
        }
        TerminalFigure theFigure = null;
        int side = 1;
        if (terminal instanceof InputTerminal) {
            theFigure = terminal.eContainer() instanceof AndGate ? new AndGateTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(4), this.getMapMode().DPtoLP(2))) : new OrGateTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(4), this.getMapMode().DPtoLP(4)));
        } else {
            theFigure = new OutputTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(4), this.getMapMode().DPtoLP(5)));
            side = 4;
        }
        terminalEP.setLocator(new BorderItemLocator(this.getFigure(), side));
        return theFigure;
    }
}

