/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.actions.global;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalPrintAction;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalRedoAction;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalUndoAction;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalAction;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalCloseAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalCopyAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalCutAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalDeleteAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalFindAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalMoveAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalOpenAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalPasteAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalPropertiesAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalRefreshAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalRenameAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalRevertAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalSaveAction;
import org.eclipse.gmf.runtime.common.ui.action.internal.actions.global.GlobalSelectAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class GlobalActionManager {
    private Hashtable listOfActions = new Hashtable();
    private Vector listOfActionIds = new Vector();
    private static GlobalActionManager instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalActionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new GlobalActionManager();
    }

    public static GlobalActionManager getInstance() {
        return instance;
    }

    protected GlobalActionManager() {
        this.addActionId(GlobalActionId.CUT);
        this.addActionId(GlobalActionId.COPY);
        this.addActionId(GlobalActionId.PASTE);
        this.addActionId(GlobalActionId.DELETE);
        this.addActionId(GlobalActionId.SELECT_ALL);
        this.addActionId(GlobalActionId.UNDO);
        this.addActionId(GlobalActionId.REDO);
        this.addActionId(GlobalActionId.PRINT);
        this.addActionId("open");
        this.addActionId(GlobalActionId.CLOSE);
        this.addActionId(GlobalActionId.MOVE);
        this.addActionId(GlobalActionId.RENAME);
        this.addActionId(GlobalActionId.FIND);
        this.addActionId(GlobalActionId.PROPERTIES);
        this.addActionId(GlobalActionId.SAVE);
        this.addActionId(GlobalActionId.REFRESH);
        this.addActionId(GlobalActionId.REVERT);
    }

    public GlobalAction getGlobalActionHandler(IWorkbenchPart part, String globalActionId) {
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && globalActionId == null) {
            throw new AssertionError();
        }
        GlobalAction action = null;
        Hashtable<String, GlobalAction> actionList = (Hashtable<String, GlobalAction>)this.getListOfActions().get(part);
        if (actionList != null) {
            action = (GlobalAction)((Object)actionList.get(globalActionId));
            if (action == null) {
                action = this.createActionHandler(part, globalActionId);
                if (action == null) {
                    return action;
                }
                actionList.put(globalActionId, action);
                this.getListOfActions().put(part, actionList);
            }
        } else {
            actionList = new Hashtable<String, GlobalAction>();
            action = this.createActionHandler(part, globalActionId);
            if (action == null) {
                return action;
            }
            actionList.put(globalActionId, action);
            this.getListOfActions().put(part, actionList);
            part.getSite().getPage().addPartListener(new IPartListener(part){
                private IWorkbenchPart localPart;
                {
                    this.localPart = iWorkbenchPart;
                }

                public void partActivated(IWorkbenchPart workbenchPart) {
                }

                public void partBroughtToTop(IWorkbenchPart workbenchPart) {
                }

                public void partClosed(IWorkbenchPart workbenchPart) {
                    if (workbenchPart != null && this.localPart == workbenchPart && GlobalActionManager.this.getListOfActions().containsKey(workbenchPart)) {
                        GlobalActionManager.this.getListOfActions().remove(workbenchPart);
                        workbenchPart.getSite().getPage().removePartListener((IPartListener)this);
                        this.localPart = null;
                    }
                }

                public void partDeactivated(IWorkbenchPart workbenchPart) {
                }

                public void partOpened(IWorkbenchPart workbenchPart) {
                }
            });
        }
        return action;
    }

    public GlobalAction createActionHandler(IWorkbenchPage page, String id) {
        GlobalAction action = null;
        if (id.equals(GlobalActionId.CUT)) {
            action = new GlobalCutAction(page);
        } else if (id.equals(GlobalActionId.COPY)) {
            action = new GlobalCopyAction(page);
        } else if (id.equals(GlobalActionId.PASTE)) {
            action = new GlobalPasteAction(page);
        } else if (id.equals(GlobalActionId.UNDO)) {
            action = new GlobalUndoAction(page);
        } else if (id.equals(GlobalActionId.REDO)) {
            action = new GlobalRedoAction(page);
        } else if (id.equals(GlobalActionId.DELETE)) {
            action = new GlobalDeleteAction(page);
        } else if (id.equals(GlobalActionId.SELECT_ALL)) {
            action = new GlobalSelectAllAction(page);
        } else if (id.equals(GlobalActionId.PRINT)) {
            action = new GlobalPrintAction(page);
        } else if (id.equals(GlobalActionId.MOVE)) {
            action = new GlobalMoveAction(page);
        } else if (id.equals("open")) {
            action = new GlobalOpenAction(page);
        } else if (id.equals(GlobalActionId.CLOSE)) {
            action = new GlobalCloseAction(page);
        } else if (id.equals(GlobalActionId.RENAME)) {
            action = new GlobalRenameAction(page);
        } else if (id.equals(GlobalActionId.REFRESH)) {
            action = new GlobalRefreshAction(page);
        } else if (id.equals(GlobalActionId.REVERT)) {
            action = new GlobalRevertAction(page);
        } else if (id.equals(GlobalActionId.FIND)) {
            action = new GlobalFindAction(page);
        } else if (id.equals(GlobalActionId.PROPERTIES)) {
            action = new GlobalPropertiesAction(page);
        } else if (id.equals(GlobalActionId.SAVE)) {
            action = new GlobalSaveAction(page);
        }
        if (action != null) {
            ((GlobalAction)action).init();
        }
        return action;
    }

    public GlobalAction createActionHandler(IWorkbenchPart part, String id) {
        GlobalAction action = null;
        if (id.equals(GlobalActionId.CUT)) {
            action = new GlobalCutAction(part);
        } else if (id.equals(GlobalActionId.COPY)) {
            action = new GlobalCopyAction(part);
        } else if (id.equals(GlobalActionId.PASTE)) {
            action = new GlobalPasteAction(part);
        } else if (id.equals(GlobalActionId.UNDO)) {
            action = new GlobalUndoAction(part);
        } else if (id.equals(GlobalActionId.REDO)) {
            action = new GlobalRedoAction(part);
        } else if (id.equals(GlobalActionId.DELETE)) {
            action = new GlobalDeleteAction(part);
        } else if (id.equals(GlobalActionId.SELECT_ALL)) {
            action = new GlobalSelectAllAction(part);
        } else if (id.equals(GlobalActionId.PRINT)) {
            action = new GlobalPrintAction(part);
        } else if (id.equals(GlobalActionId.MOVE)) {
            action = new GlobalMoveAction(part);
        } else if (id.equals("open")) {
            action = new GlobalOpenAction(part);
        } else if (id.equals(GlobalActionId.CLOSE)) {
            action = new GlobalCloseAction(part);
        } else if (id.equals(GlobalActionId.RENAME)) {
            action = new GlobalRenameAction(part);
        } else if (id.equals(GlobalActionId.REFRESH)) {
            action = new GlobalRefreshAction(part);
        } else if (id.equals(GlobalActionId.REVERT)) {
            action = new GlobalRevertAction(part);
        } else if (id.equals(GlobalActionId.FIND)) {
            action = new GlobalFindAction(part);
        } else if (id.equals(GlobalActionId.PROPERTIES)) {
            action = new GlobalPropertiesAction(part);
        } else if (id.equals(GlobalActionId.SAVE)) {
            action = new GlobalSaveAction(part);
        }
        if (action != null) {
            ((GlobalAction)action).init();
        }
        return action;
    }

    private Hashtable getListOfActions() {
        return this.listOfActions;
    }

    public GlobalAction[] createGlobalActions(IWorkbenchPart part) {
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        Vector<GlobalAction> list = new Vector<GlobalAction>();
        int i = 0;
        while (i < this.getListOfActionIds().size()) {
            GlobalAction action = this.getGlobalActionHandler(part, (String)this.getListOfActionIds().elementAt(i));
            if (action != null) {
                list.addElement(action);
            }
            ++i;
        }
        GlobalAction[] array = new GlobalAction[list.size()];
        list.copyInto((Object[])array);
        return array;
    }

    public GlobalAction[] createGlobalActions(IWorkbenchPart part, String[] actionIds) {
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && actionIds == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && actionIds.length <= 0) {
            throw new AssertionError();
        }
        Vector<GlobalAction> list = new Vector<GlobalAction>();
        GlobalAction action = null;
        int i = 0;
        while (i < actionIds.length) {
            action = this.getGlobalActionHandler(part, actionIds[i]);
            if (action != null) {
                list.addElement(action);
            }
            ++i;
        }
        GlobalAction[] array = new GlobalAction[list.size()];
        list.copyInto((Object[])array);
        return array;
    }

    public GlobalAction getGlobalAction(IWorkbenchPart part, String actionId) {
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && actionId == null) {
            throw new AssertionError();
        }
        GlobalAction action = null;
        Hashtable actionList = (Hashtable)this.getListOfActions().get(part);
        if (actionList != null) {
            action = (GlobalAction)((Object)actionList.get(actionId));
        }
        return action;
    }

    public void setGlobalActionHandlers(IActionBars bar, IWorkbenchPart part) {
        Hashtable actionList;
        if (!$assertionsDisabled && bar == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        if (!this.getListOfActions().containsKey(part)) {
            this.createGlobalActions(part);
        }
        if ((actionList = (Hashtable)this.getListOfActions().get(part)) == null) {
            return;
        }
        Enumeration enumeration = actionList.elements();
        while (enumeration.hasMoreElements()) {
            IAction action = (IAction)enumeration.nextElement();
            if (action.getId() == null) continue;
            bar.setGlobalActionHandler(action.getId(), action);
        }
        bar.updateActionBars();
    }

    public void unSetGlobalActionHandlers(IActionBars bar, IWorkbenchPart part) {
        Hashtable actionList;
        if (!$assertionsDisabled && bar == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        if (!this.getListOfActions().containsKey(part)) {
            this.createGlobalActions(part);
        }
        if ((actionList = (Hashtable)this.getListOfActions().get(part)) == null) {
            return;
        }
        Enumeration enumeration = actionList.elements();
        while (enumeration.hasMoreElements()) {
            IAction action = (IAction)enumeration.nextElement();
            if (action.getId() == null) continue;
            bar.setGlobalActionHandler(action.getId(), null);
        }
        bar.updateActionBars();
    }

    public void refreshGlobalActions(IWorkbenchPart part) {
        if (!$assertionsDisabled && part == null) {
            throw new AssertionError();
        }
        if (!this.getListOfActions().containsKey(part)) {
            return;
        }
        Hashtable actionList = (Hashtable)this.getListOfActions().get(part);
        if (actionList == null) {
            return;
        }
        Enumeration enumeration = actionList.elements();
        while (enumeration.hasMoreElements()) {
            ((GlobalAction)((Object)enumeration.nextElement())).refresh();
        }
    }

    private Vector getListOfActionIds() {
        return this.listOfActionIds;
    }

    protected void addActionId(String actionId) {
        this.getListOfActionIds().addElement(actionId);
    }
}

