/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.util.IPartSelector;
import org.eclipse.gmf.runtime.common.ui.util.PartListenerAdapter;
import org.eclipse.gmf.runtime.common.ui.util.StatusLineUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractActionHandler
extends Action
implements IDisposableAction,
IActionWithProgress,
ISelectionChangedListener,
IOperationHistoryListener,
IPropertyListener {
    private boolean setup;
    private boolean disposed;
    private IWorkbenchPart workbenchPart;
    private IWorkbenchPage workbenchPage;
    private IPartListener partListener;
    private IPartSelector partSelector;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected AbstractActionHandler(IWorkbenchPart workbenchPart) {
        if (!$assertionsDisabled && workbenchPart == null) {
            throw new AssertionError((Object)"null workbenchPart");
        }
        this.setWorkbenchPart(workbenchPart);
        this.workbenchPage = workbenchPart.getSite().getPage();
        this.partListener = new PartListenerAdapter(){

            public void partClosed(IWorkbenchPart part) {
                if (AbstractActionHandler.this.getWorkbenchPart() == part) {
                    AbstractActionHandler.this.dispose();
                }
            }
        };
        this.workbenchPage.addPartListener(this.partListener);
    }

    protected AbstractActionHandler(IWorkbenchPage workbenchPage) {
        if (!$assertionsDisabled && workbenchPage == null) {
            throw new AssertionError((Object)"null workbenchPage");
        }
        this.workbenchPage = workbenchPage;
        this.partListener = new PartListenerAdapter(){

            public void partActivated(IWorkbenchPart part) {
                AbstractActionHandler.this.setWorkbenchPart(part);
                if (part != null && AbstractActionHandler.this.contributedToPart(part)) {
                    AbstractActionHandler.this.refresh();
                }
            }
        };
        workbenchPage.addPartListener(this.partListener);
    }

    public void init() {
        this.setDisposed(false);
        if (this.getWorkbenchPart() == null) {
            this.setWorkbenchPart(this.getWorkbenchPage().getActivePart());
        }
        if (this.getWorkbenchPart() != null) {
            this.refresh();
        }
    }

    public void dispose() {
        this.setWorkbenchPart(null);
        if (this.partListener != null && this.workbenchPage != null) {
            this.workbenchPage.removePartListener(this.partListener);
            this.workbenchPage = null;
            this.partListener = null;
        }
        this.setDisposed(true);
    }

    protected void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        ISelectionProvider provider;
        if (this.getWorkbenchPart() == workbenchPart) {
            return;
        }
        if (this.getWorkbenchPart() != null) {
            if (this.isSelectionListener() && (provider = this.getWorkbenchPart().getSite().getSelectionProvider()) != null) {
                provider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.isPropertyListener()) {
                this.getWorkbenchPart().removePropertyListener((IPropertyListener)this);
            }
            if (this.isOperationHistoryListener()) {
                this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
            }
        }
        this.workbenchPart = workbenchPart;
        if (workbenchPart != null && this.contributedToPart(workbenchPart)) {
            if (this.isSelectionListener() && (provider = this.getWorkbenchPart().getSite().getSelectionProvider()) != null) {
                provider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.isPropertyListener()) {
                this.getWorkbenchPart().addPropertyListener((IPropertyListener)this);
            }
            if (this.isOperationHistoryListener()) {
                this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
            }
        }
    }

    protected boolean contributedToPart(IWorkbenchPart part) {
        return this.partSelector == null || this.partSelector.selects(this.workbenchPart);
    }

    public final void setPartSelector(IPartSelector partSelector) {
        if (this.partSelector == partSelector) {
            return;
        }
        this.partSelector = partSelector;
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null && !partSelector.selects(part)) {
            ISelectionProvider provider;
            if (this.isSelectionListener() && (provider = this.getWorkbenchPart().getSite().getSelectionProvider()) != null) {
                provider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.isPropertyListener()) {
                this.getWorkbenchPart().removePropertyListener((IPropertyListener)this);
            }
            if (this.isOperationHistoryListener()) {
                this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
            }
        }
    }

    protected final IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    protected ActionManager getActionManager() {
        ActionManager manager = null;
        IWorkbenchPart wbPart = this.getWorkbenchPart();
        if (wbPart != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.ActionManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            manager = (ActionManager)wbPart.getAdapter((Class)clazz);
        }
        return manager == null ? ActionManager.getDefault() : manager;
    }

    protected IOperationHistory getOperationHistory() {
        return this.getActionManager().getOperationHistory();
    }

    public void run() {
        this.getActionManager().run(this);
    }

    public void run(IProgressMonitor progressMonitor) {
        if (this.isSetup() || !this.needsSetup()) {
            try {
                StatusLineUtil.outputErrorMessage(this.getWorkbenchPart(), "");
                this.doRun(progressMonitor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        } else {
            throw new IllegalStateException("action must be setup before it is run");
        }
        this.setSetup(false);
    }

    public void runWithEvent(Event event) {
        this.getActionManager().run(this);
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        this.refresh();
    }

    public void propertyChanged(Object source, int propId) {
    }

    public String getLabel() {
        return this.getText();
    }

    protected ISelection getSelection() {
        ISelection selection = null;
        ISelectionProvider selectionProvider = this.getWorkbenchPart().getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selection = selectionProvider.getSelection();
        }
        return selection != null ? selection : StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getStructuredSelection() {
        StructuredSelection selection = null;
        ISelectionProvider selectionProvider = null;
        if (this.getWorkbenchPart() != null) {
            selectionProvider = this.getWorkbenchPart().getSite().getSelectionProvider();
        }
        if (selectionProvider != null && selectionProvider.getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)selectionProvider.getSelection();
        }
        return selection != null ? selection : StructuredSelection.EMPTY;
    }

    public boolean isRunnable() {
        return this.isEnabled();
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected boolean isPropertyListener() {
        return false;
    }

    protected boolean isOperationHistoryListener() {
        return false;
    }

    protected void handle(Exception exception) {
        Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"handle", (Throwable)exception);
        Status status = new Status(4, CommonUIPlugin.getPluginId(), 3, String.valueOf(exception.getMessage()), (Throwable)exception);
        Log.log((Plugin)CommonUIPlugin.getDefault(), (IStatus)status);
        this.openErrorDialog((IStatus)status);
    }

    protected void openErrorDialog(final IStatus status) {
        final Display workbenchDisplay = PlatformUI.getWorkbench().getDisplay();
        if (workbenchDisplay.getThread() == Thread.currentThread()) {
            ErrorDialog.openError((Shell)workbenchDisplay.getActiveShell(), (String)AbstractActionHandler.removeMnemonics((String)this.getLabel()), null, (IStatus)status);
        } else {
            workbenchDisplay.asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)workbenchDisplay.getActiveShell(), (String)AbstractActionHandler.removeMnemonics((String)AbstractActionHandler.this.getLabel()), null, (IStatus)status);
                }
            });
        }
    }

    protected abstract void doRun(IProgressMonitor var1);

    public IActionWithProgress.WorkIndicatorType getWorkIndicatorType() {
        return IActionWithProgress.WorkIndicatorType.BUSY;
    }

    protected IPartListener getPartListener() {
        return this.partListener;
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoContext partContext;
        IUndoableOperation operation = event.getOperation();
        if (operation != null && (partContext = this.getUndoContext()) != null && operation.hasContext(partContext)) {
            this.refresh();
        }
    }

    protected IUndoContext getUndoContext() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IUndoContext)part.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void setDisposed(boolean b) {
        this.disposed = b;
    }

    public boolean setup() {
        this.setSetup(true);
        return true;
    }

    public boolean isSetup() {
        return this.setup;
    }

    protected void setSetup(boolean setup) {
        this.setup = setup;
    }

    protected boolean needsSetup() {
        return false;
    }
}

