/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gmf.runtime.common.ui.contentassist.ContentAssistantHelper;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.gmf.runtime.common.ui.util.IEditStringProvider;
import org.eclipse.gmf.runtime.common.ui.util.IInlineTextActionHandler;
import org.eclipse.gmf.runtime.common.ui.util.InlineTextActionHandler;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class TreeInlineTextEditor {
    private TreeEditor treeEditor;
    private Tree tree;
    private Text textEditor;
    private Composite textEditorParent;
    private static final Rectangle nullRectangle = new Rectangle(0, 0, 0, 0);
    private String finalText;
    private String initialText;
    private IEditStringProvider editStringProvider;
    private TreeItem treeItem;
    private TreeViewer viewer;
    private IInlineTextActionHandler textActionHandler;
    private boolean isF2disabled;
    private volatile boolean inEndEdit;
    private ContentAssistHandler contentAssistHandler = null;
    private Color proposalPopupBackgroundColor;
    private Color proposalPopupForegroundColor;

    private boolean isF2disabled() {
        return this.isF2disabled;
    }

    private void setIsF2disabled(boolean isF2disabled) {
        this.isF2disabled = isF2disabled;
    }

    private TreeViewer getTreeViewer() {
        return this.viewer;
    }

    private void setTreeViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    private TreeItem getTreeItem() {
        return this.treeItem;
    }

    private IEditStringProvider getEditStringProvider() {
        return this.editStringProvider;
    }

    private TreeEditor getTreeEditor() {
        return this.treeEditor;
    }

    private void setTreeEditor(TreeEditor treeEditor) {
        this.treeEditor = treeEditor;
    }

    public TreeInlineTextEditor(TreeViewer treeViewer, IActionBars actionBars, List disableActionsIds, IEditStringProvider editStringProvider) {
        this(treeViewer, editStringProvider, false);
        this.initTextActionHandler(actionBars, disableActionsIds);
    }

    public TreeInlineTextEditor(TreeViewer treeViewer, IEditStringProvider editStringProvider, boolean isF2disabled) {
        this.setTreeViewer(treeViewer);
        this.setTree(treeViewer.getTree());
        this.setIsF2disabled(isF2disabled);
        this.setEditStringProvider(editStringProvider);
        this.createControl();
        this.init();
    }

    public boolean isDisposed() {
        return this.getTextEditorParent() == null || this.getTextEditorParent().isDisposed();
    }

    public boolean canEdit() {
        return !this.isDisposed() && !this.getTree().isDisposed() && this.getTree().getEnabled() && this.getTree().getVisible() && this.isSelectedItemEditable();
    }

    private boolean isSelectedItemEditable() {
        return this.getTree().getSelection().length == 1 && !this.getTree().getSelection()[0].isDisposed() && this.getTree().getSelection()[0].getData() != null && this.getEditStringProvider().canEdit(this.getTree().getSelection()[0].getData());
    }

    public void startEdit() {
        if (this.canEdit()) {
            this.cancelEdit();
            this.setTreeItem(this.getTree().getSelection()[0]);
            this.setInitialText(this.getEditStringProvider().getEditString(this.getTreeItem().getData()));
            this.getTextEditor().setText(this.getInitialText());
            this.getTreeEditor().setItem(this.getTreeItem());
            this.show();
        }
    }

    public void cancelEdit() {
        if (this.canProceed()) {
            this.hide();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endEdit() {
        if (this.inEndEdit) {
            return;
        }
        this.inEndEdit = true;
        try {
            if (this.canProceed()) {
                this.setFinalText(this.getCurrentText());
                if (!this.getFinalText().equals(this.getInitialText())) {
                    final Object obj = this.getTreeItem().getData();
                    this.getEditStringProvider().setEditString(obj, this.getFinalText());
                    this.getTreeItem().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!TreeInlineTextEditor.this.isDisposed()) {
                                TreeInlineTextEditor.this.getTreeViewer().update(obj, null);
                            }
                        }
                    });
                    this.hide();
                } else {
                    this.hide();
                }
            }
            Object var2_4 = null;
            this.inEndEdit = false;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.inEndEdit = false;
            throw throwable;
        }
    }

    protected void openErrorDialog(IStatus status) {
        ErrorDialog.openError((Shell)this.getShell(), (String)CommonUIMessages.TreeInlineTextEditor_errorDialogTitle, null, (IStatus)status);
    }

    private Shell getShell() {
        return this.getTree().getShell();
    }

    private boolean canProceed() {
        return !this.isDisposed() && this.getTreeItem() != null;
    }

    private void show() {
        IContentAssistProcessor processor;
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.uninstallContentAssist(false);
        if (this.getTreeItem() != null && (processor = this.getEditStringProvider().getCompletionProcessor(this.getTreeItem().getData())) != null) {
            this.contentAssistHandler = ContentAssistantHelper.createTextContentAssistant(this.getTextEditor(), this.proposalPopupForegroundColor, this.proposalPopupBackgroundColor, processor);
        }
        this.getTextEditorParent().setVisible(true);
        this.adjustTextEditorBounds();
        this.getTextEditorParent().redraw();
        this.getTextEditor().selectAll();
        this.getTextEditor().setFocus();
        if (this.getTextActionHandler() != null) {
            this.getTextActionHandler().hookHandlers();
        }
    }

    private void hide() {
        this.setTreeItem(null);
        this.getTreeEditor().setItem(null);
        this.getTextEditorParent().setBounds(this.getNullRectangle());
        this.getTextEditorParent().setVisible(false);
        if (this.getTextActionHandler() != null) {
            this.getTextActionHandler().unHookHandlers();
        }
        this.uninstallContentAssist(true);
    }

    private void uninstallContentAssist(boolean fork) {
        if (this.contentAssistHandler != null) {
            final ContentAssistHandler localHandler = this.contentAssistHandler;
            this.contentAssistHandler = null;
            if (fork) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        localHandler.setEnabled(false);
                    }
                });
            } else {
                localHandler.setEnabled(false);
            }
        }
    }

    public void dispose() {
        if (this.getTextEditorParent() != null) {
            if (this.getTextActionHandler() != null) {
                this.getTextActionHandler().dispose();
            }
            this.setTextActionHandler(null);
            this.setTextEditorParent(null);
            this.setTextEditor(null);
            this.getTreeEditor().setEditor(null, null);
            this.setTreeEditor(null);
            this.setTree(null);
            this.proposalPopupBackgroundColor.dispose();
            this.proposalPopupForegroundColor.dispose();
        }
    }

    private void createControl() {
        this.setTextEditorParent(new Composite((Composite)this.getTree(), 0));
        this.setTreeEditor(new TreeEditor(this.getTree()));
        this.getTreeEditor().horizontalAlignment = 16384;
        this.getTreeEditor().grabHorizontal = true;
        this.getTreeEditor().setEditor((Control)this.getTextEditorParent(), null);
        this.getTextEditorParent().setVisible(false);
        this.setTextEditor(new Text(this.getTextEditorParent(), 0));
        this.getTextEditorParent().setBackground(this.getTextEditor().getBackground());
        this.proposalPopupBackgroundColor = new Color((Device)this.getShell().getDisplay(), new RGB(254, 241, 233));
        this.proposalPopupForegroundColor = new Color((Device)this.getShell().getDisplay(), new RGB(0, 0, 0));
    }

    private void init() {
        this.getTextEditorParent().addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = TreeInlineTextEditor.this.getTextEditor().getSize();
                Point parentSize = TreeInlineTextEditor.this.getTextEditorParent().getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.getTextEditor().addListener(24, new Listener(){

            public void handleEvent(Event e) {
                TreeInlineTextEditor.this.adjustTextEditorBounds();
                TreeInlineTextEditor.this.getTextEditorParent().redraw();
            }
        });
        this.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    TreeInlineTextEditor.this.endEdit();
                } else if (event.character == '\u001b') {
                    TreeInlineTextEditor.this.cancelEdit();
                }
            }
        });
        this.getTextEditor().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent fe) {
                Shell activeShell = fe.display.getActiveShell();
                if (activeShell != null && TreeInlineTextEditor.this.getTextEditor().getShell().equals(activeShell.getParent())) {
                    return;
                }
                if (!TreeInlineTextEditor.this.getTreeViewer().getSelection().isEmpty() && TreeInlineTextEditor.this.canProceed()) {
                    Object obj = TreeInlineTextEditor.this.getTreeItem().getData();
                    TreeInlineTextEditor.this.getTreeItem().getDisplay().asyncExec(new Runnable(this, obj){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ Object val$obj;
                        {
                            this.this$1 = var1_1;
                            this.val$obj = object;
                        }

                        public void run() {
                            if (!6.access$0(this.this$1).isDisposed()) {
                                TreeInlineTextEditor.access$0(6.access$0(this.this$1)).update(this.val$obj, null);
                            }
                        }
                    });
                }
                TreeInlineTextEditor.this.endEdit();
            }

            static /* synthetic */ TreeInlineTextEditor access$0(6 var0) {
                return var0.TreeInlineTextEditor.this;
            }
        });
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeInlineTextEditor.this.cancelEdit();
            }
        });
        if (!this.isF2disabled()) {
            this.getTree().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent event) {
                    if (event.keyCode == 0x100000B) {
                        TreeInlineTextEditor.this.startEdit();
                    }
                }
            });
        }
    }

    private void initTextActionHandler(IActionBars actionBars, List disableActionsIds) {
        if (actionBars == null) {
            return;
        }
        actionBars.getMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeInlineTextEditor.this.cancelEdit();
            }
        });
        this.setTextActionHandler(new InlineTextActionHandler(actionBars, this.getTextEditor(), disableActionsIds));
    }

    private void adjustTextEditorBounds() {
        Point textSize = this.getTextEditor().computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.getTextEditorParent().getSize();
        this.getTextEditor().setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
    }

    private Tree getTree() {
        return this.tree;
    }

    public String getCurrentText() {
        return this.canProceed() ? this.getTextEditor().getText() : null;
    }

    public String getInitialText() {
        return this.initialText;
    }

    public String getFinalText() {
        return this.finalText;
    }

    private Text getTextEditor() {
        return this.textEditor;
    }

    private Composite getTextEditorParent() {
        return this.textEditorParent;
    }

    private void setEditStringProvider(IEditStringProvider editStringProvider) {
        this.editStringProvider = editStringProvider;
    }

    private void setTextEditor(Text textEditor) {
        this.textEditor = textEditor;
    }

    private void setTextEditorParent(Composite textEditorParent) {
        this.textEditorParent = textEditorParent;
    }

    private void setTree(Tree tree) {
        this.tree = tree;
    }

    private void setTreeItem(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    private Rectangle getNullRectangle() {
        return nullRectangle;
    }

    private void setFinalText(String finalText) {
        this.finalText = finalText;
    }

    private void setInitialText(String initialText) {
        this.initialText = initialText;
    }

    private IInlineTextActionHandler getTextActionHandler() {
        return this.textActionHandler;
    }

    private void setTextActionHandler(IInlineTextActionHandler textActionHandler) {
        this.textActionHandler = textActionHandler;
    }
}

