/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.core.internal.util.ReferenceVisitor;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypeDebugOptions;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.osgi.util.NLS;

public class DestroyElementCommand
extends EditElementCommand {
    private final EObject elementToDestroy;
    static /* synthetic */ Class class$0;

    public DestroyElementCommand(DestroyElementRequest request) {
        super(request.getLabel(), request.getContainer(), request);
        this.elementToDestroy = request.getElementToDestroy();
    }

    public static void destroy(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null) {
            DestroyElementRequest destroy = new DestroyElementRequest(TransactionUtil.getEditingDomain((Resource)resource), eObject, false);
            IElementType context = ElementTypeRegistry.getInstance().getElementType(destroy.getEditHelperContext());
            ICommand command = context.getEditCommand(destroy);
            if (command != null) {
                try {
                    command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    EMFTypePlugin eMFTypePlugin = EMFTypePlugin.getPlugin();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.catching((Plugin)eMFTypePlugin, (String)EMFTypeDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"destroy(EObject)", (Throwable)e);
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)4, (String)NLS.bind((String)EMFTypeCoreMessages.destroyCommandFailed, (Object)context.getDisplayName()), (Throwable)e);
                }
            }
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject destructee = this.getElementToDestroy();
        if (destructee != null && destructee.eResource() != null) {
            this.tearDownIncomingReferences(destructee);
            this.tearDownOutgoingReferences(destructee);
            EcoreUtil.remove((EObject)destructee);
            Resource res = destructee.eResource();
            if (res != null) {
                res.getContents().remove((Object)destructee);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected void tearDownIncomingReferences(EObject destructee) {
        TearDownVisitor visitor = new TearDownVisitor(this.getElementToDestroy());
        visitor.visitReferencers();
        visitor.tearDownReferences();
    }

    protected void tearDownOutgoingReferences(EObject destructee) {
        Iterator iter = destructee.eClass().getEAllReferences().iterator();
        while (iter.hasNext()) {
            EReference reference = (EReference)iter.next();
            if (!reference.isChangeable() || reference.isDerived() || reference.isContainer() || reference.isContainment() || reference.getEOpposite() != null || !destructee.eIsSet((EStructuralFeature)reference)) continue;
            destructee.eUnset((EStructuralFeature)reference);
        }
    }

    protected EObject getElementToDestroy() {
        return this.elementToDestroy;
    }

    public boolean canExecute() {
        return this.elementToDestroy != null && this.elementToDestroy.eResource() != null;
    }

    private static class TearDownVisitor
    extends ReferenceVisitor {
        private List tearDownActions = null;

        TearDownVisitor(EObject elementToRemove) {
            super(elementToRemove);
        }

        protected void visitedReferencer(EReference reference, EObject referencer) {
            if (reference.isChangeable() && !reference.isDerived() && !reference.isContainer()) {
                if (this.tearDownActions == null) {
                    this.tearDownActions = new ArrayList();
                }
                this.tearDownActions.add(new Runnable(this, referencer, reference){
                    final /* synthetic */ TearDownVisitor this$1;
                    private final /* synthetic */ EObject val$referencer;
                    private final /* synthetic */ EReference val$reference;
                    {
                        this.this$1 = tearDownVisitor;
                        this.val$referencer = eObject;
                        this.val$reference = eReference;
                    }

                    public void run() {
                        EcoreUtil.remove((EObject)this.val$referencer, (EStructuralFeature)this.val$reference, (Object)TearDownVisitor.access$0(this.this$1));
                    }
                });
            }
        }

        void tearDownReferences() {
            if (this.tearDownActions != null) {
                Iterator iter = this.tearDownActions.iterator();
                while (iter.hasNext()) {
                    ((Runnable)iter.next()).run();
                }
            }
        }

        static /* synthetic */ EObject access$0(TearDownVisitor tearDownVisitor) {
            return tearDownVisitor.referencedObject;
        }
    }
}

