/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public abstract class EditElementCommand
extends AbstractTransactionalCommand {
    private EObject elementToEdit;
    private final IEditCommandRequest request;
    private EClass eClass = null;

    protected EditElementCommand(String label, EObject elementToEdit, IEditCommandRequest request) {
        super(request.getEditingDomain(), label, EditElementCommand.getAffectedFiles(request));
        this.elementToEdit = elementToEdit;
        this.request = request;
    }

    protected static List getAffectedFiles(IEditCommandRequest request) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        List elements = request.getElementsToEdit();
        if (elements != null) {
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                IFile file;
                Resource resource = ((EObject)i.next()).eResource();
                if (resource == null || (file = WorkspaceSynchronizer.getFile((Resource)resource)) == null) continue;
                result.add(file);
            }
        }
        return result;
    }

    public boolean canExecute() {
        if (this.getEClass() != null) {
            return this.getEClass().isSuperTypeOf(this.getEClassToEdit());
        }
        return true;
    }

    protected EObject getElementToEdit() {
        return this.elementToEdit;
    }

    protected EClass getEClassToEdit() {
        return this.getElementToEdit().eClass();
    }

    protected void setElementToEdit(EObject element) {
        this.elementToEdit = element;
    }

    protected IEditCommandRequest getRequest() {
        return this.request;
    }

    protected EClass getEClass() {
        return this.eClass;
    }

    protected void setEClass(EClass eClass) {
        this.eClass = eClass;
    }

    protected boolean isOK(CommandResult commandResult) {
        return commandResult.getStatus().getCode() == 0;
    }
}

