/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.requests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;

public class DestroyDependentsRequest
extends DestroyRequest {
    private EObject elementToDestroy;
    private final Set dependentElementsToDestroy = new HashSet();
    private final Set immutableViewOfDependents = Collections.unmodifiableSet(this.dependentElementsToDestroy);

    public DestroyDependentsRequest(TransactionalEditingDomain editingDomain, EObject elementToDestroy, boolean confirmationRequired) {
        super(editingDomain, confirmationRequired);
        this.dependentElementsToDestroy.add(elementToDestroy);
        this.elementToDestroy = elementToDestroy;
    }

    public final EObject getElementToDestroy() {
        return this.elementToDestroy;
    }

    public final void setElementToDestroy(EObject elementToDestroy) {
        this.elementToDestroy = elementToDestroy;
    }

    public EObject getContainer() {
        if (this.getElementToDestroy() != null) {
            return this.getElementToDestroy().eContainer();
        }
        return null;
    }

    public List getElementsToEdit() {
        if (this.getElementToDestroy() != null) {
            return Collections.singletonList(this.getElementToDestroy());
        }
        return super.getElementsToEdit();
    }

    protected String getDefaultLabel() {
        return EMFTypeCoreMessages.Request_Label_DestroyDependents;
    }

    public Object getEditHelperContext() {
        IClientContext context = this.getClientContext();
        if (context == null) {
            return this.getElementToDestroy();
        }
        return new EditHelperContext(this.getElementToDestroy(), context);
    }

    public TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain result = super.getEditingDomain();
        if (result == null) {
            result = TransactionUtil.getEditingDomain((EObject)this.getElementToDestroy());
        }
        return result;
    }

    protected final Set internalGetDependentElementsToDestroy() {
        return this.dependentElementsToDestroy;
    }

    public final Set getDependentElementsToDestroy() {
        return this.immutableViewOfDependents;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICommand getDestroyDependentCommand(EObject dependent) {
        ICommand result = null;
        if (!this.addDependentElementToDestroy(dependent)) return result;
        EObject elementBeingDestroyed = this.getElementToDestroy();
        try {
            DestroyElementRequest destroy = new DestroyElementRequest(this.getEditingDomain(), dependent, this.isConfirmationRequired());
            destroy.addParameters(this.getParameters());
            destroy.setParameter("DestroyElementRequest.destroyDependentsRequest", this);
            this.setElementToDestroy(dependent);
            IElementType context = ElementTypeRegistry.getInstance().getElementType(destroy.getEditHelperContext());
            if (context != null) {
                result = context.getEditCommand(destroy);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setElementToDestroy(elementBeingDestroyed);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.setElementToDestroy(elementBeingDestroyed);
            return result;
        }
    }

    public ICommand getDestroyDependentsCommand(Collection dependents) {
        ICommand result = null;
        Iterator i = dependents.iterator();
        while (i.hasNext()) {
            result = CompositeCommand.compose(result, (ICommand)this.getDestroyDependentCommand((EObject)i.next()));
        }
        return result;
    }

    protected boolean addDependentElementToDestroy(EObject dependent) {
        if (dependent == null) {
            throw new NullPointerException("dependent is null");
        }
        if (dependent == this.getElementToDestroy()) {
            throw new IllegalArgumentException("dependent is the element being destroyed");
        }
        if (!this.isElementToBeDestroyed(dependent)) {
            return this.internalGetDependentElementsToDestroy().add(dependent);
        }
        return false;
    }

    protected boolean isElementToBeDestroyed(EObject eObject) {
        boolean result = false;
        while (!result && eObject != null) {
            result = eObject == this.getElementToDestroy() || this.internalGetDependentElementsToDestroy().contains(eObject);
            eObject = eObject.eContainer();
        }
        return result;
    }
}

