/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.handles;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.CollapseFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.CompartmentCollapseTracker;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class CompartmentCollapseHandle
extends AbstractHandle
implements PropertyChangeListener,
NotificationListener {
    public static Dimension SIZE = new Dimension(11, 11);
    protected CollapseFigure collapseFigure = null;

    public CompartmentCollapseHandle(IGraphicalEditPart owner) {
        DrawerStyle style;
        this.setOwner(owner);
        this.setLocator(new CollapseHandleLocator());
        this.setCursor(Cursors.ARROW);
        this.setSize(SIZE);
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.collapseFigure = new CollapseFigure();
        this.add((IFigure)this.collapseFigure);
        View view = owner.getNotationView();
        if (view != null && (style = (DrawerStyle)view.getStyle(NotationPackage.eINSTANCE.getDrawerStyle())) != null) {
            this.collapseFigure.setCollapsed(style.isCollapsed());
            return;
        }
        this.collapseFigure.setCollapsed(false);
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        IFigure found = super.findFigureAt(x, y, search);
        return ((Object)((Object)this.collapseFigure)).equals(found) ? this : found;
    }

    protected DragTracker createDragTracker() {
        return new CompartmentCollapseTracker((IResizableCompartmentEditPart)this.getOwner());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(Properties.ID_COLLAPSED)) {
            this.collapseFigure.setCollapsed((Boolean)evt.getNewValue());
        }
    }

    public void notifyChanged(Notification notification) {
        if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == notification.getFeature()) {
            this.collapseFigure.setCollapsed(notification.getNewBooleanValue());
        }
    }

    public void addNotify() {
        super.addNotify();
        IGraphicalEditPart owner = (IGraphicalEditPart)this.getOwner();
        View view = owner.getNotationView();
        if (view != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)owner.getNotationView(), (NotificationListener)this);
        }
    }

    public void removeNotify() {
        IGraphicalEditPart owner = (IGraphicalEditPart)this.getOwner();
        this.getDiagramEventBroker().removeNotificationListener((EObject)owner.getNotationView(), (NotificationListener)this);
        super.removeNotify();
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getOwner()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    private class CollapseHandleLocator
    implements Locator {
        private CollapseHandleLocator() {
        }

        public void relocate(IFigure target) {
            Rectangle theBounds = CompartmentCollapseHandle.this.getOwnerFigure().getClientArea().getCopy();
            CompartmentCollapseHandle.this.getOwnerFigure().translateToAbsolute((Translatable)theBounds);
            target.translateToRelative((Translatable)theBounds);
            target.setLocation(theBounds.getLocation());
        }
    }
}

